<?php
get_header();
?>
<div class="col eight">
    <section class="content">
        <div id="error404-container">
            <h3 class="error404"><?php _e("Sorry, the post you are looking for is not available. Maybe you need to perform a search?", "themeton");?></h3>

            <?php get_search_form(); ?>
            <br/>

            <div class="tt-404-error"><p><?php _e("For best search results, mind the following suggestions:", "themeton");?></p>
                <ul class="borderlist">
                    <li><?php _e("Always double check your spelling.", "themeton");?></li>
                    <li><?php _e("Try similar keywords, for example: tablet instead of laptop.", "themeton");?></li>
                    <li><?php _e("Try using more than one keyword.", "themeton");?></li>
                </ul>
            </div>
        </div>
    </section>
</div>
<div class="col four">
    <div id="sidebar" class="right-sidebar">
        <aside class="widget" id="page-list-404">
            <h3 class="widget-title"><?php _e("All Pages", "themeton");?><span class="tt-element-title-border"></span></h3>
            <ul>
                <?php
                $args = array(
                    'depth' => 0,
                    'show_date' => '',
                    'date_format' => get_option('date_format'),
                    'child_of' => 0,
                    'exclude' => '',
                    'include' => '',
                    'title_li' => '',
                    'echo' => 1,
                    'authors' => '',
                    'sort_column' => 'menu_order, post_title',
                    'link_before' => '',
                    'link_after' => '',
                    'walker' => '',
                    'post_type' => 'page',
                    'post_status' => 'publish'
                );
                ?>
                <?php wp_list_pages($args); ?>
            </ul>
        </aside>
        <aside class="widget" id="archives-error-404">
            <h3 class="widget-title"><?php _e("Archives", "themeton");?><span class="tt-element-title-border"></span></h3>
            <ul>
                <?php
                $args2 = array(
                    'type' => 'monthly',
                    'limit' => '',
                    'format' => 'html',
                    'before' => '',
                    'after' => '',
                    'show_post_count' => false,
                    'echo' => 1,
                    'order' => 'DESC'
                );
                ?>

                <?php wp_get_archives($args2); ?>
            </ul>
        </aside>

    </div>
</div>

<?php
get_footer();
?>