<?php
global $staticWidths;
$defaultWidth = !empty($staticWidths['recent_posts']) ? $staticWidths['recent_posts'] : 'size_col_3_1';

$post_cats = $portfolio_cats = '<option value="0">All</option>';

$post_terms = get_categories("hide_empty=0");
foreach ($post_terms as $term) {
    $post_cats .= '<option value="' . $term->slug . '">' . $term->name . '</option>';
}

$post_terms = get_terms('portfolios', 'hide_empty=0');
if(is_array($post_terms)) {
    foreach ($post_terms as $term) {
        $portfolio_cats .= '<option value="' . $term->slug . '">' . $term->name . '</option>';
    }
}

$cb_toolbar_title[] = "Recent posts";
$cb_toolbar_video[] = "http://docs.themeton.com/emerald/2013/02/recent-posts/";
$cb_toolbar_width[] = $defaultWidth;
$cb_toolbar_html[] = '<div class="cb_hidden_form">
                        <div class="cb_form_wrapper">
                            <div class="tt-title-container">
                                <div class="tt-head-element add_item_medium">
                                    <input type="text" class="cbf_title" placeholder="Title of Item" />
                                </div>
                                <div class="tt-head-element add_item">
                                    <select name="cbf_title_style" class="cbf_title_style default_value">
                                        <option value="1">H1</option>
                                        <option value="2">H2</option>
                                        <option value="3">H3</option>
                                        <option value="4">H4</option>
                                        <option value="5">H5</option>
                                    </select>
                                </div>
                                <div class="tt-head-element add_item">
                                    <div class="color_selector">
                                        <div class="color_picker" id="skin_background_color"><div style="background-color: #701010;" class="color_picker_inner"></div></div>
                                        <input type="text" class="color_picker_value" name="skin_background_color"  value="#701010">
                                    </div>
                                </div>
                                <div class="tt-head-element add_item_medium">
                                    <input type="text" class="cbf_custom_class" placeholder="Custom class" />
                                </div>
                            </div>                            
                            <div class="clear"></div>
                            
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Post type</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select class="cbf_post_type">
                                        <option value="post">Post</option>
                                        <option value="portfolio">Portfolio</option>
                                    </select>
                                </div>
                            </div>                            
                            <div class="tt-elements-container cb_post">
                                <div class="tt-title-element title-element">
                                    <label>Category</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select class="default_carousel cbf_post_category">' . $post_cats . '</select>
                                </div>
                                <div class="tt-description">
                                    Choose the post category you want to include the blog post. You can select one or multiple category here.
                                </div>
                                <div class="category_list"></div>
                            </div>
                            <div class="tt-elements-container cb_portfolio">
                                <div class="tt-title-element title-element">
                                    <label>Category</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select class="default_carousel cbf_portolio_category">' . $portfolio_cats . '</select>
                                </div>
                                <div class="tt-description">
                                    Choose the post category you want to include the blog post. You can select one or multiple category here.
                                </div>
                                <div class="category_list"></div>
                            </div>
                            
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Post Count</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <input type="text" class="cbf_post_count" placeholder="10" />
                                </div>
                                <div class="tt-description">
                                    How many posts will it display.
                                </div>
                            </div>                            
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Excerpt</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <input type="text" class="cbf_excerpt_count" placeholder="50" />
                                </div>
                                <div class="tt-description">
                                    Inserted words can break blog posts. Empty, 0 or number value allowed. 
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="cb_hidden_data">
                        <title></title>
                        <type>recent_posts</type>
                        <size>'.$defaultWidth.'</size>
                        <title_style>3</title_style>
                        <start_row></start_row>
                        <custom_class></custom_class>
                        <color_picker_value></color_picker_value>
                        <post_type>post</post_type>
                        <post_category></post_category>
                        <port_category></port_category>
                        <post_count>'.get_option('posts_per_page').'</post_count>
                        <excerpt_count>20</excerpt_count>
                    </div>';

function cb_item_recent_posts($item) {
    $custom_class = find_xml_value($item, 'custom_class');

    $html_start = '<div class="' .$custom_class.' '. size_back_to_front(find_xml_value($item, 'size')) .((find_xml_value($item, 'start_row')==='true')?' start-row':''). '">';
    $html_start .= '<div class="tt-element">';
    if (find_xml_value($item, 'title') != "") {
        $html_start .= get_element_title(find_xml_value($item, 'title'),find_xml_value($item, 'title_style'),find_xml_value($item, 'color_picker_value'));
    }
    $html_start .= '<div class="tt-recent-posts">';
    /* LOOP HERE */
    $html_end = '</div>';
    $html_end .= '</div>';
    $html_end .= '</div>';

    $post_type = find_xml_value($item, 'post_type')!="" ? find_xml_value($item, 'post_type') : "post";
    $excerpt_count = (find_xml_value($item, 'excerpt_count') != "") ? intval(find_xml_value($item, 'excerpt_count')) : '20';
    $post_count = find_xml_value($item, 'post_count')!= "" ? find_xml_value($item, 'post_count') : get_option('posts_per_page');
    
    $tab_xml = find_xml_node($item, 'post_category');
    foreach ($tab_xml->childNodes as $node) {
        if (find_xml_value($node, 'name') != "") {
            $cat_post[] = find_xml_value($node, 'name');
        }
    }
    $tab_xml = find_xml_node($item, 'port_category');
    foreach ($tab_xml->childNodes as $node) {
        if (find_xml_value($node, 'name') != "") {
            $cat_port[] = find_xml_value($node, 'name');
        }
    }
    
    $query = Array(
        'post_type' => $post_type,
        'posts_per_page' => $post_count,
    );
    if ($post_type == "post") {
        if (isset($cat_post)) {
            $query['tax_query'] = Array(Array(
                    'taxonomy' => 'category',
                    'terms' => $cat_post,
                    'field' => 'slug'
                )
            );
        }
    } elseif ($post_type == "portfolio") {
        if (isset($cat_port)) {
            $query['tax_query'] = Array(Array(
                    'taxonomy' => 'portfolios',
                    'terms' => $cat_port,
                    'field' => 'slug'
                )
            );
        }
    }
    
    echo $html_start;
    query_posts($query);
    
    if (have_posts ()) {
        echo "<ul class='recent-posts'>";
            while (have_posts ()) : the_post();
                global $post;
                if($post_type=="post") {
                    $format = get_post_format() == "" ? "standard" : get_post_format();
                    $thumb = "<img class='recent-post-format' src='".get_template_directory_uri()."/resources/images/format-".$format.".png' alt='".$post->title."'>";
                } else {
                    if(post_image_show()) {
                        $thumb = post_image_show(70,70);
                    }
                }
                
                echo "<li>";
                echo "<div class='thumb-image'>".$thumb."</div>";
                echo "<div class='rp-content'><h2><a href='".get_permalink()."'>".$post->post_title."</a><span class='title-border'></span></h2>";
                echo '<p>'. strip_shortcodes(showBrief($post->post_content, $excerpt_count)).'</p></div>';
                echo "</li>";
            endwhile;
        echo "</ul>";
    }
    
    wp_reset_query();
    echo $html_end;
}