<?php    
$selectsidebar = array();
$selectsidebar["Default sidebar"] = "Default sidebar";
$sidebars = get_option('theme_' . THEMENAME . '_sidebar');
if (!empty($sidebars)) {
    foreach ($sidebars as $sidebar) {
        $selectsidebar[$sidebar] = $sidebar;
    }
}    
$post_settings = Array(
    'page_layout' => Array('type' => 'layout', 'description' => __('If turn this option ON, your current post background color will define your selected color on Blog/Category page.', 'themeton'), 'default' => 'right'),
    'custom_sidebar' => Array('type' => 'select', 'description' => __('Select sidebar', 'themeton'), 'title' => __('Select sidebar', 'themeton'), 'options' => $selectsidebar),
    'feature_show' => Array('type' => 'selectbox', 'description' => __('If turn it ON, your post will show with Featured section in single post entered. This option only refers to this single post. Middle meas options controls from admin panel.', 'themeton'), 'title' => __('Featured section', 'themeton'), 'default' => 'default'),
    'meta_author' => Array('type' => 'selectbox', 'description' => __('If turn it ON, post will show with author link on blog/category pages. Middle meas options controls from admin panel.', 'themeton'), 'title' => __('Show post author ?', 'themeton'), 'default' => 'default'),
);
add_action('admin_init', 'post_settings_custom_box', 1);

function post_settings_custom_box() {
    global $post_settings;
    add_meta_box(
        'post_meta_settings',
        __( 'Post settings', 'themeton' ), 
        'post_settings_section',
        'post',
        'normal',
        'core',
        $post_settings
    );
}
function post_settings_section($post, $metabox) {
    global $post;
    $options = get_post_meta($post->ID, 'themeton_'.THEMENAME.'_options', true);?>
        <div class="additional_panel_container">
            <div class="additional_panel"><br />
                <table>
                    <?php	            
                    foreach ($metabox['args'] as $type=>$settings) {
                        $settings['name'] = $type;
                        $settings['value'] = isset($options[$settings['name']]) ? $options[$settings['name']] : (isset($settings['default']) ? $settings['default'] : '');
                        call_user_func('settings_'.$settings['type'], $settings);	
                    }    
                    ?>  
                </table>
            </div>
        </div>
<?php 
}
?>