<?php
$price_settings = Array(
    'type' => Array('type' => 'select', 'description' => __('Price item type. Note Description type is only displaying your descriptions.', 'themeton'), 'title' => __('Type', 'themeton'), 'options' => array('general' => 'Regular', 'featured' => 'Featured', 'description' => 'Description' )),
    'plan' => Array('type' => 'text', 'description' => __('Plan text', 'themeton'), 'title' => __('Plan text', 'themeton')),
    'price' => Array('type' => 'text', 'description' => __('Price value. Please insert with $ symbol.', 'themeton'), 'title' => __('Price', 'themeton')),
    'time' => Array('type' => 'text', 'description' => __('Price time option. Example: Month, Day, Year etc.', 'themeton'), 'title' => __('Price Time', 'themeton'), 'default' => __("Month", "themeton")),
    'buttontext' => Array('type' => 'text', 'description' => __('Insert the button text.', 'themeton'), 'title' => __('Button text', 'themeton')),
    'buttoncolor' => Array('type' => 'select', 'description' => __('Choose the button color.', 'themeton'), 'title' => __('Button color', 'themeton'), 'options' => array('general' => 'Gray', 'red' => 'Red', 'orange' => 'Orange', 'green' => 'Green', 'blue' => 'Blue', 'pink' => 'Pink', 'magenta' => 'Magenta', 'yellow' => 'Yellow' )),
    'buttonlink' => Array('type' => 'text', 'description' => __('Insert the button link URL.', 'themeton'), 'title' => __('Button link url', 'themeton')),
);

add_action('init', 'price_register');

function price_register() {
    
    $labels = array(
        'name' => __('Pricing Tables', 'themeton'),
        'singular_name' => __('Price Item', 'themeton'),
        'add_new' => __('Add New', 'themeton'),
        'add_new_item' => __('Add New Item', 'themeton'),
        'edit_item' => __('Edit Item', 'themeton'),
        'new_item' => __('New Item', 'themeton'),
        'all_items' => __('All Tables', 'themeton'),
        'view_item' => __('View Price Item', 'themeton'),
        'search_items' => __('Search Pricing Tables', 'themeton'),
        'not_found' =>  __('No Tables found', 'themeton'),
        'not_found_in_trash' => __('No Tables in Trash', 'themeton'),
        'menu_name' => __('Pricing Tables', 'themeton')
    );
    
    $args = array(
        'labels' => $labels,
        'public' => true,
        '_builtin' => false,
        'capability_type' => 'post',
        'menu_icon' => get_template_directory_uri() . '/framework/resources/images/price.png',
        'hierarchical' => false,
        'rewrite' => array( 'slug' => 'price'),
        'supports' => array('title', 'editor', 'thumbnail')
    );

    register_post_type('price', $args);
    flush_rewrite_rules();
}

register_taxonomy("prices", array("price"), array("hierarchical" => true, "label" => __("Categories", "themeton"), "singular_label" => __("Price Category","themeton"), "rewrite" => true));

add_action('admin_init', 'price_settings_custom_box');

function price_settings_custom_box() {
    global $price_settings;
    add_meta_box(
        'price_meta_settings',
        __( 'Price settings', 'themeton' ), 
        'price_settings',
        'price',
        'normal',
        'high',
        $price_settings
    );
}


function price_edit_columns($columns){	
        $columns = array(
            "cb" => "<input type=\"checkbox\" />",
            "title" => __("Table name", "themeton"),
            "price" => __("Categories", "themeton"),
            "date" => __("Date", "themeton"),
        );
        return $columns;
}
add_filter('manage_edit-price_columns', 'price_edit_columns');


function price_settings($post, $metabox) {
    global $post; 
    $options = get_post_meta($post->ID, 'themeton_'.THEMENAME.'_options', true);?>
        <div class="additional_panel_container">
            <div class="additional_panel"><br />
                <table>
                    <?php
                    foreach ($metabox['args'] as $type=>$settings) {
                        $settings['name'] = $type;
                        $settings['value'] = isset($options[$settings['name']]) ? $options[$settings['name']] : (isset($settings['default']) ? $settings['default'] : '');
                        call_user_func('settings_'.$settings['type'], $settings);	
                    }
                    ?>         
                </table>
            </div>
        </div>
<?php 
}
?>