<?php

if (function_exists('wp_get_theme')) { // if WordPress v3.4+
    $theme_data = ( wp_get_theme()->parent() ) ? wp_get_theme()->parent() : wp_get_theme();
    $theme_version = $theme_data->get('Version');
} else {
    $theme_data = get_theme_data(TEMPLATEPATH . '/style.css');
    $theme_version = $theme_data['Version'];
}

define('THEMEVERSION', $theme_version);

add_action('admin_menu', 'theme_settings_menu');

function theme_settings_menu() {

    add_menu_page('Theme Settings', 'Theme Settings', 'manage_options', 'theme_settings', 'theme_settings_render_page');
}

function theme_settings_render_page() {
    global $fields, $settings;
    
    theme_settings();
    
    //------------------------------------------------------------------------------------

    include(file_require(get_template_directory() . '/framework/settings/templates/fields.php'));
    include(file_require(get_template_directory() . '/framework/settings/templates/settings-tab.php'));
}

function theme_settings() {
    global $fields, $settings;
    $fields = $settings = array();

    $obj = null;
    $obj["group"] = "Theme Options";
    $obj["items"] = array(
        "General Settings" => "general/general_settings.php",
        "Additional Options" => "general/additional_options.php",
        "Font Options" => "general/font_options.php",
        "Skin Options" => "general/skin_options.php",
        "Custom Sidebar" => "general/custom_sidebar.php",
        "Footer Options" => "general/footer_options.php",
        "Social Options" => "general/social_options.php",
        "Backup Options" => "general/backup_options.php",
        "Branding Option" => "general/branding.php"
    );
    $settings[] = $obj;

    //------------------------------------------------------------------------------------

    if (get_settings_value("other_themes") != 1) {

        $obj = null;
        $obj["group"] = "ThemeTon Themes";
        $obj["items"] = array(
            "Other Themes" => "themes/other_themes.php",
        );
        $settings[] = $obj;
    }
    //------------------------------------------------------------------------------------

}

function theme_defaults() {
    global $fields, $settings;
    $fields = $settings = $default = array();
    
    theme_settings();
    
    ob_start();
    foreach ($settings as $setting) {
        $items = $setting["items"];
        foreach ($items as $key => $value) {
            include(file_require(get_template_directory() . "/framework/settings/templates/" . $value));
        }
    }
    ob_end_clean();
    
    foreach ($fields as $field) {
        foreach ($field as $name => $value) {
            if ($value["type"] == "multicheck" || $value["type"] == "background") {
                foreach ($value["default"] as $key => $option) {
                    $default[$name . "_" . $key] = $option;
                }
            } else {
                $default[$name] = isset($value["default"]) ? $value["default"] : "";
            }
        }
    }
    return $default;
}

if (is_admin() && isset($_GET['activated'] ) && $pagenow == "themes.php" )
    add_action('admin_head','theme_activated');

function theme_activated() {        
    if (!get_option('theme_' . THEMENAME . '_data_group'))
    {
        $defaults = theme_defaults();
        $settings['theme_' . THEMENAME . '_data'] = json_encode($defaults);
        update_option('theme_' . THEMENAME . '_data_group', $settings);
        generate_options_css(json_encode($defaults));
    }
}

add_action('admin_enqueue_scripts', 'settings_admin_scripts');
add_action('admin_enqueue_scripts', 'settings_admin_styles');

function settings_admin_scripts() {
    global $pagenow;
    if ($pagenow == "admin.php" && isset($_GET['page']) && $_GET['page'] == "theme_settings") {
        wp_enqueue_script('media-upload');
        wp_enqueue_script('thickbox');
        wp_register_script('jquery-ui', get_template_directory_uri() . '/framework/resources/jquery-ui/jquery-ui.js', array('jquery', 'media-upload', 'thickbox'));
        wp_register_script('iphone-checkbox', get_template_directory_uri() . '/framework/resources/iphone-check/iphone-style-checkboxes.js');
        wp_register_script('colorpicker1', get_template_directory_uri() . '/framework/resources/colorpicker/colorpicker.js');
        wp_register_script('settings-script', file_require(get_template_directory_uri() . '/framework/settings/script.js'));

        wp_enqueue_script('jquery-ui');
        wp_enqueue_script('iphone-checkbox');
        wp_enqueue_script('colorpicker1');
        wp_enqueue_script('settings-script');
    }
    wp_register_script('cookie', get_template_directory_uri() . '/framework/resources/cookie/cookie.js');
    wp_enqueue_script('cookie');
}

function settings_admin_styles() {
    global $pagenow;
    if ($pagenow == "admin.php" && isset($_GET['page']) && $_GET['page'] == "theme_settings") {
        wp_enqueue_style('thickbox');
        wp_register_style('settings_options_font', 'http://fonts.googleapis.com/css?family=Open+Sans:600,700,300,300italic'); // register webfont
        wp_register_style('iphone-checkbox', get_template_directory_uri() . '/framework/resources/iphone-check/style.css', false, '1.00', 'screen');
        wp_register_style('colorpicker1', get_template_directory_uri() . '/framework/resources/colorpicker/css/colorpicker.css', false, '1.00', 'screen');

        wp_enqueue_style('settings_options_font');
        wp_enqueue_style('iphone-checkbox');
        wp_enqueue_style('colorpicker1');
    }
}

add_action('wp_ajax_save_theme_settings', 'save_theme_settings');
add_action('wp_ajax_nopriv_save_theme_settings', 'save_theme_settings');
add_action('wp_ajax_backup_reset_settings', 'backup_reset_settings');
add_action('wp_ajax_add_custom_sidebar', 'add_custom_sidebar');
add_action('wp_ajax_del_custom_sidebar', 'del_custom_sidebar');

// save settings form date
function save_theme_settings() {
    try {
        $form_data = $_POST;

        update_theme_settings(json_encode($form_data));
        echo "1";
    } catch (Exception $e) {
        echo "-1";
    }

    exit;
}

// update settings values
function update_theme_settings($param) {
    $settings = array();
    $settings['theme_' . THEMENAME . '_data'] = $param;
    update_option('theme_' . THEMENAME . '_data_group', $settings);
    generate_options_css($param);
}

// backup settings values
function backup_reset_settings() {
    $type = $_POST['type'];
    if ($type == "reset") {
        try {
            $default = theme_defaults();
            $settings['theme_' . THEMENAME . '_data'] = json_encode($default);
            update_option('theme_' . THEMENAME . '_data_group', $settings);
            generate_options_css(json_encode($default));
            echo "1";
        } catch (Exception $e) {
            echo "-1";
        }

        exit;
    } elseif ($type == "backup") {
        try {
            $backup = get_option('theme_' . THEMENAME . '_data_group');
            $backup['backup_log'] = date('r');

            update_option('theme_' . THEMENAME . '_backup', $backup);

            echo "1";
        } catch (Exception $e) {
            echo "-1";
        }

        exit;
    } elseif ($type == "restore") {
        try {
            $backup = get_option('theme_' . THEMENAME . '_backup');
            update_option('theme_' . THEMENAME . '_data_group', $backup);
            generate_options_css($backup['theme_' . THEMENAME . '_data']);

            echo "1";
        } catch (Exception $e) {
            echo "-1";
        }

        exit;
    } elseif ($type == "import") {
        try {
            $import = $_POST['data'];

            echo $import;

            $import = unserialize(base64_decode($import)); //100% safe - ignore theme check nag

            update_option('theme_' . THEMENAME . '_data_group', $import);
            generate_options_css($import['theme_' . THEMENAME . '_data']);

            echo "1";
        } catch (Exception $e) {
            echo "-1";
        }
    }
}

function add_custom_sidebar() {
    $add = $_POST['sidebar'];
    if (!empty($add)) {
        try {
            $sidebars = get_option('theme_' . THEMENAME . '_sidebar');
            if (empty($sidebars))
                $sidebars = array();
            array_push($sidebars, $add);

            update_option('theme_' . THEMENAME . '_sidebar', $sidebars);

            echo "1";
        } catch (Exception $e) {
            echo "-1";
        }

        exit;
    }
}

function del_custom_sidebar() {
    $del = $_POST['sidebar'];
    if (!empty($del)) {
        try {
            $sidebars = get_option('theme_' . THEMENAME . '_sidebar');
            $newsidebars = array();
            foreach ($sidebars as $sidebar) {
                if ($del != $sidebar) {
                    array_push($newsidebars, $sidebar);
                }
            }
            update_option('theme_' . THEMENAME . '_sidebar', $newsidebars);

            echo "1";
        } catch (Exception $e) {
            echo "-1";
        }

        exit;
    }
}

function generate_options_css($newdata) {

    $data = json_decode($newdata, true);
    $css_dir = get_template_directory() . '/resources/css/'; // Shorten code, save 1 call
    ob_start(); // Capture all output (output buffering)

    require(file_require($css_dir . 'styles.php')); // Generate CSS

    $css = ob_get_clean(); // Get generated CSS (output buffering)
    file_put_contents(get_stylesheet_directory() . '/resources/css/options.css', $css, LOCK_EX); // Save it
}

// get settings value
function get_settings_value($param) {
    $value = "";
    try {
        $option = get_option('theme_' . THEMENAME . '_data_group');
        $json = json_decode($option['theme_' . THEMENAME . '_data'], true);
        if (isset($json[$param])) {
            $value = $json[$param];
        }
    } catch (Exception $e) {
        
    }
    return $value;
}

// print settings value
function print_settings_value($param) {
    $value = "";
    try {
        $option = get_option('theme_' . THEMENAME . '_data_group');
        $json = json_decode($option['theme_' . THEMENAME . '_data'], true);
        if (isset($json[$param])) {
            $value = $json[$param];
        }
    } catch (Exception $e) {
        
    }
    echo $value;
}

// get settings value
function option_value($param) {
    $option = get_option('theme_' . THEMENAME . '_data_group');
    $json = json_decode($option['theme_' . THEMENAME . '_data'], true);
    if (isset($json[$param])) {
        return $value = $json[$param];
    }
    return false;
}
function getArraySocial() {
    return array(
        array(
            'name' => 'facebook',
            'link' => 'http://www.facebook.com/*'
        ),
        array(
            'name' => 'flickr',
            'link' => 'http://www.flickr.com/photos/*'
        ),
        array(
            'name' => 'googleplus',
            'link' => 'https://plus.google.com/u/0/*'
        ),
        array(
            'name' => 'pinterest',
            'link' => 'http://pinterest.com/*'
        ),
        array(
            'name' => 'skype',
            'link' => 'skype:*'
        ),
        array(
            'name' => 'twitter',
            'link' => 'http://twitter.com/*'
        ),
        array(
            'name' => 'vimeo',
            'link' => 'http://vimeo.com/*'
        ),
        array(
            'name' => 'youtube',
            'link' => 'http://www.youtube.com/user/*'
        ),
        array(
            'name' => 'dribbble',
            'link' => 'http://dribbble.com/*'
        ),
        array(
            'name' => 'linkedin',
            'link' => '*'
        ),
        array(
            'name' => 'rss',
            'link' => 'http://*/feed'
        ),
    );
}
function themeton_admin_menu_styles() {
	wp_enqueue_style( 'themeton_admin_menu_styles', get_template_directory_uri() . '/framework/settings/style.css' );
}
add_action( 'admin_print_styles', 'themeton_admin_menu_styles' );
?>