<?php
    $backup_text = __("Backup Options", "themeton");
    $restore_text = __("Restore Options", "themeton");
    $import_text = __("Import Options", "themeton");
    $backup = get_option('theme_'.  strtolower(THEMENAME).'_backup');					
    $export = get_option('theme_'.  strtolower(THEMENAME).'_data_group');					
    if(!isset($backup['backup_log'])) {
            $log = __("No backups yet", "themeton");
    } else {
            $log = $backup['backup_log'];
    }
?>
<div class="form_field" id="field_backup_options">
    <label>
        <?php _e("Backup and Restore options", "themeton"); ?>
    </label>
    <div>
        <?php _e("You can use the two buttons below to backup your current options, and then restore it back at a later time. This is useful if you want to experiment on the options but would like to keep the old settings in case you need it back.", "themeton"); ?>
    </div>
    <p><strong><?php echo __('Last Backup : ', 'themeton'); ?><span class="backup-log"><?php echo $log; ?></span></strong></p>
    <div style="float: left; padding-right: 20px;">
            <a href="#" id="backup_button" class="button" title="<?php echo $backup_text;?>"><?php echo $backup_text;?></a>
            <a href="#" id="restore_button" class="button" title="<?php echo $restore_text;?>"><?php echo $restore_text;?></a>
    </div>
    <span class="settings_saving"></span>
    <div class="clear"></div>
</div>


<div class="form_field" id="field_import_options">
    <label>
        <?php _e("Import options", "themeton"); ?>
    </label>
    <div>
        <p>
            <?php _e("You can tranfer the saved options data between different installs by copying the text inside the text box. To import data from another install, replace the data in the text box with the one from another install and click \"Import Options\".", "themeton"); ?>
        </p>
        <?php echo '<textarea id="export_data" rows="8" style="width: 400px">'.base64_encode(serialize($export)) /* 100% safe - ignore theme check nag */ .'</textarea>'; ?>
    </div>
    <div style="float: left; padding-right: 20px;">
            <a href="#" id="import_button" class="button" title="<?php echo $import_text;?>"><?php echo $import_text;?></a>
    </div>
    <span class="settings_saving"></span>
    <div class="clear"></div>
</div>