<?php get_header(); ?>


<?php 

the_post();
$col = "eight";
if(get_field("page_layout") == "without") {
    $col = "twelve";
} elseif(get_field("page_layout") == "left") {
    get_sidebar();
}
?>


<div class="col <?php echo $col;?>">
    
    <?php
    $feature = false; $class = "entry";
    if(get_field("feature_show")=="true") {
        $feature = true;
    } else if(get_field("feature_show")!="false") {
        if(get_settings_value("feature_show")) {
            $feature = true;
        }
    }    

    $format_options = get_post_meta($post->ID, 'themeton_post_format', true);
    $format = get_post_format() == "" ? "standard" : get_post_format();
    if($format=="status"){
        if(preg_match("#http://instagr(\.am|am\.com)/p/.*#i", $format_options["status_url"]))
                $class .= " instagram-post";
        elseif(preg_match("|https?://(www\.)?twitter\.com/(#!/)?@?([^/]*)|", $format_options["status_url"]))
                $class .= " twitter-post";
    }
    
    ?>
    <section class="content">
        <article <?php post_class($class);?>>        
            <?php 
            if($feature) {
                echo '<div class="entry-media clearfix">';
                        call_user_func('format_'.$format, $format_options);
                echo '</div>';
            } ?>
            <div class="content-block">
                <div class="meta-container">
                    <div class="meta-border"></div>
                    <ul class="entry-meta horizontal hidden-phone">
                        <li class="meta-date"><?php echo "<span>".__("Posted: ", "themeton")."</span>"; print_date("M j, Y"); ?></li>                                    
                        <li class="meta-category"><?php echo "<span>".__("Category: ", "themeton")."</span>"; echo get_the_category_list(', '); ?></li>
                        <li class="meta-author"><?php echo "<span>".__("Author: ", "themeton")."</span>"; the_author_posts_link(); ?></li>
                    </ul>
                    <div class="meta-border"></div>
                </div>
                <?php the_content(); ?>
                <div class="clear"></div>
                <?php if(get_the_tag_list()) { ?>
                <div class="meta-container">
                    <div class="meta-border"></div>
                    <ul class="entry-meta category-list">                        
                            <li class="meta-tag"><?php _e("Tags: ", "themeton"); echo get_the_tag_list('', ', ', ''); ?></li>                        
                    </ul>
                    <div class="meta-border"></div>
                </div>
                <?php } ?>
                <?php about_author(); ?>
                <?php ?>
                <?php 
                if(get_settings_value("post_comment")=="" || get_settings_value("post_comment"))
                    comments_template('', true);        
                ?>
            </div>
        </article>
    </section>
</div>


<?php 
if(get_field("page_layout") == "" || get_field("page_layout") == "right") {
    get_sidebar();
}
?>

<?php get_footer(); ?>