<?php
$team_settings = Array(
    'position' => Array('type' => 'text', 'description' => __('Member position', 'themeton'), 'title' => __('Position', 'themeton')),
    'facebook' => Array('type' => 'text', 'description' => __('Facebook url', 'themeton'), 'title' => __('Facebook url', 'themeton')),
    'twitter' => Array('type' => 'text', 'description' => __('Twitter url', 'themeton'), 'title' => __('Twitter url', 'themeton')),
    'google' => Array('type' => 'text', 'description' => __('Google url', 'themeton'), 'title' => __('Google url', 'themeton')),
    'linkedin' => Array('type' => 'text', 'description' => __('Linkedin url', 'themeton'), 'title' => __('Linkedin url', 'themeton')),
);

add_action('init', 'team_register');

function team_register() {
    
    $labels = array(
        'name' => __('Member', 'themeton'),
        'singular_name' => __('Member', 'themeton'),
        'add_new' => __('Add New', 'themeton'),
        'add_new_item' => __('Add New Member', 'themeton'),
        'edit_item' => __('Edit Member', 'themeton'),
        'new_item' => __('New Member', 'themeton'),
        'all_items' => __('All Members', 'themeton'),
        'view_item' => __('View Member', 'themeton'),
        'search_items' => __('Search Member', 'themeton'),
        'not_found' =>  __('No member found', 'themeton'),
        'not_found_in_trash' => __('No member found in Trash', 'themeton'),
        'menu_name' => __('Team', 'themeton')
    );
    
    $args = array(
        'labels' => $labels,
        'public' => true,
        '_builtin' => false,
        'capability_type' => 'post',
        'menu_icon' => get_template_directory_uri() . '/framework/resources/images/team.png',
        'hierarchical' => false,
        'rewrite' => array( 'slug' => 'team'),
        'supports' => array('title', 'thumbnail')
    );

    register_post_type('team', $args);
    flush_rewrite_rules();
}

register_taxonomy("position", array("team"), array("hierarchical" => true, "label" => __("Categories", "themeton"), "singular_label" => __("Category", "themeton"), "rewrite" => true));


add_action('admin_init', 'team_settings_custom_box');

function team_settings_custom_box() {
    global $team_settings;
    add_meta_box(
        'team_meta_settings',
        __( 'Team settings', 'themeton' ), 
        'team_settings',
        'team',
        'normal',
        'high',
        $team_settings
    );
}


function team_edit_columns($columns){	
        $columns = array(
            "cb" => "<input type=\"checkbox\" />",
            "thumbnail" => __("Image", "themeton"),
            "title" => __("Name", "themeton"),
            "team" => __("Categories", "themeton"),
            "date" => __("Date", "themeton"),
        );
        return $columns;
}
add_filter('manage_edit-team_columns', 'team_edit_columns');


function team_settings($post, $metabox) {
    global $post; 
    $options = get_post_meta($post->ID, 'themeton_'.THEMENAME.'_options', true);?>
        <div class="additional_panel_container">            
            <div class="additional_panel">
                <table>
                    <?php	          
                    foreach ($metabox['args'] as $type=>$settings) {
                        $settings['name'] = $type;
                        $settings['value'] = isset($options[$settings['name']]) ? $options[$settings['name']] : (isset($settings['default']) ? $settings['default'] : '');
                        call_user_func('settings_'.$settings['type'], $settings);
                    }
                    ?>
                </table>
            </div>
        </div>
<?php 
}
?>