<?php
global $fields;

$fields['additional_options'] = Array(
    'feature_show' => Array(
        'type' => 'checkbox',
        'title' => __('Feature section ?', 'themeton'),
        'description' => __('If ON, Featured section (Image, Video, Image Slider) will be show on each single post', 'themeton'),
        'default' => 0),
    'breadcrumb_show' => Array(
        'type' => 'checkbox',
        'title' => __('Breadcrumb ?', 'themeton'),
        'description' => __('If ON, Breadcrumb will be show', 'themeton'),
        'default' => 1),
    'portfolio_height' => Array(
        'type' => 'textInput',
        'title' => __('Portfolio image height ?', 'themeton'),
        'description' => __('Portfolio image default height', 'themeton'),
        'default' => '150'),
    'post_author' => Array(
        'type' => 'checkbox',
        'title' => __('Post author ?', 'themeton'),
        'description' => __('If ON, show author in single post', 'themeton'),
        'default' => 1),
    'page_author' => Array(
        'type' => 'checkbox',
        'title' => __('Page author ?', 'themeton'),
        'description' => __('If ON, show author in page', 'themeton'),
        'default' => 0),
    'post_comment' => Array(
        'type' => 'checkbox',
        'title' => __('Post comment ?', 'themeton'),
        'description' => __('If ON, allow comments single post', 'themeton'),
        'default' => 1),
    'page_comment' => Array(
        'type' => 'checkbox',
        'title' => __('Page comment ?', 'themeton'),
        'description' => __('If ON, allow comments page', 'themeton'),
        'default' => 0),    
);
foreach($fields['additional_options'] as $type=>$field) {
    $field["name"] = $type;
    if(function_exists('form_field_'.$field["type"]))
        call_user_func('form_field_'.$field["type"], $field);
}
?>