<?php get_header(); ?>

<?php 

the_post();

?>
<section class="content">

<article>
    <div class="col twelve">
        <?php
                    if (has_post_thumbnail($post->ID)) {
                        $lrg_img = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');
                        $image_width = 1170;
                        $image_height = get_field("image_height")!="" ? get_field("image_height") : (intval(get_settings_value("portfolio_height"))*2);
                        $url = aq_resize($lrg_img[0],$image_width,$image_height, true);


                        $thumb =         
                            '<div class="tt-element hover-content">
                                    <img src="'.$url.'" alt="">
                                    <div class="image-overlay">
                                            <div class="hover-links clearfix">
                                                    <a class="hover-permalink" href="'.get_permalink().'"></a>
                                                    <a class="hover-zoom" rel="prettyPhoto" href="'.$lrg_img[0].'" title="'.$post->post_title.'"></a>
                                            </div>
                                    </div>
                            </div>';
                        echo $thumb;
                    }
       ?>
    </div>
    
    <div class="col eight">

        <h3 class="tt-element-title"><?php _e("Description", "themeton");?><span class="tt-element-title-border"></span></h3>

        <article>
            <?php the_content(); ?>
        </article>    

    </div>

    <div class="col four">
        <h3 class="tt-element-title"><?php _e("Details", "themeton");?><span class="tt-element-title-border"></span></h3>
        <ul class="portfolio-meta">
            <li class="meta-category">
                <?php echo __("Categories:","themeton")." "; echo get_the_term_list( $post->ID, 'portfolios', '', ',', '' );?>
            </li>
            <li class="meta-date">
                <?php echo __("Date:","themeton")." "; print_date('j F Y');?>
            </li>
            <?php if(get_field("meta_client")!="") { ?>
                    <li class="meta-client">
                        <?php echo __("Client:","themeton")." "; echo get_field("meta_client");?>
                    </li>
            <?php } ?>
            <?php if(get_field("used_tech")!="") { ?>
                    <li class="meta-client">
                        <?php echo __("Used Tech:","themeton")." "; echo get_field("used_tech");?>
                    </li>
            <?php } ?>
        </ul>
        <?php if(get_field("preview_url")!="") { 
                $url = get_field("preview_url");
                if(!preg_match_all('!https?://[\S]+!', $url, $matches))
                    $url = "http://" . get_field("preview_url");?>
                <a href="<?php echo $url;?>" class="more-link live-preview"><?php _e("Live preview", "themeton");?></a>
        <?php } ?>
            <div class="port-btn-container">
        <?php previous_post_link('<div class="port-btn prev-btn">%link</div>', '<i class="icon-angle-left"></i>');?>
        <?php next_post_link('<div class="port-btn next-btn">%link</div>', '<i class="icon-angle-right"></i>');?>
            </div>
    </div>
</article>    

<div class="col twelve related_portfolios">
    <?php related_portfolios(); ?>
</div>
    
</section>
<?php get_footer(); ?>