<?php
	
	// Show Brief
	//=======================================================
	if ( ! function_exists( 'showBrief' ) ) :
            function showBrief($str, $length) {
                $str = strip_tags($str);
                $str = explode(" ", $str);
                return implode(" ", array_slice($str, 0, $length));
            }
        endif;
        
        // Go url
	//=======================================================
	if ( ! function_exists( 'to_url' ) ) :
            function to_url($url) {
                if(!preg_match_all('!https?://[\S]+!', $url, $matches))
                    $url = "http://" . $url;
                return $url;
            }
        endif;
	
	// Page,Post get, print title
	//=======================================================
	
	function print_title(){            
            echo "<a href='". get_permalink() ."' title='". get_the_title() ."'>". get_the_title() ."</a>";
	}
        
        function get_title(){
            return "<a href='". get_permalink() ."' title='". get_the_title() ."'>". get_the_title() ."</a>";
	}
	
	
	
	
	// Page,Post get, print content
	//=======================================================
	
	function print_content(){
            global $pb_options, $more;
            $more = 0;
            $readMore = !empty($pb_options['more_text']) ? $pb_options['more_text'] : __('Read More', 'themeton');
            
            if(has_excerpt()) {
                the_excerpt();
            } elseif(has_more()) {
                the_content("");
                echo '<a href="'.get_permalink().'" class="more-link">'.$readMore.'</a>';
            } elseif(!empty($pb_options['excerpt_count'])) {
                echo apply_filters("the_content", showBrief(strip_shortcodes(get_the_content()), $pb_options['excerpt_count']));
                echo '<a href="'.get_permalink().'" class="more-link">'.$readMore.'</a>';
            } else {
                echo apply_filters("the_content", strip_shortcodes(get_the_content("")));
            }
        }
	
	
	
	
	// Page,Post get, print date
	//=======================================================
	function get_date($format = 'Y-m-d'){
		global $post;
		return date($format, strtotime($post->post_date));
	}
	
	function print_date($format = 'Y-m-d'){
		global $post;
		echo date($format, strtotime($post->post_date));
	}
	
	
	
	
	// Page, Post get, print custom field
	//=======================================================
	function get_field($field_name){
		global $post;
                if($post){
                    $field_value = get_post_meta($post->ID, 'themeton_'.THEMENAME.'_options', true);
                    return isset($field_value[$field_name]) ? $field_value[$field_name] : "";
                }
	}
	
	function print_field($field_name){
		global $post;
		$field_value = get_post_meta($post->ID, 'themeton_'.THEMENAME.'_options', true);
		echo isset($field_value[$field_name]) ? $field_value[$field_name] : "";
	}
        
	
	
	
	// Print menu
	//=======================================================
	function print_menu(){
		wp_nav_menu( array('container' => 'nav',
                                    'container_class' => 'visible-desktop',
                                    'container_id' => 'menu',
                                    'fallback_cb' => 'nomenu',
                                    'menu_class'      => 'clearfix',
                                    'walker' => new TopNavWalker(),
                                    'theme_location' => 'primary' ) );
	}
        function nomenu(){
                echo "<nav id='menu' class='visible-desktop'><ul id='menu-main' class='clearfix'>";
                wp_list_pages(array('title_li' => ''));
                echo "</ul></nav>";
        }
        function add_parent_class( $css_class, $page, $depth, $args )
        {
                if ( ! empty( $args['has_children'] ) )
                        $css_class[] = 'current-menu-parent';
                return $css_class;
        }
        add_filter( 'page_css_class', 'add_parent_class', 10, 4 );

        class TopNavWalker extends Walker_Nav_Menu
        {
                function start_lvl(&$output, $depth) {
                        $indent = str_repeat("\t", $depth);
                        $intPos = strripos($output,'menu-item');
                        $output = sprintf("%s current-menu-parent %s",
                                substr($output,0,$intPos),
                                substr($output,$intPos,strlen($output))
                        );
                        $output .= "\n$indent<ul class=\"sub-menu\">\n";
                }
        }
		
	// Footer menu
	//=======================================================
	function footer_menu(){
		wp_nav_menu( array('container' => false,
                                    'menu_class'      => 'footer-menu clearfix',
                                    'fallback_cb' => 'nomenu_footer',
                                    'depth'           => 1,
                                    'theme_location' => 'footer-menu' ) );
	}
        function nomenu_footer(){
                echo "<ul class='footer-menu clearfix'>"; wp_list_pages('title_li='); echo "</ul>";
        }
        
        
        
        // Print logo
	//=======================================================
        function print_logo() {
            echo '<a class="logo" href="' . home_url() . '">';
            if (get_settings_value('header_logo')=="") {
                echo '<h1 class="site-name">';
                bloginfo('name');
                echo '</h1>';
            } else {
                echo '<img class="logo-img" src="' . get_settings_value('header_logo') . '" alt="'.get_bloginfo('name').'" />';
            }
            echo '</a>';
        }
        
        
        
        
        // Get featured text
	//=======================================================
        function get_featuredtext() {
                    global $post;

                    if(is_singular()) {
                        $return = "<h1>".$post->post_title."</h1>";
                        return $return;
                    } elseif(is_category()){
                        $return = "<h1>";
                        $return .= __("Category", "themeton") . " : " . single_cat_title("", false);
                        $return .= "</h1>";
                        return $return;
                    } elseif(is_tax('portfolios')){
                        $return = "<h1>";
                        $return .= __("Portfolio", "themeton") . " : " . single_cat_title("", false);
                        $return .= "</h1>";
                        return $return;
                    } elseif(is_tag()){
                        $return = "<h1>";
                        $return .= __("Tag", "themeton") . " : " . single_tag_title("", false);
                        $return .= "</h1>";
                        return $return;
                    } elseif(is_404()) {
                        $return = "<h1>".__("Nothing Found!", "themeton")."</h1>";
                        return $return;
                    } elseif(is_author()) {
                        global $author;
			$userdata = get_userdata($author);
                        $return = "<h1>".__("Author: ", "themeton").$userdata->display_name."</h1>";
                        return $return;
                    } elseif(is_archive()) {
                        $return = "<h1>";
                        if (is_day ()) :
                            $return .= __("Daily Archives", "themeton") . " : " . get_the_date();
                        elseif (is_month ()) :
                            $return .= __("Monthly Archives", "themeton") . " : " . get_the_date("F Y");
                        elseif (is_year ()) :
                            $return .= __("Yearly Archives", "themeton") . " : " . get_the_date("Y");
                        else : 
                            $return .= __("Blog Archives", "themeton");
                        endif;
                        $return .= "</h1>";
                        return $return;
                    } elseif(is_search()) {
                        $return = "<h1>".__("Search results for", "themeton") . " : ".get_search_query()."</h1>";
                        return $return;
                    }
        }
	
	
	
        
	// Sidebar
	//=======================================================
	function sidebar($sidebar = 'sidebar'){
		if (function_exists('dynamic_sidebar') && dynamic_sidebar($sidebar)){
        
                }
	}
	
	
	function print_styles($links){
		for ($i=0; $i < count($links); $i++) { 
			echo '<link type="text/css" rel="stylesheet" href="'.file_require(get_template_directory_uri().'/'.$links[$i], true).'" />';
		}
				
                echo '<link type="text/css" rel="stylesheet" href="http://fonts.googleapis.com/css?family=' .str_replace(" ","+",get_settings_value('head_felement')). ':400,400italic,700,700italic,600,600italic" />';
                if(get_settings_value('body_felement')!=get_settings_value('head_felement')){echo '<link type="text/css" rel="stylesheet" href="http://fonts.googleapis.com/css?family=' .str_replace(" ","+",get_settings_value('body_felement')). ':400,400italic,700,700italic" />';}
	}
	
	$script_files = array();
	function print_scripts($links){
		global $script_files;
		for ($i=0; $i < count($links); $i++) {
			$script_files[] = $links[$i];
		}
		add_action('wp_footer', 'theme_external_scripts');
	}
	
	function theme_external_scripts(){
		global $script_files;
                
		wp_enqueue_script('jquery');

                if(get_settings_value('facebook_comment') && get_settings_value('post_comment') && !is_single()) {
                    wp_register_script('facebook', "http://connect.facebook.net/en_US/all.js#xfbml=1&appId=".get_settings_value('facebook_app_id'), '', '', true);
                    wp_enqueue_script('facebook');
                } elseif ( is_single() && get_settings_value('post_comment') && comments_open() && get_option( 'thread_comments' )) {
                    wp_enqueue_script( 'comment-reply' );
                }
		for ($i=0; $i < count($script_files); $i++){
			wp_register_script('theme_external_script'.$i, file_require(get_template_directory_uri().'/'.$script_files[$i], '', '', true));
			wp_enqueue_script('theme_external_script'.$i);
		}      
	}
        
        if(!function_exists("current_title")) {
            
            function current_title() {
                global $page, $paged;
                echo "<title>";
                wp_title( '|', true, 'right' );
                bloginfo( 'name' );
                $site_description = get_bloginfo( 'description', 'display' );
                if ( $site_description && ( is_home() || is_front_page() ) )
                        echo " | $site_description";
                if ( $paged >= 2 || $page >= 2 )
                        echo ' | ' . sprintf( __( 'Page %s', 'themeton' ), max( $paged, $page ) );
                echo "</title>";    
            }
        }
	
	function favicon() {
            if (get_settings_value('favicon') != "") {       
                echo '<link rel="shortcut icon" href="' . get_settings_value("favicon") . '"/>';
            } else { echo '<link rel="shortcut icon" href="' . get_template_directory_uri() . '/resources/images/favicon.ico"/>'; }
        }
        
        
        
        
        
        function format_standard() {
                global $post;
                if (has_post_thumbnail($post->ID)) {
                    $lrg_img = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');
                    $url = $lrg_img[0];                    
                    ?>                
                        <div class="entry-image hover-content">
                                <?php echo post_image_show(); ?>
                                <div class="image-overlay">
                                        <div class="hover-links clearfix">
                                                <a class="hover-permalink" href="<?php echo get_permalink(); ?>"></a>
                                                <a class="hover-zoom" rel="prettyPhoto" href="<?php echo $url; ?>" title="<?php echo $post->post_title; ?>"></a>
                                        </div>
                                </div>
                        </div>

                <?php }
        }
        
             
        function format_gallery($options) {
                if (!empty($options['gallery_images'])) {
                    $width = !empty($options['image_width']) ? $options['image_width'] : 770;
                    echo "<div class='entry-gallery tt-post-carousel clearfix'>";
                    echo "<ul class='slides clearfix'>";
                            $images = explode('""', $options['gallery_images']);
                            $height = !empty($options['gallery_height']) ? $options['gallery_height'] : 200;
                            foreach ($images as $image) {
                                if ($image != '') {
                                    $url = aq_resize($image,$width,$height, true);
                                    echo '<li><img alt="' . get_the_title() . '" src="' . $url . '"/></li>';
                                }
                            }
                    echo "</ul>";
                    echo '<div class="carousel-arrow">';
                    echo '<a class="carousel-prev" href="#"><i class="icon-angle-left"></i></a>';
                    echo '<a class="carousel-next" href="#"><i class="icon-angle-right"></i></a>';	
                    echo '</div>';
                    echo "</div>";
                }
        }     
        
        
        function format_audio($options) {            
                global $post;
                
                if (isset($options["audio_is_embed"]) && $options["audio_is_embed"] == 1) {
                    if(!empty($options["audio_embed"])) {
                        echo apply_filters("the_content", $options["audio_embed"]);
                    }
                } else {
                    post_image_show(); 
                    if(!empty($options["audio_url"])) { ?>
                        <div id="jquery_jplayer_<?php echo $post->ID; ?>" pid="<?php echo $post->ID; ?>" class="jp-jplayer jp-jplayer-audio" src="<?php echo $options["audio_url"]; ?>" style="width: 0px; height: 0px; "></div>
                        <div class="jp-audio-container">
                            <div class="jp-audio">
                                <div class="jp-type-single">
                                    <div id="jp_interface_<?php echo $post->ID; ?>" class="jp-interface">
                                        <ul class="jp-controls">
                                            <li><div class="seperator-first"></div></li>
                                            <li><div class="seperator-second"></div></li>
                                            <li><a href="#" class="jp-play" tabindex="1" style="display: block; ">play</a></li>
                                            <li><a href="#" class="jp-pause" tabindex="1" style="display: none; ">pause</a></li>
                                            <li><a href="#" class="jp-mute" tabindex="1">mute</a></li>
                                            <li><a href="#" class="jp-unmute" tabindex="1" style="display: none; ">unmute</a></li>
                                        </ul>
                                        <div class="jp-progress-container">
                                            <div class="jp-progress">
                                                <div class="jp-seek-bar" style="width: 100%; ">
                                                    <div class="jp-play-bar" style="width: 1.18944845234691%; "></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="jp-volume-bar-container">
                                            <div class="jp-volume-bar">
                                                <div class="jp-volume-bar-value" style="width: 80%; "></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                <?php } 
                } 
        }
        
        
        function format_video($options) {
            if (!empty($options['video_url'])) {
                global $pb_options;
                $block = isset($pb_options['block']) ? intval($pb_options['block']) : 1;
                if($block != 3) {
                    echo apply_filters("the_content", $options["video_url"]);
                } else {
                    echo getEmbedVideoImg($options["video_url"]);
                }
            }
        }
        
        
        function format_quote($options) {
            if (!empty($options['quote_text'])) {
                echo '<div class="quote-content"><blockquote>';
                echo "<p>".$options["quote_text"]."</p>";
                if(!empty($options["quote_author"])) {
                    $link = !empty($options["quote_link"]) ? to_url($options["quote_link"]) : "#";
                    $target = !empty($options['quote_target']) ? $options['quote_target'] : "self";
                    echo "<a href='".$link."' target='".$target."'>- ".$options["quote_author"]."</a>";
                }
                echo "</blockquote></div>";
            }
        }
        
        
        function format_link($options) {
            if (!empty($options['link_title'])) {
                $url = !empty($options['link_url']) ? to_url($options['link_url']) : "#";
                $target = !empty($options['link_target']) ? $options['link_target'] : "self";
                echo '<div class="link-content"><h2 class="link-text">'.$options['link_title'].'</h2>';
                echo '<a href="' . $url . '" target="_' . $target . '"><span class="sub-title">- ' . $url . '</span></a></div>';
            }
        }
        
        
        function format_status($options) {
            if (!empty($options['status_url'])) {
                echo apply_filters("the_content", $options["status_url"]);
            }
        }
        
        
        
        function pagination() {
                global $wp_query;
                
                $prevclass = $nextclass = "disabled"; $prevlink = $nextlink = "";
                $pages = $wp_query->max_num_pages;
                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                
                if (empty($pages)) {
                    $pages = 1;
                }
                
                if (1 != $pages) {
                
                        if ($paged > 1) {
                            $prevlink = get_pagenum_link($paged - 1);
                            $prevclass = "active";
                        }
                        if ($paged < $pages) {
                            $nextlink = get_pagenum_link($paged + 1);
                            $nextclass = "active";
                        }

                        $big = 9999; // need an unlikely integer
                        echo "<div class='tt-pager-pagination'>";
                        echo "<div class='tt-pagination clearfix'>";

                        echo paginate_links(
                                array(
                                'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
                                'end_size'     => 3,
                                'mid_size'     => 6,
                                'format'       => '?paged=%#%',
                                'current' => max( 1, get_query_var('paged') ),
                                'total' => $wp_query->max_num_pages,
                                'type'         => 'list',
                                'prev_text'    => __('&laquo;','themeton'),
                                'next_text'    => __('&raquo;','themeton'),
                        ) );

                        echo "</div>";


//                        echo "<div class='tt-pager align-right'>";
//                        echo "<ul class='clearfix'>";
//                        echo "<li class='". $prevclass ."'><a href='". $prevlink ."'>". __("Prev", "themeton") ."</a></li>";
//                        echo "<li class='". $nextclass ."'><a href='". $nextlink ."'>". __("Next", "themeton") ."</a></li>";
//                        echo "</ul>";
//                        echo "</div>";



                        echo "</div>";
                }
                
        }
        
        
        
        
        
        function comment_count() {
                                            
                    if (comments_open ()) {
                        
                        if (get_settings_value('facebook_comment')) {
				return '<fb:comments-count data-href="'.get_permalink().'"></fb:comments-count>';
			} else {
                                                
                                $comment_count = get_comments_number('0', '1', '%');
                                if ($comment_count == 0) {
                                        $comment_trans = __('No comment', 'themeton');
                                } elseif ($comment_count == 1) {
                                        $comment_trans = __('One comment', 'themeton');
                                } else {
                                        $comment_trans = $comment_count . ' ' . __('comments', 'themeton');
                                }
                                                
                                return "<a href='". get_comments_link() ."' title='". $comment_trans ."' class='comment-count'>". $comment_trans ."</a>";
                        }
                    }
        }
        
        
        
        
        
        
        
        if (!function_exists('mytheme_comment')) :

            function mytheme_comment($comment, $args, $depth) {
            
                    $GLOBALS['comment'] = $comment;
                    print '<div class="comment-block">';
                    ?>	
                    <div class="comment">
                        <div class="comment-author"><span class="reply-line"></span>
                            <?php echo get_avatar($comment, $size = '50'); ?>
                            <div class="comment-meta">
                                <span class="comment-author-link">
                                    <?php print __("written by", "themeton")." ".get_comment_author_link(); ?>
                                </span>                            
                                <span class="comment-date"><?php echo __("On", "themeton")." ";printf(__('%1$s', 'themeton'), get_comment_date('j F Y')) ?></span>
                                <span class="comment-replay-link"><?php comment_reply_link(array_merge($args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?></span>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div class="comment-body">
                            <?php comment_text() ?>
                        </div>
                    </div><?php
            }

        endif;
        
        
        
        
        
        
        if (!function_exists('tt_comment_form')) :
            
            function tt_comment_form($fields) {
                    global $id, $post_id;	
                    if ( null === $post_id )
                            $post_id = $id;
                    else
                            $id = $post_id;

                    $commenter = wp_get_current_commenter();

                    $req = get_option( 'require_name_email' );
                    $aria_req = ( $req ? " aria-required='true'" : '' );
                    $fields =  array(
                            'author' => '<p class="comment-form-author">' . '<label for="author">' . __( 'Name', 'themeton' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
                                        '<input placeholder="'.__('Name', 'themeton').'" id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . ' /></p>',
                            'email'  => '<p class="comment-form-email"><label for="email">' . __( 'Email', 'themeton' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
                                        '<input placeholder="'.__('Email', 'themeton').'" id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30"' . $aria_req . ' /></p>',
                            'url'    => '<p class="comment-form-url"><label for="url">' . __( 'Website', 'themeton' ) . '</label>' .
                                        '<input placeholder="'.__('Website', 'themeton').'" id="url" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" /></p>',
                    );
                    return $fields;
            }
            add_filter( 'comment_form_default_fields', 'tt_comment_form' );
        
        endif;
        
        
        
        
        
        
        
        
        
        
        function post_image_show($width = 0, $height = 0) {
            global $post;            
            if (has_post_thumbnail($post->ID)) {
                $attachment = get_post( get_post_thumbnail_id($post->ID) );
				if(isset($attachment)) {
					$alt = get_post_meta( $attachment->ID, '_wp_attachment_image_alt', true );
					$alt = !empty($alt) ? $alt : $attachment->post_title;
					$lrg_img = wp_get_attachment_image_src($attachment->ID, 'full');
					$url = $lrg_img[0];
					if ($width != 0 && $height != 0) {
						$url = aq_resize($url, $width, $height, true);
					}
					return '<img src="'.$url.'" alt="'. $alt .'"/>';
				} else return false;
            }
            return false;
        }
        
        
        
        
        
        
        
        
        if(!function_exists('about_author')){
            
            function about_author() {            
                $author = false;
                if(get_field("meta_author")=="true") {
                    $author = true;
                } else if(get_field("meta_author")!="false") {
                    $option = is_single() ? "post_author" : "page_author";
                    if(get_settings_value($option)) {
                        $author = true;
                    }
                }
                if ($author) { ?>
                    <div class="item-author clearfix">
                        <?php $author_email =  get_the_author_meta('email'); echo get_avatar( $author_email, $size = '60'); ?>
                        <h3><?php _e("Written by ", "themeton");?><?php if(is_author()) the_author(); else the_author_posts_link(); ?></h3>
                        <div class="author-title-line"></div>
                        <p>
                            <?php
                                $description = get_the_author_meta('description');
                                if ($description != '') echo $description;
                                else _e('The author didnt add any Information to his profile yet', 'themeton'); 
                            ?>
                        </p>
                    </div>
                <?php }
            }
        }
        
        
        
        
        
        
        
        function related_portfolios() {
            
                    global $post,$pb_options;


                    $tags = wp_get_post_terms($post->ID, 'portfolios', array("fields" => "ids"));
                    
                    if($tags) {
                            $rel_title = __("Related portfolio items", "themeton");
                            echo '<h3 class="tt-element-title">'.$rel_title.'<span class="tt-element-title-border"></span></h3>';
                            $tag_ids = "";
                            foreach($tags as $tag)
                                $tag_ids .= $tag.",";

                            
                            $query = Array(
                                    'post_type' => 'portfolio',
                                    'posts_per_page' => '4',
                                    'tax_query' => Array(Array(
                                        'taxonomy' => 'portfolios',
                                        'terms' => $tag_ids,
                                        'field' => 'id'
                                    ))
                            );
                            query_posts($query);
                            $pb_options['block'] = 4;
                            $pb_options['show_pagination'] = false;
                            $pb_options['container'] = "fullwidth";
                            $pb_options['size'] = "size_col_full";
                            get_template_part("loop","portfolio");
                            
                    }                    
                            
        }