<?php 
$portfolio_settings = Array(
    'preview_url' => Array('type' => 'text', 'description' => __('Preview url', 'themeton'), 'title' => __('Preview url', 'themeton')),
    'image_height' => Array('type' => 'text', 'description' => __('Image height on single post', 'themeton'), 'title' => __('Image height', 'themeton')),
    'meta_client' => Array('type' => 'text', 'description' => __('Project client', 'themeton'), 'title' => __('Client', 'themeton')),
    'used_tech' => Array('type' => 'text', 'description' => __('Used tech', 'themeton'), 'title' => __('Used Tech', 'themeton')),
);

add_action('init', 'portfolio_register');

function portfolio_register() {
    
    $labels = array(
        'name' => __('Portfolio', 'themeton'),
        'singular_name' => __('Portfolio', 'themeton'),
        'add_new' => __('Add New', 'themeton'),
        'add_new_item' => __('Add New Portfolio', 'themeton'),
        'edit_item' => __('Edit Portfolio', 'themeton'),
        'new_item' => __('New Portfolio', 'themeton'),
        'all_items' => __('All Portfolios', 'themeton'),
        'view_item' => __('View Portfolio', 'themeton'),
        'search_items' => __('Search Portfolios', 'themeton'),
        'not_found' =>  __('No Portfolio found', 'themeton'),
        'not_found_in_trash' => __('No Portfolio found in Trash', 'themeton'),
        'menu_name' => __('Portfolios', 'themeton')
    );
    
    $args = array(
        'labels' => $labels,
        'public' => true,
        '_builtin' => false,
        'capability_type' => 'post',
        'menu_icon' => get_template_directory_uri() . '/framework/resources/images/portfolio.png',
        'hierarchical' => false,
        'rewrite' => array( 'slug' => 'portfolio'),
        'supports' => array('title', 'editor', 'thumbnail')
    );

    register_post_type('portfolio', $args);
    flush_rewrite_rules();
}

register_taxonomy("portfolios", array("portfolio"), array("hierarchical" => true, "label" => __("Categories", "themeton"), "singular_label" => __("Portfolio Category", "themeton"), "rewrite" => true));


add_action('admin_init', 'portfolio_settings_custom_box');

function portfolio_settings_custom_box() {
    global $portfolio_settings;
    add_meta_box(
        'portfolio_meta_settings',
        __( 'Portfolio settings', 'themeton' ), 
        'portfolio_settings',
        'portfolio',
        'normal',
        'high',
        $portfolio_settings
    );
}

function portfolio_custom_columns($column) {
    global $post;
    switch ($column) {
        case "thumbnail":
            echo post_image_show() ? post_image_show(45,45) : ("<img src='".get_template_directory_uri()."/resources/images/no-thumb.png'>");
            break;
        case "portfolio":
            echo get_the_term_list($post->ID, 'portfolios', '', ', ', '');
            break;
        case "price":
            echo get_the_term_list($post->ID, 'prices', '', ', ', '');
            break;
        case "team":
            echo get_the_term_list($post->ID, 'position', '', ', ', '');
            break;
        case "testimonial":
            echo get_the_term_list($post->ID, 'testimonials', '', ', ', '');
            break;
    }
}
add_action("manage_posts_custom_column", "portfolio_custom_columns");

function portfolio_edit_columns($columns){	
        $columns = array(
            "cb" => "<input type=\"checkbox\" />",
            "thumbnail" => __("Image", "themeton"),
            "title" => __("Portfolio Title", "themeton"),
            "portfolio" => __("Categories", "themeton"),
            "date" => __("Date", "themeton"),
        );
        return $columns;
}
add_filter('manage_edit-portfolio_columns', 'portfolio_edit_columns');


function portfolio_settings($post, $metabox) {
    global $post; 
    $options = get_post_meta($post->ID, 'themeton_'.THEMENAME.'_options', true);?>
        <div class="additional_panel_container">
            <div class="additional_panel">
                <table>
                    <?php	                              
                    foreach ($metabox['args'] as $type=>$settings) {
                        $settings['name'] = $type;
                        $settings['value'] = isset($options[$settings['name']]) ? $options[$settings['name']] : (isset($settings['default']) ? $settings['default'] : '');
                        call_user_func('settings_'.$settings['type'], $settings);	
                    }                    
                    ?>    
                </table>
            </div>
        </div>
<?php 
}
?>