<?php
global $staticWidths;
$defaultWidth=!empty($staticWidths['blog'])?$staticWidths['blog']:'size_col_full';
$categories = get_categories("hide_empty=0");
$select = '<option value="0">' . __('All categories', 'themeton') . '</option>';
foreach ($categories as $category) {
    $select .= '<option value="' . $category->slug . '">' . $category->name . '</option>';
}

$cb_toolbar_title[] = "Blog";
$cb_toolbar_video[] = "http://docs.themeton.com/emerald/2013/02/blog-element/";
$cb_toolbar_width[] = $defaultWidth;
$cb_toolbar_html[] = '<div class="cb_hidden_form">
                        <div class="cb_form_wrapper">
                            <div class="tt-title-container">
                                <div class="tt-head-element add_item_medium">
                                    <input type="text" class="cbf_title" placeholder="Title of Item" />
                                </div>
                                <div class="tt-head-element add_item">
                                    <select name="cbf_title_style" class="cbf_title_style default_value">
                                        <option value="1">H1</option>
                                        <option value="2">H2</option>
                                        <option value="3">H3</option>
                                        <option value="4">H4</option>
                                        <option value="5">H5</option>
                                    </select>
                                </div>
                                <div class="tt-head-element add_item">
                                    <div class="color_selector">
                                        <div class="color_picker" id="skin_background_color"><div style="background-color: #701010;" class="color_picker_inner"></div></div>
                                        <input type="text" class="color_picker_value" name="skin_background_color"  value="#701010">
                                    </div>
                                </div>
                                <div class="tt-head-element add_item_medium">
                                    <input type="text" class="cbf_custom_class" placeholder="Custom class" />
                                </div>
                            </div>
                            
                            <div class="clear"></div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Category</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select class="default_blog">' . $select . '</select>
                                </div>
                                <div class="tt-description">
                                    Choose the post category you want to include the blog post.
                                </div>
                                <div class="category_list"></div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Blog Style</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select name="cbf_block" class="cbf_block">
                                        <option value="1">Block 1</option>
                                        <option value="2">Block 2</option>
                                        <option value="3">Block 3</option>
                                        <option value="4">Block 4</option>
                                    </select>
                                </div>
                                <div class="tt-description">
                                    Blog displaying style.
                                </div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Post Count</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <input type="text" class="cbf_post_count" placeholder="10" />
                                </div>
                                <div class="tt-description">
                                    How many posts will it display.
                                </div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Pagination</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select name="cbf_pagination" class="cbf_pagination">
                                        <option value="1">' . __('Yes', 'themeton') . '</option>
                                        <option value="0">' . __('No', 'themeton') . '</option>
                                    </select>
                                </div>
                                <div class="tt-description">
                                    If Yes your blog displaying with PAGINATION.
                                </div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Excerpt</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <input type="text" class="cbf_excerpt_count" placeholder="50" />
                                </div>
                                <div class="tt-description">
                                    Inserted words can break blog posts. Empty, 0 or number value allowed. 
                                </div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Read More</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <input type="text" class="cbf_more_text" placeholder="Read More" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="cb_hidden_data">
                        <title></title>
                        <type>blog</type>
                        <size>'.$defaultWidth.'</size>
                        <title_style>3</title_style>
                        <start_row></start_row>
                        <custom_class></custom_class>
                        <color_picker_value></color_picker_value>
                        <category_list></category_list>
                        <pagination>1</pagination>
                        <block>1</block>
                        <post_count>'.get_option('posts_per_page').'</post_count>
                        <excerpt_count>50</excerpt_count>
                        <more_text>Read more</more_text>
                    </div>';

function cb_item_blog($item) {
    $custom_class = find_xml_value($item, 'custom_class');
    global $pb_options, $paged;
    $html_start = '<div class="' .$custom_class.' '. size_back_to_front(find_xml_value($item, 'size')) .((find_xml_value($item, 'start_row')==='true')?' start-row':''). '">';
    $html_start .= '<div class="tt-element">';
    if (find_xml_value($item, 'title') != "") {
        $html_start .= get_element_title(find_xml_value($item, 'title'),find_xml_value($item, 'title_style'),find_xml_value($item, 'color_picker_value'));
    }
    $html_start .= '<div class="tt-blog">';
    /* LOOP HERE */
    $html_end = '</div>';
    $html_end .= '</div>';
    $html_end .= '</div>';

    $pb_options['show_pagination'] = (find_xml_value($item, 'pagination') != "" && find_xml_value($item, 'pagination'));
    $pb_options['title_top'] = (find_xml_value($item, 'title_top') != "" && find_xml_value($item, 'title_top'));
    $pb_options['excerpt_count'] = (find_xml_value($item, 'excerpt_count') != "") ? intval(find_xml_value($item, 'excerpt_count')) : '';
    $pb_options['more_text'] = (find_xml_value($item, 'more_text') != "") ? find_xml_value($item, 'more_text') : 'Read More';
    $pb_options['block'] = (find_xml_value($item, 'block') != "") ? find_xml_value($item, 'block') : '1';
    $pb_options['post_count']=find_xml_value($item, 'post_count')!= "" ? find_xml_value($item, 'post_count') : get_option('posts_per_page');
    
    $query = Array(
        'post_type' => 'post',
        'posts_per_page' => $pb_options['post_count'],
        'paged' => $paged,
    );
    $tab_xml = find_xml_node($item, 'category_list');
    foreach ($tab_xml->childNodes as $node) {
        if (find_xml_value($node, 'name') != "") {
            $cats[] = find_xml_value($node, 'name');
        }
    }
    if(isset($cats)) {
        $query['tax_query'] = Array(Array(
                'taxonomy' => 'category',
                'terms' => $cats,
                'field' => 'slug'
            )
        );
    }
    echo $html_start;
    query_posts($query);
    get_template_part("loop");
    wp_reset_query();
    echo $html_end;
}