<?php
$client_settings = Array(
        'link' => Array('type' => 'text', 'description' => __('Link', 'themeton'), 'title' => __('Url', 'themeton')),
);

add_action('init', 'client_register');

function client_register() {
    
    $labels = array(
        'name' => __('Our Partners', 'themeton'),
        'singular_name' => __('Partner', 'themeton'),
        'add_new' => __('Add New', 'themeton'),
        'add_new_item' => __('Add New Partner', 'themeton'),
        'edit_item' => __('Edit Item', 'themeton'),
        'new_item' => __('New Item', 'themeton'),
        'all_items' => __('All Partners', 'themeton'),
        'view_item' => __('View Partner', 'themeton'),
        'search_items' => __('Search Partners', 'themeton'),
        'not_found' =>  __('No Partner found', 'themeton'),
        'not_found_in_trash' => __('No partner in Trash', 'themeton'),
        'menu_name' => __('Partners', 'themeton')
    );
    
    $args = array(
        'labels' => $labels,
        'public' => true,
        '_builtin' => false,
        'capability_type' => 'post',
        'menu_icon' => get_template_directory_uri() . '/framework/resources/images/client.png',
        'hierarchical' => false,
        'rewrite' => array( 'slug' => 'client'),
        'supports' => array('title', 'editor', 'thumbnail')
    );

    register_post_type('client', $args);
    flush_rewrite_rules();
}

add_action('admin_init', 'client_settings_custom_box');

function client_settings_custom_box() {
    global $client_settings;
    add_meta_box(
        'client_meta_settings',
        __( 'Client settings', 'themeton' ), 
        'client_settings',
        'client',
        'normal',
        'high',
        $client_settings
    );
}

function client_edit_columns($columns){	
        $columns = array(
            "cb" => "<input type=\"checkbox\" />",
            "thumbnail" => __("Image", "themeton"),
            "title" => __("Clients", "themeton"),            
            "date" => __("Date", "themeton"),
        );
        return $columns;
}
add_filter('manage_edit-client_columns', 'client_edit_columns');

function client_settings($post, $metabox) {
    global $post; 
    $options = get_post_meta($post->ID, 'themeton_'.THEMENAME.'_options', true);?>
        <div class="additional_panel_container">            
            <div class="additional_panel">
                <table>
                    <?php
                    foreach ($metabox['args'] as $type=>$settings) {
                        $settings['name'] = $type;
                        $settings['value'] = isset($options[$settings['name']]) ? $options[$settings['name']] : (isset($settings['default']) ? $settings['default'] : '');
                        call_user_func('settings_'.$settings['type'], $settings);	
                    }
                    ?>
                </table>
            </div>                     
        </div>
<?php 
}
?>