<?php
function settings_checkbox($settings){

    $default = $settings['value'];
    $datashow = $datahide = $klass = "";
    if (!empty($settings['hide'])) {
        $klass = " check-show-hide";
        $datahide = $settings['hide'];
    }
    if (!empty($settings['show'])) {
        $klass = " check-show-hide";
        $datashow = $settings['show'];
    }
    ?>
    <tr id="field_<?php echo $settings['name']; ?>">
        <td>
            <label for="<?php echo $settings['name']; ?>"><?php echo $settings['title']; ?></label>
            <div class="type_check">
                <input type="hidden" name="<?php echo $settings['name']; ?>" id="<?php echo $settings['name']; ?>" value="0"/>
                <input type="checkbox" class="yesno<?php echo $klass;?>" id="<?php echo $settings['name']; ?>" data-show="<?php echo $datashow;?>" data-hide="<?php echo $datahide;?>" name="<?php echo $settings['name']; ?>" value="1" <?php echo checked($default, 1, false);?> />
            </div>            
        </td>
        <td>
            <small>
                <?php echo $settings['description']; ?>
            </small>
        </td>
    </tr>
<?php } ?>
<?php
function settings_textarea($settings){
?>
    <tr id="<?php echo $settings['name']; ?>">
        <td>            
            <label><?php echo $settings['title']; ?></label>
            <div class="type_text">
                <textarea rows="5" name="<?php echo $settings['name']; ?>"><?php echo $settings['value']; ?></textarea>
            </div>
        </td>
        <td>
            <small>
                <?php echo $settings['description']; ?>
            </small>
        </td>
    </tr>
<?php } ?>
<?php
function settings_text($settings){
?>
    <tr id="<?php echo $settings['name']; ?>">
        <td>
            <label><?php echo $settings['title']; ?></label>
            <div class="type_text">
                <input type="text" name="<?php echo $settings['name']; ?>" id="<?php echo $settings['name']; ?>" value="<?php echo $settings['value']; ?>" />
            </div>
        </td>
        <td>
            <small>
                <?php echo $settings['description']; ?>
            </small>
        </td>
    </tr>
<?php } ?>
<?php
function settings_file($settings){
?>
    <tr id="<?php echo $settings['name']; ?>">
        <td>
            <label><?php echo $settings['title']; ?></label>
            <div class="type_text">
                <input type="text" id="<?php echo $settings['name']; ?>" name="<?php echo $settings['name']; ?>" value="<?php echo $settings['value']; ?>" placeholder="Your Custom BG Image URL" size=""/>
                <a href="#" class="button insert-images theme_button format" onclick="browseimage('<?php echo $settings['name']; ?>')"><?php _e('Insert image', "themeton"); ?></a>
            </div>
        </td>
        <td>
            <small>
                <?php echo $settings['description']; ?>
            </small>
        </td>
    </tr>
<?php } ?>
<?php
function settings_selectbox($settings){
    $settings['options'] = array('true', 'default', 'false');
?>
    <tr id="<?php echo $settings['name']; ?>">
        <td>
            <label><?php echo $settings['title']; ?></label>
            <div class="type_check">
                <select class="selectbox" name="<?php echo $settings['name']; ?>" data-value="<?php print $settings['value'];?>">
                <?php foreach ($settings['options'] as $meta) {
                                print '<option value="' . $meta . '" ';
                                print $meta == $settings['value'] ? 'selected ' : '';
                                print '>' . $meta . '</option>';
                } ?>
                </select>
            </div>
        </td>
        <td>
            <small>
                <?php echo $settings['description']; ?>
            </small>
        </td>
    </tr>
<?php } ?>
<?php
function settings_layoutpage($settings){}
function settings_layout($settings){
?>
    <tr id="<?php echo $settings['name']; ?>">
        <td colspan="2">
            <div class="type_layout">
                <a href="javascript:;" data-value="left" class="left-sidebar"></a>
                <a href="javascript:;" data-value="right" class="right-sidebar"></a>
<!--                <a href="javascript:;" data-value="both" class="both-sidebar"></a>-->
                <a href="javascript:;" data-value="without" class="without-sidebar"></a>
                <input name="<?php echo $settings['name'];?>" type="hidden" value="<?php echo $settings['value'];?>" />
            </div>        
            <div class="type_layout_desc">
                <small>
                    <?php echo $settings['description']; ?>
                </small>
            </div>
        </td>
    </tr>
<?php } ?>
<?php
function settings_radio($settings){
?>
    <tr id="<?php echo $settings['name']; ?>">
        <td>
            <label for="<?php echo $settings['name']; ?>"><?php echo $settings['title']; ?></label>
            <div class="type_radio">
                <?php        
                foreach ($settings['options'] as $option) {
                    print '<input type="radio" style="margin-right:5px;" name="' . $settings['name'] . '" value="' . $option . '" ';
                    print $option == $settings['value'] ? 'checked ' : '';
                    print '><span style="margin-right:20px;">' . $option . '</span><br />';
                }        
                ?>
            </div>
        </td>
        <td>
            <small>
                <?php echo $settings['description']; ?>
            </small>
        </td>
    </tr>
<?php } ?>
<?php
function settings_color($settings){
?>
    <tr id="<?php echo $settings['name']; ?>">
        <td>
            <label for="<?php echo $settings['name']; ?>"><?php echo $settings['title']; ?></label>
            <div class="color_selector">
                <div class="color_picker"><div style="background-color: <?php echo $settings['value']; ?>;" class="color_picker_inner"></div></div>
                <input type="text" class="color_picker_value" id="<?php echo $settings['name']; ?>" name="<?php echo $settings['name']; ?>" value="<?php echo $settings['value']; ?>" />
                <div class="clear"></div>
            </div>
        </td>
        <td>
            <small>
                <?php echo $settings['description']; ?>
            </small>
        </td>
    </tr>
<?php } ?>
<?php
function settings_select($settings){
?>
    <tr id="<?php echo $settings['name']; ?>">
        <td>
            <label for="<?php echo $settings['name']; ?>"><?php echo $settings['title']; ?></label>
            <div class="type_select add_item_medium">
                <select class="medium" name="<?php echo $settings['name']; ?>" data-value="<?php print $settings['value'];?>">
                    <?php
                            foreach($settings['options'] as $key=>$value) { 
                                    echo '<option value="'.$key.'">'.$value.'</option>';
                            }
                    ?>
                </select>
            </div>
        </td>
        <td>
            <small>
                <?php echo $settings['description']; ?>
            </small>
        </td>
    </tr>
<?php } ?>
<?php
function settings_slideshow($settings){
    global $wpdb;
    $table_name = $wpdb->prefix . "layerslider";
    $sliders = $wpdb->get_results( "SELECT * FROM $table_name
                                    WHERE flag_hidden = '0' AND flag_deleted = '0'
                                    ORDER BY date_c ASC LIMIT 100" );
?>
    <tr id="<?php echo $settings['name']; ?>">
        <td>
            <label for="<?php echo $settings['name']; ?>"><?php echo $settings['title']; ?></label>
            <div class="type_select add_item_medium">
                <select class="medium" name="<?php echo $settings['name']; ?>" data-value="<?php print $settings['value'];?>">
                    <?php
                        if(!empty($sliders)) {
                            foreach($sliders as $key => $item) {
                                    $name = empty($item->name) ? ('Unnamed('.$item->id.')') : $item->name;
                                    echo '<option value="[layerslider id=\''.$item->id.'\']">'.$name.'</option>';
                            }
                        }
                    ?>
                </select>
            </div>
        </td>
        <td>
            <small>
                <?php echo $settings['description']; ?>
            </small>
        </td>
    </tr>
<?php } ?>