<?php
global $fields;

$fields['general_settings'] = Array(
    'header_logo' => Array(
        'type' => 'browse',
        'title' => __('Header Logo', 'themeton'),
        'default' => get_template_directory_uri().'/resources/images/logo.png',
        'description' => __('Upload your logo image.', 'themeton')),
    'favicon' => Array(
        'type' => 'browse',
        'title' => __('Favicon', 'themeton'),
        'default' => get_template_directory_uri().'/resources/images/favicon.ico',
        'description' => __('Upload a 16px x 16px image that will represent your website\'s favicon.<br />To ensure cross-browser compatibility, we recommend converting the favicon into .ico format before uploading. (<a href="http://www.favicon.cc/">www.favicon.cc</a>)', 'themeton')),
    'search_menu' => Array(
        'type' => 'checkbox',
        'title' => __('Search widget on menu', 'themeton'),
        'default' => 1,
        'description' => __('If checked, search widget will show on menu section.', 'themeton')),
    'tracking_code' => Array(
        'type' => 'textarea',
        'title' => __('Tracking code', 'themeton'),
        'description' => __('Please include your Google analytics or other tracking code here. It is official site of the Google <a href="http://www.google.com/analytics/" target="_blank">analytics</a>.', 'themeton')),
    'facebook_comment' => Array(
        'type' => 'checkbox',
        'title' => __('Use facebook comment ?', 'themeton'),
        'description' => __('If checked, site comment will show by facebook comments.', 'themeton'),
        'default' => 0,
        'show' => 'facebook_app_id'),
    'facebook_app_id' => Array(
        'type' => 'textinput',
        'title' => __('Facebook App ID', 'themeton'),
        'description' => __('Please include your facebook App ID. You can get your appid from <a href="http://developers.facebook.com/docs/" target="_blank">here</a>.', 'themeton')),
);
foreach($fields['general_settings'] as $type=>$field) {
    $field["name"] = $type;
    if(function_exists('form_field_'.$field["type"]))
        call_user_func('form_field_'.$field["type"], $field);
}
	
?>