<?php

if (!function_exists('initGlobalScripts')) {

    function initGlobalScripts() {
        echo'<script type="text/javascript">var $homeURI="' . home_url() . '";</script>';
    }

}add_action('admin_footer', 'initGlobalScripts');
if (!function_exists('size_back_to_front')) {

    function size_back_to_front($size = 'size_col_3_1') {
        switch ($size) {
            case'size_col_4_1' : {
                    $size = 'col three';
                    break;
                }
            case'size_col_3_1' : {
                    $size = 'col four';
                    break;
                }
            case'size_col_half': {
                    $size = 'col six';
                    break;
                }
            case'size_col_3_2' : {
                    $size = 'col eight';
                    break;
                }
            case'size_col_4_3' : {
                    $size = 'col nine';
                    break;
                }
            case'size_col_full': {
                    $size = 'col twelve';
                    break;
                }
        }
        return $size;
    }

}
if (!function_exists('size_to_text')) {

    function size_to_text($size = 'size_col_3_1') {
        switch ($size) {
            case'size_col_4_1' : {
                    $size = '1 / 4';
                    break;
                }
            case'size_col_3_1' : {
                    $size = '1 / 3';
                    break;
                }
            case'size_col_half': {
                    $size = '1 / 2';
                    break;
                }
            case'size_col_3_2' : {
                    $size = '2 / 3';
                    break;
                }
            case'size_col_4_3' : {
                    $size = '3 / 4';
                    break;
                }
            case'size_col_full': {
                    $size = '1 / 1';
                    break;
                }
        }
        return $size;
    }

}
if (!function_exists('portfolio_size')) {

    function portfolio_size($size = 'size_col_full_4', $container="fullwidth") {
        if($container == "fullwidth") {
            switch ($size) {
                case'size_col_full_4': {$size = '273';break;}
                case'size_col_full_3': {$size = '373';break;}
                case'size_col_full_2': {$size = '573';break;}
                case'size_col_4_3_4' : {$size = '203';break;}
                case'size_col_4_3_3' : {$size = '278';break;}
                case'size_col_4_3_2' : {$size = '427';break;}
                case'size_col_3_2_4' : {$size = '180';break;}
                case'size_col_3_2_3' : {$size = '246';break;}
                case'size_col_3_2_2' : {$size = '377';break;}
            }
            return $size;
        } elseif($container == "with-sidebar") {
            switch ($size) {
                case'size_col_full_4': {$size = '174';break;}
                case'size_col_full_3': {$size = '240';break;}
                case'size_col_full_2': {$size = '372';break;}
                case'size_col_4_3_4' : {$size = '129';break;}
                case'size_col_4_3_3' : {$size = '178';break;}
                case'size_col_4_3_2' : {$size = '276';break;}
                case'size_col_3_2_4' : {$size = '114';break;}
                case'size_col_3_2_3' : {$size = '158';break;}
                case'size_col_3_2_2' : {$size = '244';break;}
            }
            return $size;
        }
    }

}
if (!function_exists('carousel_size')) {

    function carousel_size($size = 'size_col_3_1', $container) {
        if($container == "fullwidth") {
            switch ($size) {
                case'size_col_4_1' : {$size = '274';break;}
                case'size_col_3_1' : {$size = '177';break;}
                case'size_col_half': {$size = '276';break;}
                case'size_col_3_2' : {$size = '244';break;}
                case'size_col_4_3' : {$size = '277';break;}
                case'size_col_full': {$size = '277';break;}
            }
            return $size;
        } elseif($container == "with-sidebar") {
            switch ($size) {
                case'size_col_4_1' : {$size = '175';break;}
                case'size_col_3_1' : {$size = '241';break;}
                case'size_col_half': {$size = '177';break;}
                case'size_col_3_2' : {$size = '243';break;}
                case'size_col_4_3' : {$size = '276';break;}
                case'size_col_full': {$size = '243';break;}
            }
            return $size;
        } else {
            return $size = '164';
        }
    }

}
if (!function_exists('get_element_title')) {

    function get_element_title($title, $size, $color) {
        return empty($title) || empty($size) ? '' : ('<h' . $size . ' class="tt-element-title" '. (!empty($color) ? ('style="color:' . $color . ';">') : ">") . $title . '<span class="tt-element-title-border"></span></h' . $size . '>');
    }

}
if (!function_exists('get_element_content')) {

    function get_element_content($content) {
        return do_shortcode($content);
    }

}

function find_xml_value($xml, $field) {
    if (!empty($xml->childNodes)) {
        foreach ($xml->childNodes as $xmlChild) {
            if ($xmlChild->nodeName == $field) {
                return $xmlChild->nodeValue;
            }
        }
    }
    return '';
}

function find_xml_node($xml, $node) {
    if (!empty($xml->childNodes)) {
        foreach ($xml->childNodes as $xmlChild) {
            if ($xmlChild->nodeName == $node) {
                return $xmlChild;
            }
        }
    }
    return '';
}

global $modules;
$modules = array();
$modules[] = 'accordion';
$modules[] = 'blog';
$modules[] = 'carousel';
$modules[] = 'callout';
$modules[] = 'column';
$modules[] = 'column_service';
$modules[] = 'content';
$modules[] = 'divider';
$modules[] = 'image_slider';
$modules[] = 'messagebox';
$modules[] = 'portfolio';
$modules[] = 'pricing_table';
$modules[] = 'progress_bar';
$modules[] = 'recent_posts';
$modules[] = 'sidebar';
$modules[] = 'slider';
$modules[] = 'tab';
$modules[] = 'team';
$modules[] = 'testimonials';
$modules[] = 'toggle';
$modules[] = 'twitter';
$modules[] = 'video';
// Static width size
global $staticWidths;
$staticWidths = array();
//$staticWidths['blog']      = 'size_col_full';
//$staticWidths['portfolio'] = 'size_col_full';
//$staticWidths['team']      = 'size_col_full';

// Mini width sizes
global $miniWidths;
$miniWidths = array();
$miniWidths['blog']      = 'true';
$miniWidths['portfolio'] = 'true';
$miniWidths['team']      = 'true';

$cb_toolbar_title = array();
$cb_toolbar_width = array();
$cb_toolbar_html  = array();
$cb_toolbar_video = array();

foreach ($modules as $module) {
    include(file_require(get_template_directory() . '/framework/pagebuilder/items/' . $module . '/init.php'));
}

function get_content_builder() {
    global $post, $container;
    ob_start();
    $container = "fullwidth";
    if (get_field("page_layout") == "left") {
        cb_sidebar("left");
    }
    if (get_field("page_layout") == "left" || get_field("page_layout") == "right") {
        $container = "with-sidebar";
        echo '<div class="col eight with-sidebar">';
        echo '<div class="row">';
        echo '<section class="content">';
    } else {
        echo '<section class="content">';
    }
    $nocontent = true;
    $content = get_post_meta($post->ID, '_cb_textarea', true);
    $content_xml = new DOMDocument();
    $content_xml->loadXML('<root>' . $content . '</root>');
    foreach ($content_xml->documentElement->childNodes as $item_xml) {
        $type = find_xml_value($item_xml, 'type');
        if ($type != '') {
            $nocontent = false;
            $func = 'cb_item_' . $type;
            $func($item_xml);
        }
    }
    if ($nocontent) {
        $item = '<cb_item>
                        <size>size_col_full</size>
                </cb_item>';

        $content_xml = new DOMDocument();
        $content_xml->loadXML($item);
        cb_item_content($content_xml->documentElement);
    }
    ob_start();
    about_author();
    $author = ob_get_clean();
    if(!empty($author)) {
        echo "<div class='col twelve item-author-container'>";
        echo $author;
        echo "</div>";
    }

    if(get_settings_value("page_comment")!="" && get_settings_value("page_comment")) {
        echo "<div class='col twelve'>";
        comments_template('', true);
        echo "</div>";
    }    
    
    if (get_field("page_layout") == "left" || get_field("page_layout") == "right") {
        echo '</section>';
        echo '</div>';
        echo '</div>';
    } else {
        echo '</section>';
    }
    if (get_field("page_layout") == "right") {
        cb_sidebar("right");
    }
    $output = ob_get_clean();
    return $output;
}

function cb_sidebar($class) {
    global $post,$container;
    $container = "sidebar";
    $nocontent = true;
    $content = get_post_meta($post->ID, '_cb_sidebar_textarea', true);
    $content_xml = new DOMDocument();
    $content_xml->loadXML('<root>' . $content . '</root>');
    echo '<div class="col four">';
    echo '<div id="sidebar" class="' . $class . '-sidebar">';
    foreach ($content_xml->documentElement->childNodes as $item_xml) {
        $type = find_xml_value($item_xml, 'type');
        if ($type != '') {
            $nocontent = false;
            $func = 'cb_item_' . $type;
            $func($item_xml);
        }
    }
    if ($nocontent) {
        //echo '<div class="col four">';
        if (!dynamic_sidebar('default-sidebar')) {
            print 'There is no widget. You should add your widgets into <strong>';
            print 'Default';
            print '</strong> sidebar area on <strong>Appearance => Widgets</strong> of your dashboard. <br/><br/>';
        }
        //echo '</div>';
    }
    echo '</div>';
    echo '</div>';
}

function cb_reg_item($item, $tag) {
    preg_match('/<' . $tag . '>(.*?)<\/' . $tag . '>/si', $item, $filteredContent);
    return trim($filteredContent[0]);
}

add_action('admin_print_scripts', 'pagebuilder_admin_script');

function pagebuilder_admin_script() {
    global $pagenow, $typenow;
    global $settings_url;
    global $modules;

    if (empty($typenow) && !empty($_GET['post'])) {
        $post = get_post($_GET['post']);
        $typenow = $post->post_type;
    }

    if (current_user_can('edit_posts') && ($pagenow == 'post-new.php' OR $pagenow == 'post.php')) {

        if ($typenow == 'page') {

            wp_register_script('jquery-ui', get_template_directory_uri() . $settings_url . 'resources/jquery-ui/jquery-ui.js');
            wp_register_script('jquery-drag', get_template_directory_uri() . $settings_url . 'resources/jquery.dragsort/jquery.dragsort-0.5.1.min.js');
            wp_register_script('page-builder-script', file_require(get_template_directory_uri() . $settings_url . 'pagebuilder/script.js'));

            wp_enqueue_script('jquery');
            wp_enqueue_script('thickbox');
            wp_enqueue_script('tiny_mce');
            wp_enqueue_script('jquery-ui');
            wp_enqueue_script('jquery-drag');
            wp_enqueue_script('page-builder-script');

            foreach ($modules as $key => $module) {
                wp_register_script('pb_item_script_' . $key, file_require(get_template_directory_uri() . $settings_url . 'pagebuilder/items/' . $module . '/script.js'));
                wp_enqueue_script('pb_item_script_' . $key);
            }
        }
    }
}

add_action('admin_print_styles', 'pagebuilder_admin_styles');

function pagebuilder_admin_styles() {
    global $pagenow, $typenow;
    global $settings_url;
    global $modules;
    global $wp_styles;
    if (empty($typenow) && !empty($_GET['post'])) {
        $post = get_post($_GET['post']);
        $typenow = $post->post_type;
    }

    if (is_admin() && ($pagenow == 'post-new.php' OR $pagenow == 'post.php')) {

        if ($typenow == 'page') {

            wp_register_style('jquery-ui', get_template_directory_uri() . $settings_url . 'resources/jquery-ui/jquery-ui.css');
            wp_register_style('open_sans', 'http://fonts.googleapis.com/css?family=Open+Sans:600,700,300,300italic'); // register webfont
            wp_register_style('page-builder-style', get_template_directory_uri() . $settings_url . 'pagebuilder/style.css');

            wp_enqueue_style('jquery-ui');
            wp_enqueue_style('open_sans');
            wp_enqueue_style('page-builder-style');

            foreach ($modules as $key => $module) {
                wp_register_script('pba_item_style_' . $key, file_require(get_template_directory_uri() . $settings_url . 'pagebuilder/items/' . $module . '/style.css'));
                wp_enqueue_script('pba_item__style_' . $key);
            }
        }
    }
}

add_action('admin_print_styles', 'pagebuilder_section', 1);

function pagebuilder_section() {
    add_meta_box(
            'cmeta_pagebuilder', __('Page Builder', 'cmeta_pagebuilder_td'), 'pagebuilder_section_box', 'page', 'normal', 'high'
    );
}

function pagebuilder_section_box() {
    global $post;
    global $modules, $cb_toolbar_title, $cb_toolbar_html, $cb_toolbar_width, $staticWidths, $miniWidths, $cb_toolbar_video;

    $templates  = '<div class="tt-title"><h4 class="title">&nbsp;</h4></div><div class="tt-template-container"><div id="dd" class="wrapper-dropdown-1" tabindex="1">';
        $templates .= '<span>Template</span>';
        $templates .= '<ul class="dropdown template-list">';
            $templates .= '<li class="template-list-item"><a class="template-add">Save this to Template</a></li>';

            $templates_array=get_option('tt_pb_templates');
            if($templates_array!==false){
                foreach($templates_array as $templates_name => $templates_content){
                    $templates .= '<li class="template-list-item"><a class="template-name">'.$templates_name.'</a><span class="template-delete">X</span></li>';
                }
            }
        $templates .= '</ul>';
    $templates .= '</div></div>';
    
    wp_nonce_field(plugin_basename(__FILE__), 'myplugin_noncename');

    $toolbar = '';
    $toolbar_option = '';
    $default = get_field("page_layout") != "" ? get_field("page_layout") : "without";

    echo "<div class='tt-container'>";
    echo "<div class='tt-title'>
            <h4 class='title'>".__('PAGE LAYOUT', 'themeton')."</h4>
            <hr class='separator'>
        </div>";
    echo "<div class='tt-elements'>";
    echo '<tr id="page_layout">
                <td colspan="2">
                    <div class="type_layout">
                        <a href="javascript:;" data-value="left" class="left-sidebar' . ($default == "left" ? " active" : "") . '"></a>
                        <a href="javascript:;" data-value="right" class="right-sidebar' . ($default == "right" ? " active" : "") . '"></a>
                        <a href="javascript:;" data-value="without" class="without-sidebar' . ($default == "without" ? " active" : "") . '"></a>
                        <input name="page_layout" type="hidden" value="' . $default . '">
                    </div>
                </td>
            </tr>';
    echo "</div>";
    echo "</div>";
    echo "<div class='clear'></div>";


    for ($i = 0; $i < count($cb_toolbar_title); $i++) {
        $size_class = strtolower(str_replace(" ", "_", $cb_toolbar_title[$i]));
        $isStaticWidth = !empty($staticWidths[$size_class]) ? true : false;
        $isMiniWidth   = !empty($miniWidths[$size_class])   ? true : false;
        $size_class = $isStaticWidth ? $staticWidths[$size_class] : $cb_toolbar_width[$i];

        $toolbar .= '<li>
                        <a href="javascript:;" class="cb_tbar_title"><span>' . $cb_toolbar_title[$i] . '</span></a>
                        <div class="cb_tbar_hidden_data hidden">
                            <div class="cb_item ' . $size_class . '">
                                <div class="cb_wrapper '.($isMiniWidth?'mini':'').'">
                                    <div class="cb_size_info" data-class="' . $size_class . '" data-text="' . size_to_text($size_class) . '">' . size_to_text($size_class) . '</div>';
        if (!$isStaticWidth) {
            $toolbar .= '<div class="cb_sizer"><a href="javascript:;" class="cb_sizer_inc">+</a><a href="javascript:;" class="cb_sizer_dec">-</a></div>';
        }
        $toolbar .= '<div class="cb_title"><span>' . $cb_toolbar_title[$i] . '</span></div>
                                    <div class="cb_action">
                                        <a href="javascript:;" class="cb_action_remove"  title="Delete This Item"><span></span></a>
                                        <a href="javascript:;" class="cb_action_edit"  title="Edit This Item" data-video="'.$cb_toolbar_video[$i].'"><span></span></a>
                                        <a href="javascript:;" class="cb_action_clone" title="Duplicate This Item"><span></span></a>
                                    </div>
                                    ' . $cb_toolbar_html[$i] . '
                                </div>
                            </div>
                        </div>
                    </li>';

        $toolbar_option .= '<div class="items ' . strtolower(str_replace(" ","_",$cb_toolbar_title[$i])) . '_item ' . $size_class . '" data-value="' . $i . '"></div>';
    }

    $toolbar_hidden_data = $toolbar;



    echo '<input type="hidden" name="pagebuilder">';

    echo '<div class="tt-container">
            <div class="tt-title">
                <h4 class="title">'.__('Add Items', 'themeton').'</h4>
                <hr class="separator">
            </div>
            <div class="tt-elements">
                <div class="add_item">
                    <div class="select_image" id="cbuilder_selector">
                            ' . $toolbar_option . '
                    </div>
                    <div style="display: none;" id="cb_selector_hidden_data">' . $toolbar_hidden_data . '</div>
                </div>
                <div class="clear"></div>
                <div id="cb_toolbar_items" style="display: none;">
                    <ul>
                        ' . $toolbar . '
                    </ul>
                </div>
            </div>
            <textarea id="cb_textarea" name="cb_textarea" class="hidden"></textarea>
            <textarea id="cb_html_textarea" name="cb_html_textarea" class="hidden"></textarea>
            <div id="cb_hidden_textarea" class="hidden">
                    ' . get_post_meta($post->ID, '_cb_textarea', true) . '
            </div>
            <div id="cb_hidden_html_textarea" class="hidden">
                    ' . get_post_meta($post->ID, '_cb_html_textarea', true) . '
            </div>
            <textarea id="cb_sidebar_textarea" name="cb_sidebar_textarea" class="hidden"></textarea>
            <textarea id="cb_sidebar_html_textarea" name="cb_sidebar_html_textarea" class="hidden"></textarea>
            <div id="cb_sidebar_hidden_textarea" class="hidden">
                    ' . get_post_meta($post->ID, '_cb_sidebar_textarea', true) . '
            </div>
            <div id="cb_sidebar_hidden_html_textarea" class="hidden">
                    ' . get_post_meta($post->ID, '_cb_sidebar_html_textarea', true) . '
            </div>
            <div class="clear"></div>
            <div id="delete_modal_hidden">
                <div id="theme_settings_info" style="display: none;">
                    <div class="msg_back"></div>
                    <div class="msg_icon correct">Are you sure to delete this?</div>
                    <div class="msg"><a href="javascript:void(0)" class="delete_pb_item"><span>Yes</span></a><a href="javascript:void(0)" class="no_pb_item"><span>No</span></a></div>

                </div>            
            </div>
            '.$templates.'
            <div class="cb_preview size_col_3_1">
                <div id="contentbuildersidebar" class="item_statement"></div>
                <div style="clear: both;"></div>
            </div>
            <div class="cb_preview size_col_3_2">
                <div id="contentbuilder" class="item_statement"></div>
                <div style="clear: both;"></div>
            </div>
        </div>';
}

// Save fields data
add_action('save_post', 'pagebuilder_section_box_save_postdata');

function pagebuilder_section_box_save_postdata($post_id) {

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return $post_id;

    if (isset($_GET['post_type']) && 'page' == $_GET['post_type']) {
        if (!current_user_can('edit_page', $post_id))
            return $post_id;
    }
    else {
        if (!current_user_can('edit_post', $post_id))
            return $post_id;
    }

    if (isset($_POST['pagebuilder'])) {

        $field_name = array();

        $field_name[] = 'cb_textarea';
        $field_name[] = 'cb_html_textarea';
        $field_name[] = 'cb_sidebar_textarea';
        $field_name[] = 'cb_sidebar_html_textarea';

        for ($i = 0; $i < count($field_name); $i++) {

            $data_field = '_' . $field_name[$i];
            $data_value = $_POST[$field_name[$i]];

            if (count(get_post_meta($post_id, $data_field)) == 0) {
                add_post_meta($post_id, $data_field, $data_value, true);
            } elseif ($data_value != get_post_meta($post_id, $data_field, true)) {
                update_post_meta($post_id, $data_field, $data_value);
            } elseif ($data_value == "") {
                delete_post_meta($post_id, $data_field, get_post_meta($post_id, $data_field, true));
            }
        }
    }
}

// Template Ajax Action
if (!function_exists('tt_template_export') && is_user_logged_in()){
    function tt_template_export() {
        $response='';
        if($templates_array=get_option('tt_pb_templates')){
            $response .= '<div class="succes">'.__('Succesfully inserted template','themeton').'</div>';
            $response .= '<div class="data">';
                $response .= serialize($templates_array);
            $response .= '</div>';
        }else{
            $response .= '<div class="error">'.__('Template not exsist','themeton').'</div>';
        }    
        die('<div class="response">'.$response.'</div>');
    }
    add_action('wp_ajax_template_export', 'tt_template_export');
}
if (!function_exists('tt_template_import') && is_user_logged_in()){
    function tt_template_import() {
        $response='';
        if(!empty($_REQUEST['data'])){
            $templates_array=unserialize(stripslashes($_REQUEST['data']));
            update_option('tt_pb_templates',$templates_array);
            $response .= '<div class="succes">'.__('Template imported','themeton').'</div>';
        }else{
            $response .= '<div class="error">'.__('Template Field is empty','themeton').'</div>';
        }    
        die('<div class="response">'.$response.'</div>');
    }
    add_action('wp_ajax_template_import', 'tt_template_import');
}

if (!function_exists('tt_template_add') && is_user_logged_in()){
    function tt_template_add() {
        if(isset($_REQUEST['template_name'])&&isset($_REQUEST['template_layout'])&&isset($_REQUEST['template_content'])&&isset($_REQUEST['template_sidebar'])){
            $response='';
            $templates_array=get_option('tt_pb_templates');

            if(isset($templates_array[$_REQUEST['template_name']])){
                $response .= '<div class="error">'.__('Template name is allready exist. Please insert the template name and try again','themeton').'</div>';
            }else{
                $templates_array[$_REQUEST['template_name']]=array(
                    'page_layout'           => $_REQUEST['template_layout'],
                    'contentbuilder'        => $_REQUEST['template_content'],
                    'contentbuildersidebar' => $_REQUEST['template_sidebar']
                );
                update_option('tt_pb_templates',$templates_array);
                $response .= '<div class="succes">'.__('Template added','themeton').'</div>';
            }
            die('<div class="response">'.$response.'</div>');
        }
    }
    add_action('wp_ajax_template_add', 'tt_template_add');
}

if (!function_exists('tt_template_get') && is_user_logged_in()){
    function tt_template_get() {
        if(isset($_REQUEST['template_name'])){
            $response='';
            $templates_array=get_option('tt_pb_templates');
            if(isset($templates_array[$_REQUEST['template_name']])){
                $template  = $templates_array[$_REQUEST['template_name']];
                $response .= '<div class="data">';
                    $response .= '<div class="page_layout"          >'.$template['page_layout']                        .'</div>';
                    $response .= '<div class="contentbuilder"       >'.rawUrlDecode($template['contentbuilder'])       .'</div>';
                    $response .= '<div class="contentbuildersidebar">'.rawUrlDecode($template['contentbuildersidebar']).'</div>';
                $response .= '</div>';
            }else{
                $response .= '<div class="error">'.__('Template name not exsist','themeton').'</div>';
            }    
            die('<div class="response">'.$response.'</div>');
        }
    }
    add_action('wp_ajax_template_get', 'tt_template_get');
}
if (!function_exists('tt_template_remove') && is_user_logged_in()){
    function tt_template_remove() {
        if(isset($_REQUEST['template_name'])){
            $response='';
            $templates_array = get_option('tt_pb_templates');
            if(isset($templates_array[$_REQUEST['template_name']])){
                unset($templates_array[$_REQUEST['template_name']]);
                update_option('tt_pb_templates',$templates_array);
            }else{
                $response .= '<div class="error">'.__('Template name not exsist','themeton').'</div>';
            }
            die('<div class="response">'.$response.'</div>');
        }
    }
    add_action('wp_ajax_template_remove', 'tt_template_remove');
}