(function() {
    tinymce.PluginManager.requireLangPack('domashortcodegenerator');
    tinymce.create('tinymce.plugins.domashortcodegenerator', {
        init : function(ed, url) {
            ed.addCommand('domashortcodegenerator', function() {
                jQuery( "<div id='shortcode_container_dialog' />").dialog({
                    title: 'Select the Shortcode',
                    resizable: true,
                    width: 800,
                    height: 500,
                    modal: true,
                    open: function(){
                        window["func_shortcode_init"](jQuery(this));
                        modalCombo2();
                        initShortcodeEvents();
                    },
                    close: function(){
                        jQuery('body #shortcode_container_dialog').closest('.ui-dialog').remove();
                        jQuery('body #shortcode_container_dialog').remove();
                    },
                    buttons: {
                        "Done": function() {
                            window["insertShortcode"](jQuery(this));
                            jQuery(this).dialog("close");
                        },
                        "Cancel": function() {
                            jQuery(this).dialog("close");
                        }
                    }
                });
            });
            ed.addButton('domashortcodegenerator', {
                title : 'Themeton Shortcode Generator',
                cmd : 'domashortcodegenerator',
                image : url + '/../images/iconsmall.png'
            })
        },
        createControl : function(n, cm) {
            return null;
        },
        getInfo : function() {
            return {
                longname : "Shortcode",
                author : '',
                authorurl : '',
                infourl : '',
                version : "1.0"
            };
        }
    });
    tinymce.PluginManager.add('domashortcodegenerator', tinymce.plugins.domashortcodegenerator);
})();

/*This is Sortable JS*/
function modalCombo2(){
    var cmbo = setInterval(function() {
        if(jQuery('#shortcode_container_dialog .add_item_medium').hasClass('add_item_medium')||jQuery('#shortcode_container_dialog .add_item').hasClass('add_item')){
            // Change the style of <select>
            if (!jQuery.browser.opera) {
                jQuery('#shortcode_container_dialog .add_item select, .ui-dialog .add_item_medium select').each(function(){
                    var title = jQuery(this).attr('title');
                    if( jQuery('option:selected', this).val() != ''  ) title = jQuery('option:selected',this).text();
                    jQuery(this).css({
                        'z-index':9999,
                        'opacity':0,
                        '-khtml-appearance':'none'
                    });
                    jQuery(this).siblings('span').remove();
                    jQuery(this).after('<span rel="checkbox">' + title + '</span>');
                    jQuery(this).change(function(){
                        val = jQuery('option:selected',this).text();
                        jQuery(this).next().text(val);
                    })
                });
            }
            clearInterval(cmbo);
        }
    }, 100);
}