<?php

if (!defined('THEMENAME'))
    define('THEMENAME', 'gravity');
if (!defined('TT_THEMENAME'))
    define('TT_THEMENAME', 'Gravity');

$settings_url = '/framework/';

if (!function_exists('file_require')) {

    function file_require($file, $uri = false) {
        if (is_child_theme()) {
            if (!$uri) {
                $dir = get_template_directory();
                $replace = get_stylesheet_directory();
                $file_exist = str_replace($dir, $replace, $file);
            } else {
                $dir = get_template_directory_uri();
                $replace = get_stylesheet_directory_uri();
                $file_exist = str_replace(get_template_directory_uri(), get_stylesheet_directory(), $file);
            }

            if (file_exists($file_exist)) {
                $file_child = str_replace($dir, $replace, $file);
                return $file_child;
            } else {
                return $file;
            }
        } else {
            return $file;
        }
    }

}

require_once file_require(get_template_directory() . "/framework/settings/init.php");
require_once file_require(get_template_directory() . "/framework/aq_resizer.php");
require_once file_require(get_template_directory() . "/framework/breadcrumbs.php");
require_once file_require(get_template_directory() . "/framework/inc_content.php");
require_once file_require(get_template_directory() . "/framework/post-type/init.php");
require_once file_require(get_template_directory() . "/framework/post-format/init.php");
require_once file_require(get_template_directory() . "/framework/pagebuilder/init.php");
require_once file_require(get_template_directory() . "/framework/widget/recent_posts_widget.php");
require_once file_require(get_template_directory() . "/framework/widget/flickr_widget.php");
require_once file_require(get_template_directory() . "/framework/widget/social_links_widget.php");
if (is_admin()) {
    require_once file_require(get_template_directory() . "/framework/shortcode/init.php");
} else {
    require_once file_require(get_template_directory() . "/framework/shortcode/shortcodes.php");
}








/* * *********************** */
/* Include Plugins */
/* * *********************** */

require_once get_template_directory() . "/framework/plugins/install-plugin.php";
require_once get_template_directory() . "/framework/plugins/twitter-plugin.php";








/* * *********************** */
/* Register menu */
/* * *********************** */

register_nav_menus(array(
    'primary' => __('Primary Navigation', 'themeton'),
    'footer-menu' => __('Footer Navigation', 'themeton')
));









/* * *********************** */
/* Theme Supports */
/* * *********************** */
add_action('after_setup_theme', 'themeton_setup');
if (!function_exists('themeton_setup')) {
    function themeton_setup() {
        add_editor_style();
        add_theme_support('post-thumbnails');
        add_theme_support('automatic-feed-links');
        load_theme_textdomain('themeton', get_template_directory() . '/framework/languages/');
    }
}
if ( ! isset( $content_width ) ) $content_width = 772;










/* * *********************** */
/* Register Widget Sidebar */
/* * *********************** */
if(!function_exists('theme_widgets_init')){
    function theme_widgets_init() {

        register_sidebar(array(
            'name' => 'Default sidebar',
            'id' => 'default-sidebar',
            'before_widget' => '<aside class="widget" id="%1$s">',
            'after_widget' => '</aside>',
            'before_title' => '<h3 class="widget-title">',
            'after_title' => '<span class="tt-element-title-border"></span></h3>',
        ));

        if (!get_settings_value('top_layout')) {
            register_sidebar(array(
                'name' => 'Top sidebar',
                'id' => 'top-sidebar',
                'before_widget' => '<aside class="widget" id="%1$s">',
                'after_widget' => '</aside>',
                'before_title' => '<h3 class="widget-title">',
                'after_title' => '<span class="tt-element-title-border"></span></h3>',
            ));
        }


        /* footer sidebar */
        $grid = get_settings_value('footer_layout') != "" ? get_settings_value('footer_layout') : '3-3-3-3';
        $i = 1;
        foreach (split('-', $grid) as $g) {
            register_sidebar(array(
                'name' => __("Footer sidebar ", "themeton") . $i,
                'id' => "footer-sidebar-$i",
                'description' => __('The footer sidebar widget area', 'themeton'),
                'before_widget' => '<aside class="widget" id="%1$s">',
                'after_widget' => '</aside>',
                'before_title' => '<h3 class="widget-title">',
                'after_title' => '<span class="tt-element-title-border"></span></h3>',
            ));
            $i++;
        }

        /* custom sidebar */
        $sidebars = get_option('theme_' . THEMENAME . '_sidebar');
        if (!empty($sidebars)) {
            foreach ($sidebars as $sidebar) {
                register_sidebar(array(
                    'name' => "$sidebar",
                    'id' => "$sidebar",
                    'description' => __('The dynamic sidebar widget area', 'themeton'),
                    'before_widget' => '<aside class="widget" id="%1$s">',
                    'after_widget' => '</aside>',
                    'before_title' => '<h3 class="widget-title">',
                    'after_title' => '<span class="tt-element-title-border"></span></h3>',
                ));
            }
        }
    }
}
add_action('widgets_init', 'theme_widgets_init');
add_filter('widget_text', 'do_shortcode');











/* * *********************** */
/* Custom Login Logo */
/* * *********************** */

if (get_settings_value("login_logo") != "") {

    function custom_login_logo() {
        echo '<style type="text/css">
            h1 a { background-image: url(' . get_settings_value("login_logo") . ') !important; }
            </style>';
    }

    add_action('login_head', 'custom_login_logo');
}











/* * *********************** */
/* Has more in post */
/* * *********************** */

function has_more() {
    global $post;
    if (empty($post))
        return;
    return (bool) preg_match('/<!--more(.*?)?-->/', $post->post_content);
}

/* * *********************** */
/* Exclude pages from search */
/* * *********************** */
if (!function_exists('exclude_pages_from_search')) :

    function exclude_pages_from_search($query) {
        if ($query->is_search) {
            $query->set('post_type', 'post');
        }
        return $query;
    }

    add_filter('pre_get_posts', 'exclude_pages_from_search');
endif;












/* * *********************** */
/* Support upload .ico file */
/* * *********************** */

if (!function_exists('custom_upload_mimes')) {
    add_filter('upload_mimes', 'custom_upload_mimes');

    function custom_upload_mimes($existing_mimes = array()) {
        $existing_mimes['ico'] = "image/x-icon";
        return $existing_mimes;
    }

}










/* * *********************** */
/* Get youtube vimeo embed from URL */
/* * *********************** */

function get_youtube_vimeo_embed_from_url($url, $return = 'embed', $width = '', $height = '', $rel = 0) {
    $urls = parse_url($url);
    if ((isset($urls['host']) && isset($urls['path']) && isset($urls['query'])) && (str_replace(array('www.', 'WWW.'), '', $urls['host']) == 'youtu.be' || str_replace(array('www.', 'WWW.'), '', $urls['host']) == 'youtube.com')) {
        if ($urls['host'] == 'youtu.be') {
            $id = ltrim($urls['path'], '/');
        } elseif (strpos($urls['path'], 'embed') == 1) {
            $id = end(explode('/', $urls['path']));
        } elseif (strpos($url, '/') === false) {
            $id = $url;
        } else {
            parse_str($urls['query']);
            $id = $v;
            if (!empty($feature)) {
                $id = end(explode('v=', $urls['query']));
            }
        }
        //return embed iframe
        if ($return == 'embed') {
            return '<iframe src="http://www.youtube.com/embed/' . $id . '?rel=' . $rel . '" frameborder="0" width="' . ($width ? $width : '100%') . '" height="' . ($height ? $height : 'auto') . '"></iframe>';
        } elseif ($return == 'thumb') {
            return 'http://i1.ytimg.com/vi/' . $id . '/default.jpg';
        } elseif ($return == 'hqthumb') {
            return 'http://i1.ytimg.com/vi/' . $id . '/hqdefault.jpg';
        } else {
            return $id;
        }
    } elseif (isset($urls['host']) && str_replace(array('www.', 'WWW.'), '', $urls['host']) == 'vimeo.com') {
        if (preg_match('~^http://(?:www\.)?vimeo\.com/(?:clip:)?(\d+)~', $url, $match)) {
            $id = $match[1];
        } else {
            $id = substr($link, 10, strlen($link));
        }
        return '<iframe src="http://player.vimeo.com/video/' . $id . '?title=0&amp;byline=0&amp;portrait=0&amp;color=ffffff" width="' . ($width ? $width : '100%') . '" height="' . ($height ? $height : 'auto') . '" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>';
    }
    return __('Error URL !!!', 'themeton');
}

/* Themeton Admin Head hook for IE */

function themeton_meta_tag() {
    echo "<!--[if IE]>
    <link href='http://fonts.googleapis.com/css?family=Open+Sans:400'  rel='stylesheet' type='text/css'> 
<link href = 'http://fonts.googleapis.com/css?family=Open+Sans:700'  rel='stylesheet' type='text/css'>
<link href = 'http://fonts.googleapis.com/css?family=Open+Sans:800'  rel='stylesheet' type='text/css'>
<![endif]-->";
}

add_action('admin_enqueue_scripts', 'themeton_meta_tag', 100);













function my_search_form( ) {

    $form = '<form role="search" method="get" id="searchform" action="' . home_url( '/' ) . '" >
    <div class="clearfix">
    <input type="submit" id="searchsubmit" value="'. esc_attr__('Search') .'" />
    <input type="text" value="' . get_search_query() . '" name="s" id="s" placeholder="' . __('Enter search keyword ...', 'themeton') . '" />    
    </div>
    </form>';

    return $form;
}





/* * *********************** */
/* IE */
/* * *********************** */

function my_render_css3_pie() {
    echo '
<!--[if lte IE 7]> <html class="ie7"> <![endif]-->
<!--[if IE 8]>     <html class="ie8"> <![endif]-->
<!--[if lte IE 8]><style type="text/css" media="screen">
.image-overlay{background:transparent;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr=#50000000,endColorstr=#50000000);zoom: 1;}
</style><![endif]-->
';
}

add_action('wp_head', 'my_render_css3_pie', 8);
?>