<?php

global $options;
// Social Array
$socialOptions = array();
foreach (getArraySocial() as $social) {
    $lnk = get_settings_value('social_'.$social['name']);
    $lnk = $lnk=='' ? $social['link'] : str_replace('*', $lnk, $social['link']);
    $socialOptions[]=array(
        "name" => $social['name']."_on",
        "desc" => $lnk,
        "opt"  => ucfirst($social['name']),
        "temp" => true,
        "type" => "check",
        "std" => "",
    );
    $socialOptions[]=array(
        "name" => $social['name'],
        "desc" => "",
        "type" => "hidden",
        "std" => get_settings_value('social_'.$social['name'])
    );
}
//Testimonials category
$terms = get_terms('testimonials');
$testimonialsCat = array();
$testimonialsCat['0'] = __('Select Category', 'themeton');
foreach ($terms as $term) {
    $testimonialsCat[$term->slug] = $term->name;
}
//Pricing category
$terms = get_terms('prices');
$pricingCat = array();
$pricingCat['0'] = __('Select Category', 'themeton');
foreach ($terms as $term) {
    $pricingCat[$term->slug] = $term->name;
}
//Portfoliot category
$terms = get_terms("portfolios", 'hide_empty=0');
$portfolioCat = array();
$portfolioCat['0'] = __('All Category', 'themeton');
foreach ($terms as $term) {
    $portfolioCat[$term->slug] = $term->name;
}
//Position category
$terms = get_terms("position", 'hide_empty=0');
$positionCat = array();
$positionCat['0'] = __('All Category', 'themeton');
foreach ($terms as $term) {
    $positionCat[$term->slug] = $term->name;
}
//Blog category
$categories = get_categories("hide_empty=0");
$blogCategories = array();
$blogCategories['0'] = __('Select Category', 'themeton');
foreach ($categories as $category) {
    $blogCategories[$category->slug] = $category->name;
}

// Shortcode Options Menu
$options = array(
    // Accordion
    array(
        "name" => "Accordion",
        "slug" => "accordion",
        "togglable" => "true",
        "options" => array(
            array(
                "name" => "expand",
                "desc" => "",
                "opt" => 'expand',
                "type" => "check",
                "std" => "",
            ),
            array(
                "name" => "title",
                "desc" => "",
                "type" => "input",
                "std" => "Title here",
            ),
            array(
                "name" => "text",
                "desc" => "",
                "type" => "textarea",
                "cont" => true,
                "std" => "Text here",
            )
        ),
    ),
    // Blog
    array(
        "name" => "Blog",
        "slug" => "blog",
        "options" => array(
            array(
                "name" => "cat",
                "desc" => "Choose the post category you want to include the blog post.",
                "type" => "select",
                "temp" => true,
                "opt" => $blogCategories,
                "std" => '0'
            ),
            array(
                "name" => "category",
                "desc" => "",
                "type" => "hidden",
                "std" => ''
            ),
            array(
                "name" => "block",
                "desc" => "Blog displaying style.",
                "type" => "select",
                "opt" => array('1' => 'Block 1', '2' => 'Block 2', '3' => 'Block 3', '4' => 'Block 4'),
                "std" => '1'
            ),
            array(
                "name" => "count",
                "desc" => "How many posts will it display.",
                "type" => "input",
                "std" => "10",
            ),
            array(
                "name" => "pagination",
                "desc" => "If Yes your blog displaying with PAGINATION.",
                "type" => "select",
                "opt" => array('true' => 'Yes', 'false' => 'No'),
                "std" => 'true'
            ),
            array(
                "name" => "excerpt",
                "desc" => "Inserted words can break blog posts. Empty, 0 or number value allowed.",
                "type" => "input",
                "std" => "50",
            ),
            array(
                "name" => "read_more",
                "desc" => "Read more text",
                "type" => "input",
                "std" => "Read more",
            )
        ),
    ),
    // Button
    array(
        "name" => "Button",
        "slug" => "buttons",
        "options" => array(
            array(
                "name" => "type",
                "desc" => "Choose button color",
                "type" => "select",
                "opt" => array('default' => 'Default', 'red' => 'Red', 'orange' => 'Orange', 'blue' => 'Blue', 'green' => 'Green', 'pink' => 'Pink', 'magenta' => 'Magenta', 'yellow' => 'Yellow'),
                "std" => 'Default'
            ),
            array(
                "name" => "size",
                "desc" => "Choose button size",
                "type" => "select",
                "opt" => array('small' => 'Small', 'medium' => 'Medium', 'large' => 'Large'),
                "std" => 'Small'
            ),
            array(
                "name" => "rounded",
                "desc" => "Is button Rounded?",
                "type" => "select",
                "opt" => array('yes' => 'Yes', 'no' => 'No'),
                "std" => 'no'
            ),
            array(
                "name" => "style",
                "desc" => "Choose button Style.",
                "type" => "select",
                "opt" => array('flat' => 'Flat', 'gradient' => 'Gradient'),
                "std" => 'flat'
            ),
            array(
                "name" => "link",
                "desc" => "Link here",
                "type" => "input",
                "std" => "#",
            ),
            array(
                "name" => "target",
                "desc" => "Choose target",
                "type" => "select",
                "opt" => array('blank' => 'blank', 'self' => 'self', 'parent' => 'parent', 'top' => 'top'),
                "std" => 'blank'
            ),
            array(
                "name" => "text",
                "desc" => "",
                "type" => "input",
                "cont" => true,
                "std" => "Button text here",
            ),
        ),
    ),
    // Carousel
    array(
        "name" => "Carousel",
        "slug" => "carousel",
        "options" => array(
            array(
                "name" => "post_type",
                "desc" => "",
                "type" => "select",
                "opt" => array('post' => 'Post', 'portfolio' => 'Portfolio'),
                "std" => 'post'
            ),
            array(
                "name" => "post_cat",
                "desc" => "Choose the post category you want to include the blog post. You can select one or multiple category here.",
                "type" => "select",
                "temp" => true,
                "opt" => $blogCategories,
                "std" => '0'
            ),
            array(
                "name" => "post_category",
                "desc" => "",
                "type" => "hidden",
                "std" => ''
            ),
            array(
                "name" => "portfolio_cat",
                "desc" => "Choose the portfolio category you want to include the portfolio post. You can select one or multiple category here.",
                "type" => "select",
                "temp" => true,
                "opt" => $portfolioCat,
                "std" => '0'
            ),
            array(
                "name" => "portfolio_category",
                "desc" => "",
                "type" => "hidden",
                "std" => ''
            ),
            array(
                "name" => "count",
                "desc" => "How many posts will it display.",
                "type" => "input",
                "std" => "10",
            ),
            array(
                "name" => "height",
                "desc" => "By pixels",
                "type" => "input",
                "std" => "150",
            ),
            array(
                "name" => "post_content",
                "desc" => "Empty, 0 or number value allowed. If you leave it empty, element prints posts' excerpt.",
                "type" => "input",
                "std" => "5",
            )
        ),
    ),
    // Column
    array(
        "name" => "Column",
        "slug" => "column",
        "options" => array(
            array(
                "name" => "column_type",
                "desc" => "Choose the column shortcode",
                "type" => "select",
                "opt" => array(
                    "2 columns" => "2 columns",
                    "3 columns" => "3 columns",
                    "4 columns" => "4 columns",
                    "5 columns" => "5 columns",
                    "6 columns" => "6 columns",
                    "1/2" => "1/2",
                    "1/3" => "1/3",
                    "2/3" => "2/3",
                    "1/4" => "1/4",
                    "3/4" => "3/4",
                    "1/5" => "1/5",
                    "2/5" => "2/5",
                    "1/6" => "1/6",
                    "5/6" => "5/6"
                ),
                "std" => '2 columns'
            ),
            array(
                "name" => "last",
                "desc" => "Is this last column?",
                "type" => "select",
                "opt" => array("false" => "No", "true" => "Yes"),
                "temp" => true,
                "std" => 'false'
            )
        ),
    ),
    // Divider
    array(
        "name" => "Divider",
        "slug" => "divider",
        "options" => array(
            array(
                "name" => "type",
                "desc" => "Choose Divider type",
                "type" => "select",
                "opt" => array('line' => 'Line', 'space' => 'Space'),
                "std" => 'line'
            ),
            array(
                "name" => "height",
                "desc" => "Height value by pixels.",
                "type" => "input",
                "std" => "20",
            )
        ),
    ),
    //Dropcap
    array(
        "name" => "Dropcap",
        "slug" => "dropcap",
        "options" => array(
            array(
                "name" => "type",
                "desc" => "Choose type",
                "type" => "select",
                "opt" => array('normal' => 'Normal', 'circle' => 'Circle', 'square' => 'Square', 'roman' => 'Roman'),
                "std" => 'circle'
            ),
            array(
                "name" => "text",
                "desc" => "Dropcap Text here",
                "type" => "input",
                "std" => "",
            ),
            array(
                "name" => "text_color",
                "desc" => "Choose text color",
                "type" => "color",
                "std" => "#ffffff",
            ),
            array(
                "name" => "bg_color",
                "desc" => "Choose background color",
                "type" => "color",
                "std" => "#000000",
            ),
        ),
    ),
    // Image Slider
    // List
    array(
        "name" => "List",
        "slug" => "list",
        "togglable" => "true",
        "options" => array(
            array(
                "name" => "title",
                "desc" => '<a href="' . get_template_directory_uri() . '/resources/design.html" target="_blank" title="243 Icons list">243 Service icons</a>. Put here proper icon name.',
                "type" => "input",
                "std"  => "Icon code here",
            ),
            array(
                "name" => "text",
                "desc" => "",
                "type" => "input",
                "cont" => true,
                "std"  => "Text here",
            )
        ),
    ),
    //Message box
    array(
        "name" => "Message box",
        "slug" => "message_box",
        "options" => array(
            array(
                "name" => "type",
                "desc" => "Choose Message box type",
                "type" => "select",
                "opt" => array('Default' => 'Default', 'Alert' => 'Alert', 'Info' => 'Info', 'Success' => 'Success', 'Error' => 'Error'),
                "std" => 'Default'
            ),
            array(
                "name" => "title",
                "desc" => "",
                "type" => "input",
                "std" => "Message box title here",
            ),
            array(
                "name" => "text",
                "desc" => "",
                "type" => "textarea",
                "cont" => true,
                "std" => "Message box text here",
            )
        ),
    ),
    // Portfolio
    array(
        "name" => "Portfolio",
        "slug" => "portfolio",
        "options" => array(
            array(
                "name" => "cat",
                "desc" => "Choose Portfolio Categories.",
                "type" => "select",
                "temp" => true,
                "opt" => $portfolioCat,
                "std" => '0'
            ),
            array(
                "name" => "category",
                "desc" => "",
                "type" => "hidden",
                "std" => ''
            ),
            array(
                "name" => "column",
                "desc" => "How many columns display your portfolio?",
                "type" => "select",
                "opt" => array('2' => '2 Columns', '3' => '3 Columns', '4' => '4 Columns'),
                "std" => '4'
            ),
            array(
                "name" => "count",
                "desc" => "How many portfolio will display?",
                "type" => "input",
                "std" => "10",
            ),
            array(
                "name" => "image_height",
                "desc" => "Image height : If you leave this option empty this is configured by Theme option!",
                "type" => "input",
                "std" => "",
            ),
            array(
                "name" => "filter",
                "desc" => "Filters by category",
                "type" => "select",
                "opt" => array('true' => 'Yes', 'false' => 'No'),
                "std" => 'true'
            ),
            array(
                "name" => "pagination",
                "desc" => "If Yes your blog displaying with PAGINATION.",
                "type" => "select",
                "opt" => array('true' => 'Yes', 'false' => 'No'),
                "std" => 'true'
            ),
        ),
    ),
    // Label
    array(
        "name" => "Label",
        "slug" => "label",
        "options" => array(
            array(
                "name" => "type",
                "desc" => "Choose Label color",
                "type" => "select",
                "opt" => array('default' => 'Default', 'red' => 'Red', 'orange' => 'Orange', 'blue' => 'Blue', 'green' => 'Green', 'pink' => 'Pink', 'magenta' => 'Magenta', 'yellow' => 'Yellow'),
                "std" => 'default'
            ),
            array(
                "name" => "style",
                "desc" => "Choose Style. Flat has no shadow and gradient.",
                "type" => "select",
                "opt" => array('flat' => 'Flat', 'gradient' => 'Gradient'),
                "std" => 'flat'
            ),
            array(
                "name" => "label_text",
                "desc" => "",
                "type" => "input",
                "cont" => true,
                "std" => "Enter the Label Text",
            ),
        ),
    ),
    // Pricing table
    array(
        "name" => "Pricing table",
        "slug" => "pricing_table",
        "options" => array(
            array(
                "name" => "cat",
                "desc" => "Choose category",
                "type" => "select",
                "temp" => true,
                "opt" => $pricingCat,
                "std" => '0'
            ),
            array(
                "name" => "category",
                "desc" => "",
                "type" => "hidden",
                "std" => ''
            ),
            array(
                "name" => "column",
                "desc" => "Choose column",
                "type" => "select",
                "opt" => array('2' => '2 columns', '3' => '3 columns', '4' => '4 columns', '5' => '5 columns'),
                "std" => '2'
            ),
        ),
    ),
    // Progressbar
    array(
        "name" => "Progress bar",
        "slug" => "progress_bar",
        "options" => array(
            array(
                "name" => "title",
                "desc" => "Insert the Progress Bar Title",
                "type" => "input",
                "std" => "Title here",
            ),
            array(
                "name" => "size",
                "desc" => "Progress Bar Size",
                "type" => "input",
                "std" => "100",
            ),
            array(
                "name" => "animated",
                "desc" => "Is Animated?",
                "opt" => 'Animated',
                "type" => "check",
                "std" => "checked",
            ),
            array(
                "name" => "color",
                "desc" => "",
                "type" => "color",
                "std" => "#690",
            ),
        ),
    ),
    // Slider
    
    // Tab
    array(
        "name" => "Tab",
        "slug" => "tab",
        "togglable" => "true",
        "options" => array(
            array(
                "name" => "title",
                "desc" => "",
                "type" => "input",
                "std" => "Title here",
            ),
            array(
                "name" => "text",
                "desc" => "",
                "type" => "textarea",
                "cont" => true,
                "std" => "Text here",
            )
        ),
    ),
    // Team
    array(
        "name" => "Team",
        "slug" => "team",
        "options" => array(
            array(
                "name" => "cat",
                "desc" => "Choose category",
                "type" => "select",
                "temp" => true,
                "opt" => $positionCat,
                "std" => '0'
            ),
            array(
                "name" => "category",
                "desc" => "",
                "type" => "hidden",
                "std" => ''
            ),
            array(
                "name" => "height",
                "desc" => "By pixels",
                "type" => "input",
                "std" => "100",
            ),
            array(
                "name" => "count",
                "desc" => "Count",
                "type" => "input",
                "std" => "5",
            ),
            array(
                "name" => "column",
                "desc" => "Choose column",
                "type" => "select",
                "opt" => array('2' => '2 columns', '3' => '3 columns', '4' => '4 columns', '5' => '5 columns'),
                "std" => '2'
            ),
        ),
    ),
    // Twitter
    array(
        "name" => "Twitter",
        "slug" => "twitter",
        "options" => array(
            array(
                "name" => "title",
                "desc" => "",
                "type" => "input",
                "std" => "Title here",
            ),
            array(
                "name" => "user_name",
                "desc" => "",
                "type" => "input",
                "std" => "Twitter user name here",
            ),
            array(
                "name" => "count",
                "desc" => "",
                "type" => "input",
                "std" => "5",
            ),
        ),
    ),
    // Testimonials
    array(
        "name" => "Testimonials",
        "slug" => "testimonials",
        "options" => array(
            array(
                "name" => "cat",
                "desc" => "Choose category",
                "type" => "select",
                "temp" => true,
                "opt" => $testimonialsCat,
                "std" => '0'
            ),
            array(
                "name" => "category",
                "desc" => "",
                "type" => "hidden",
                "std" => ''
            ),
            array(
                "name" => "count",
                "desc" => "How many testimonials do you wanna display?",
                "type" => "input",
                "std" => "5",
            ),
        ),
    ),
    // Toggle
    array(
        "name" => "Toggle",
        "slug" => "toggle",
        "togglable" => "true",
        "options" => array(
            array(
                "name" => "expand",
                "desc" => "",
                "opt" => 'expand',
                "type" => "check",
                "std" => "",
            ),
            array(
                "name" => "title",
                "desc" => "",
                "type" => "input",
                "std" => "Title here",
            ),
            array(
                "name" => "text",
                "desc" => "",
                "type" => "textarea",
                "cont" => true,
                "std" => "Text here",
            )
        ),
    ),
    // Video
    array(
        "name" => "Video",
        "slug" => "video",
        "options" => array(
            array(
                "name" => "url",
                "desc" => "Video URL",
                "type" => "input",
                "std" => "Video URL here",
            ),
            array(
                "name" => "height",
                "desc" => "Video height size.",
                "type" => "input",
                "std" => "250",
            ),
        ),
    ),
);

// Social button
$options[] = array(
        "name" => "Social button",
        "slug" => "social_button",
        "options" => $socialOptions
);

// Shortcode Container
if (!function_exists('get_shortcode_container')) {

    function get_shortcode_container($content) {
        return $content;
    }

}
// Divider Shortcode
if (!function_exists('shortcode_divider')) {
    function shortcode_divider($atts, $content) {
        if ($atts['type'] != "space")
            $output = '<div class="tt-divider clear"></div>';
        else
            $output = '<div class="tt-shortcode-space" style="margin-top: ' . str_replace('px', '', $atts['height']) . 'px;"></div>';
        return get_shortcode_container($output);
    }

}
// Message box Shortcode
if (!function_exists('shortcode_message_box')) {
    function shortcode_message_box($atts, $content) {
        $output = '<div class="tt-blocks ' . strtolower($atts['type']) . '">'.(empty($atts['title'])?'':('<h4>' . $atts['title'] . '</h4>') ). do_shortcode($content) . '</div>';
        return get_shortcode_container($output);
    }

}
// Button Shortcode
if (!function_exists('shortcode_buttons')) {
    function shortcode_buttons($atts, $content) {
        $class = 'tt-button';
        switch ($atts['type']) {
            case'default': {
                    break;
                }
            case'red': {
                    $class .= ' red';
                    break;
                }
            case'orange' : {
                    $class .= ' orange';
                    break;
                }
            case'blue': {
                    $class .= ' blue';
                    break;
                }
            case'green' : {
                    $class .= ' green';
                    break;
                }
            case'pink': {
                    $class .= ' pink';
                    break;
                }
            case'magenta' : {
                    $class .= ' magenta';
                    break;
                }
            case'yellow' : {
                    $class .= ' yellow';
                    break;
                }
        }
        switch ($atts['size']) {
            case'small' : {
                    $class .= ' small';
                    break;
                }
            case'medium': {
                    $class .= ' medium';
                    break;
                }
            case'large' : {
                    $class .= ' large';
                    break;
                }
        }
        switch ($atts['style']) {
            case'flat': {
                    $class .= ' flat';
                    break;
                }
            case'gradient': {
                    break;
                }
        }
        switch ($atts['rounded']) {
            case'yes': {
                    $class .= ' rounded';
                    break;
                }
            case'no': {
                    break;
                }
        }
        $output = '<a href="' . $atts['link'] . '" target="_' . $atts['target'] . '" class="' . $class . '">' . do_shortcode($content) . '</a>';
        return get_shortcode_container($output);
    }

}
// Label Shortcode
if (!function_exists('shortcode_label')) {

    function shortcode_label($atts, $content) {
        $class = 'tt-label';
        switch ($atts['type']) {
            case'default': {
                    break;
                }
            case'red': {
                    $class .= ' red';
                    break;
                }
            case'orange' : {
                    $class .= ' orange';
                    break;
                }
            case'blue': {
                    $class .= ' blue';
                    break;
                }
            case'green' : {
                    $class .= ' green';
                    break;
                }
            case'pink': {
                    $class .= ' pink';
                    break;
                }
            case'magenta' : {
                    $class .= ' magenta';
                    break;
                }
            case'yellow' : {
                    $class .= ' yellow';
                    break;
                }
        }
        switch ($atts['style']) {
            case'flat': {
                    $class .= ' flat';
                    break;
                }
            case'gradient': {
                    break;
                }
        }
        $output = '<span class="' . $class . '">' . do_shortcode($content) . '</span>';
        return get_shortcode_container($output);
    }

}
// Column Shortcode
if (!function_exists('shortcode_one_half')) {

    function shortcode_one_half($atts, $content) {
        $output = '<div class="tt-columns-one-half' . (isset($atts['last']) && $atts['last'] == 'true' ? ' tt-columns-column-last' : '') . '">' . do_shortcode($content) . '</div>';
        return get_shortcode_container($output);
    }

}
if (!function_exists('shortcode_one_third')) {

    function shortcode_one_third($atts, $content) {
        $output = '<div class="tt-columns-one-third' . (isset($atts['last']) && $atts['last'] == 'true' ? ' tt-columns-column-last' : '') . '">' . do_shortcode($content) . '</div>';
        return get_shortcode_container($output);
    }

}
if (!function_exists('shortcode_one_fourth')) {

    function shortcode_one_fourth($atts, $content) {
        $output = '<div class="tt-columns-one-fourth' . (isset($atts['last']) && $atts['last'] == 'true' ? ' tt-columns-column-last' : '') . '">' . do_shortcode($content) . '</div>';
        return get_shortcode_container($output);
    }

}
if (!function_exists('shortcode_one_fifth')) {

    function shortcode_one_fifth($atts, $content) {
        $output = '<div class="tt-columns-one-fifth' . (isset($atts['last']) && $atts['last'] == 'true' ? ' tt-columns-column-last' : '') . '">' . do_shortcode($content) . '</div>';
        return get_shortcode_container($output);
    }

}
if (!function_exists('shortcode_one_sixth')) {

    function shortcode_one_sixth($atts, $content) {
        $output = '<div class="tt-columns-one-sixth' . (isset($atts['last']) && $atts['last'] == 'true' ? ' tt-columns-column-last' : '') . '">' . do_shortcode($content) . '</div>';
        return get_shortcode_container($output);
    }

}
if (!function_exists('shortcode_two_third')) {

    function shortcode_two_third($atts, $content) {
        $output = '<div class="tt-columns-two-third' . (isset($atts['last']) && $atts['last'] == 'true' ? ' tt-columns-column-last' : '') . '">' . do_shortcode($content) . '</div>';
        return get_shortcode_container($output);
    }

}
if (!function_exists('shortcode_two_fifth')) {

    function shortcode_two_fifth($atts, $content) {
        $output = '<div class="tt-columns-two-fifth' . (isset($atts['last']) && $atts['last'] == 'true' ? ' tt-columns-column-last' : '') . '">' . do_shortcode($content) . '</div>';
        return get_shortcode_container($output);
    }

}
if (!function_exists('shortcode_three_fourth')) {

    function shortcode_three_fourth($atts, $content) {
        $output = '<div class="tt-columns-three-fourth' . (isset($atts['last']) && $atts['last'] == 'true' ? ' tt-columns-column-last' : '') . '">' . do_shortcode($content) . '</div>';
        return get_shortcode_container($output);
    }

}
if (!function_exists('shortcode_three_fifth')) {

    function shortcode_three_fifth($atts, $content) {
        $output = '<div class="tt-columns-three-fifth' . (isset($atts['last']) && $atts['last'] == 'true' ? ' tt-columns-column-last' : '') . '">' . do_shortcode($content) . '</div>';
        return get_shortcode_container($output);
    }

}
if (!function_exists('shortcode_four_fifth')) {

    function shortcode_four_fifth($atts, $content) {
        $output = '<div class="tt-columns-four-fifth' . (isset($atts['last']) && $atts['last'] == 'true' ? ' tt-columns-column-last' : '') . '">' . do_shortcode($content) . '</div>';
        return get_shortcode_container($output);
    }

}
if (!function_exists('shortcode_five_sixth')) {

    function shortcode_five_sixth($atts, $content) {
        $output = '<div class="tt-columns-five-sixth' . (isset($atts['last']) && $atts['last'] == 'true' ? ' tt-columns-column-last' : '') . '">' . do_shortcode($content) . '</div>';
        return get_shortcode_container($output);
    }

}
// Dropcap Shortcode
if (!function_exists('shortcode_dropcap')) {

    function shortcode_dropcap($atts, $content) {
        $output = '<span class="tt-dropcap ' . $atts['type'] . '" style="background-color:' . $atts['bg_color'] . ';color:' . $atts['text_color'] . ';">' . $atts['text'] . '</span>';
        return get_shortcode_container($output);
    }

}
// List Shortcode
if (!function_exists('shortcode_list')) {
    function shortcode_list($atts, $content) {
        $output = '<ul class="unstyled">';
        $output .= do_shortcode($content);
        $output .= '</ul>';
        return get_shortcode_container($output);
    }
}

// List item Shortcode
if (!function_exists('shortcode_list_item')) {
    function shortcode_list_item($atts, $content) {
        $output = '<li><i class="' . $atts['icon'] . '"></i>' . do_shortcode($content) . '</li>';
        return $output;
    }
}
// Social Button Shortcode
if (!function_exists('shortcode_social_button')) {
    function shortcode_social_button($atts, $content) {
        $output='<ul class="sociallinkswidget clearfix">';
        foreach (getArraySocial() as $social) {
            if(isset($atts[$social['name']])){
                $url = str_replace('*', $atts[$social['name']], $social['link']);
                $output .= '<li class="'.$social['name'].'"><a href="' . $url . '" target="_blank" title="'.$social['name'].'"></a></li>';
            }
        }
        return get_shortcode_container($output);
        $output='</ul>';
    }
}
// Twitter Shortcode
if (!function_exists('shortcode_twitter')) {

    function shortcode_twitter($atts, $content) {
        $twitter = $atts['user_name'];
        $twitter_count = $atts['count'];
        $output = '';
        if (!empty($atts['title'])) {
            $output.= '<h4>' . $atts['title'] . '</h4>';
        }
        $output .= '<div class="cb_twitter ' . $twitter . '"><b>@' . $twitter . ':</b> ' . __('Loading tweet', 'themeton') . '...</div>';

        $output .= '<script type="text/javascript">
                    try{
                        jQuery(function(){
                            url = "' . home_url() . '/wp-admin/admin-ajax.php?action=twitter_feed&screen_name=' . $twitter . '&count=' . $twitter_count . '";
                            jQuery.getJSON(url, function(data) {
                                currentClass = ".cb_twitter.' . $twitter . '";
                                if( data[0] != undefined ){
                                    jQuery(currentClass).html("");
                                    for (var i = 0, text=""; i < data.length; i++){
                                        text = data[i].text;
                                        jQuery(currentClass).append(\'<div class="twitter-item"><b>@' . $twitter . ':</b> \'+ jQuery.linkify(text)+\'</div>\');
                                    }
                                }
                            });
                        });
                    }
                    catch(error){}
                </script>';
        return get_shortcode_container($output);
    }

}
if (!function_exists('twitter_hooked_function')) {
    add_action('wp_ajax_twitter_feed', 'twitter_hooked_function');
    add_action('wp_ajax_nopriv_twitter_feed', 'twitter_hooked_function');

    function twitter_hooked_function() {
        if (isset($_GET['screen_name'])) {
            $uname = $_GET['screen_name'];
            $count = $_GET['count'];
            $url = 'http://api.twitter.com/1/statuses/user_timeline.json?include_entities=true&include_rts=true&screen_name=' . $uname . '&count=' . $count;
            $feed = file_get_contents($url);
            $valid_data = json_decode($feed);
            $data = json_encode($valid_data);
            echo $data;
        }
        exit;
    }

}

// Video Shortcode
if (!function_exists('shortcode_video')) {

    function shortcode_video($atts, $content) {
        $url = $atts['url'];
        $height = empty($atts['height']) ? '250px' : (str_replace('px', '', $atts['height']) . 'px');
        $output = '<div class="tt-video">';
        $output .= get_youtube_vimeo_embed_from_url($url, 'embed', '100%', $height);
        $output .= '</div>';

        return get_shortcode_container($output);
    }

}

// Progressbar Shortcode
if (!function_exists('shortcode_progress_bar')) {

    function shortcode_progress_bar($atts, $content) {
        $output = '<div class="tt-progressbar">
                        <div class="tt-progressbar-percent" style="width: ' . str_replace(array('px', '%', ' '), '', $atts['size']) . '%;background-color: ' . $atts['color'] . ';' . ($atts['animated'] == 'true' ? '' : 'background-image: none;') . '"></div>
                        <span class="tt-progressbar-title">' . $atts['title'] . '</span>
                    </div>';
        return get_shortcode_container($output);
    }

}

// Testimonials Shortcode
if (!function_exists('shortcode_testimonials')) {

    function shortcode_testimonials($atts, $content) {
        $cats = empty($atts['category']) ? false : explode(",", $atts['category']);
        $args = array(
            'post_type' => 'testimonial',
            'posts_per_page' => $atts['count'],
            'orderby' => 'date',
            'order' => 'ASC',
        );
        if ($cats) {
            $args['tax_query'] = Array(Array(
                'taxonomy' => 'testimonials',
                'terms' => $cats,
                'field' => 'slug'
            ));
        }
        $output = '<div class="tt-testimonials">';
            $output .= '<ul class="slides">';
                query_posts($args);
                while (have_posts()) {
                    the_post();
                    $options = get_post_meta(get_the_ID(), 'themeton_' . THEMENAME . '_options', true);
                    $output .='<li class="testiominals-item">';
                        $output .='<blockquote>';
                        $output .= get_the_content();
                        $output.='</blockquote>';
                        $output.='<div class="testimonials clearfix">';
                            $output .= post_image_show() ? ('<div class="testimonials-image">' . post_image_show() . '</div>') : "";
                            $output .='<h3 class="testimonials-name">';
                                $output .=$options['name'] . ', ';
                                $output .='<span>';
                                    $output .=$options['position'] . ', ';
                                    $options['company'] = !empty($options['link']) ? ("<a href='" . to_url($options['link']) . "'>" . $options['company'] . "</a>") : $options['company'];
                                    $output .=$options['company'];
                                $output .='</span>';
                            $output .='</h3>';
                        $output .='</div>';
                    $output .='</li>';
                }
                wp_reset_query();
            $output .= '</ul>';
            $output .= '<div class="clearfix"></div>';
            $output .= '<div class="carousel-arrow">';
                $output .= '<a class="carousel-prev" href="#"><i class="icon-angle-left"></i></a>';
                $output .= '<a class="carousel-next" href="#"><i class="icon-angle-right"></i></a>';	
            $output .='</div>';
        $output .= '</div>';
        
        return get_shortcode_container($output);
    }

}

// Pricing table Shortcode
if (!function_exists('shortcode_pricing_table')) {
    function shortcode_pricing_table($atts, $content) {
        $output = '<div class="tt-price-block clearfix">';
        $cats = empty($atts['category']) ? false : explode(",", $atts['category']);
        $args = array(
            'post_type' => 'price',
            'posts_per_page' => $atts['column'],
            'orderby' => 'date',
            'order' => 'ASC',
        );
        if($cats){
            $args['tax_query'] = Array(Array(
                'taxonomy' => 'prices',
                'terms' => $cats,
                'field' => 'slug'
            ));
        }
        $columnWidth = 'tt-price-';
        switch ($atts['column']) {
            case'2': {
                    $columnWidth.='two';
                    break;
                }
            case'3': {
                    $columnWidth.='three';
                    break;
                }
            case'4': {
                    $columnWidth.='four';
                    break;
                }
            case'5': {
                    $columnWidth.='five';
                    break;
                }
        }
        query_posts($args);
        while (have_posts()) {
            the_post();
            $table_options = get_post_meta(get_the_ID(), 'themeton_' . THEMENAME . '_options', true);
            $isDesc = isset($table_options['type']) && $table_options['type'] == 'description' ? true : false;
            $isFeat = isset($table_options['type']) && $table_options['type'] == 'featured' ? true : false;
            $isGen = $isDesc || $isFeat ? false : true;
            $planTypeText = $isGen ? __('General Plan', 'themeton') : ($isFeat ? __('Featured Plan', 'themeton') : __('Description Plan', 'themeton'));
            $output .= '<div class="' . $columnWidth . ' tt-price-col ' . ($isDesc ? 'visible-desktop' : '') . '">';
            $output .= '<div class="tt-price-box ' . ($isDesc ? 'tt-price-desc' : ($isFeat ? 'tt-price-feature' : '')) . '">';
            $output .= '<div class="tt-price-header">';
            $output .= '<h1>'.get_the_title().'</h1>';
            $output .= '<p>' . $planTypeText . '</p>';
            $output .= '</div>';
            $output .= '<div class="tt-price-top">';
            $output .= '<p>' . (isset($table_options['price']) ? $table_options['price'] : '') . '<span class="per">' . (isset($table_options['time']) ? $table_options['time'] : '') . '</span></p>';
            $output .= '</div>';
            $output .= '<div class="tt-price-bottom">';
            $output .= do_shortcode(get_the_content());
            $output .= '</div>';
            $output .= '<div class="tt-price-footer">';
            if (isset($table_options['buttonlink']) && !empty($table_options['buttonlink']) && isset($table_options['buttontext']) && !empty($table_options['buttontext'])) {
                $output .= '<a href="' . $table_options['buttonlink'] . '" class="tt-button '.$table_options['buttoncolor'].'">' . $table_options['buttontext'] . '</a>';
            }
            $output .= '</div>';
            $output .= '</div>';
            $output .= '</div>';
        }
        wp_reset_query();
        $output .= '</div>';

        return get_shortcode_container($output);
    }
}

// Accordion Shortcode
if (!function_exists('shortcode_accordion')) {
    function shortcode_accordion($atts, $content) {
        $output = '<div class="tt-accordion">';
        $output .= do_shortcode($content);
        $output .= '</div>';
        return get_shortcode_container($output);
    }
}

// Accordion item Shortcode
if (!function_exists('shortcode_accordion_item')) {
    function shortcode_accordion_item($atts, $content) {
        $active=(!empty($atts['expand'])&&$atts['expand']=='true')?true:false;
        $output = '<h3 class="accordion-title'.($active?' current':'').'"><a href="#"><span class="ui-icon ui-icon-triangle-1-e"></span>' . $atts['title'] . '</a></h3>';
        $output .= '<div class="accordion-content"><p>' . do_shortcode($content) . '</p></div>';
        return $output;
    }
}

// Tab Shortcode
if (!function_exists('shortcode_tab')) {
    function shortcode_tab($atts, $content) {
        $output  = '<div class="tt-shortcode">';
            $output .= '<div class="tt-tabs">';
                $output .= do_shortcode($content);
                $output .= '<ul class="tab-header clearfix"></ul><div class="tab-content"></div>';
            $output .= '</div>';
        $output .= '</div>';
        return get_shortcode_container($output);
    }
}

// Tab item Shortcode
if (!function_exists('shortcode_tab_item')) {
    function shortcode_tab_item($atts, $content) {
        $output = '<li><a href="javascript:;">' . $atts['title'] . '</a></li>';
        $output .= '<div class="tab-content-item"><p>' . do_shortcode($content) . '</p></div>';
        return $output;
    }
}

// Toggle Shortcode
if (!function_exists('shortcode_toggle')) {
    function shortcode_toggle($atts, $content) {
        $output = do_shortcode($content);
        return get_shortcode_container($output);
    }
}

// Toggle item Shortcode
if (!function_exists('shortcode_toggle_item')) {
    function shortcode_toggle_item($atts, $content) {
        $active=(!empty($atts['expand'])&&$atts['expand']=='true')?true:false;
        $output = '<div class="tt-toggle tt-toggle-closed'.($active?' tt-toggle-opened':'').'" role="tablist">';
        $output .= '<div class="tt-toggle-title" role="tab" aria-expanded="true" aria-selected="true" tabindex="0"><h3><a href="#"><span class="ui-icon ui-icon-triangle-1-e"></span>' . $atts['title'] . '</a></h3></div>';
        $output .= '<div class="tt-toggle-inner" role="tabpanel"><p>' . do_shortcode($content) . '</p></div>';
        $output .= '</div>';
        return $output;
    }
}

// Blog Shortcode
if (!function_exists('shortcode_blog')) {
    function shortcode_blog($atts, $content) {
        global $pb_options, $paged;
        $atts['count'] = empty($atts['count']) ? $pb_options['post_count'] : $atts['count'];
        $output = '<div class="tt-blog">';
        $query = Array(
            'post_type' => 'post',
            'posts_per_page' => $atts['count'],
            'paged' => $paged,
        );
        $cats = empty($atts['category']) ? false : explode(",", $atts['category']);
        if ($cats) {
            $query['tax_query'] = Array(Array(
                    'taxonomy' => 'category',
                    'terms' => $cats,
                    'field' => 'slug'
                )
            );
        }
        $pb_options['show_pagination'] = $atts['pagination'] == 'true' ? true : false;
        $pb_options['excerpt_count'] = $atts['excerpt'];
        $pb_options['more_text'] = $atts['read_more'];
        $pb_options['block'] = $atts['block'];
        query_posts($query);
        ob_start();
        get_template_part("loop");
        $output .= ob_get_contents();
        ob_end_clean();
        wp_reset_query();
        $output .= '</div>';
        return get_shortcode_container($output);
    }
}

// Portfolio Shortcode
if (!function_exists('shortcode_portfolio')) {
    function shortcode_portfolio($atts, $content) {
        global $pb_options, $paged;
        $cats = empty($atts['category']) ? false : explode(",", $atts['category']);
        $filter = "";
        if($atts['filter']=='true') {
            $filter.='<div class="tt-pagination align-left">';
            $filter.='<ul class="filters option-set clearfix post-category" data-option-key="filter">';
            $filter.='<li><a href="#filter" data-option-value="*" class="selected">' . __('All', 'themeton') . '</a></li>';
            if ($cats) {
                $filters = $cats;
            } else {
                $filters = get_terms('portfolios');
            }
            foreach ($filters as $category) {
                if ($cats) {
                    $category = get_term_by('slug', $category, 'portfolios');
                }
                $filter.='<li class="hide"><a href="#filter" data-option-value=".category-' . $category->slug . '" title="' . $category->name . '" ' . ' class="post-category-item">' . $category->name . '</a></li>';
            }
            $filter.='</ul>';
            $filter.='</div><div class="clear"></div>';
        }
        $pb_options['show_pagination'] = $atts['pagination'] == 'true' ? true : false;
        $pb_options['post_count'] = $atts['count'];
        $pb_options['block'] = $atts['column'];
        $pb_options['height'] = empty($atts['image_height']) ? get_settings_value("portfolio_height") : str_replace('px', '', $atts['image_height']);

        $query = Array(
            'post_type' => 'portfolio',
            'posts_per_page' => $pb_options['post_count'],
            'paged' => $paged,
        );
        if ($cats) {
            $query['tax_query'] = Array(Array(
                    'taxonomy' => 'portfolios',
                    'terms' => $cats,
                    'field' => 'slug'
                )
            );
        }
        $output = $filter;
        $output .= '<div class="tt-portfolio portfolio">';
        query_posts($query);
        ob_start();
        get_template_part("loop", "portfolio");
        $output .= ob_get_contents();
        ob_end_clean();
        wp_reset_query();
        $output .= '</div>';
        return get_shortcode_container('<div class="tt-element">'.$output.'</div>');
    }
}

// Carousel Shortcode
if (!function_exists('shortcode_carousel')) {
    function shortcode_carousel($atts, $content) {
        $post_count = empty($atts['count']) ? get_option('posts_per_page') : $atts['count'];
        $post_content = empty($atts['post_content']) ? 20 : $atts['post_content'];
        $image_height = empty($atts['height']) ? "" : str_replace('px', '', $atts['height']);
        $post_type = empty($atts['post_type']) ? "post" : $atts['post_type'];
        $cat_post = empty($atts['post_category'])      ? false : explode(",", $atts['post_category']);
        $cat_port = empty($atts['portfolio_category']) ? false : explode(",", $atts['portfolio_category']);
        $query = Array(
            'post_type' => $post_type,
            'posts_per_page' => $post_count,
        );
        if ($post_type == "post") {
            if ($cat_post) {
                $query['tax_query'] = Array(Array(
                        'taxonomy' => 'category',
                        'terms' => $cat_post,
                        'field' => 'slug'
                    )
                );
            }
        } else {
            if ($cat_port) {
                $query['tax_query'] = Array(Array(
                        'taxonomy' => 'portfolios',
                        'terms' => $cat_port,
                        'field' => 'slug'
                    )
                );
            }
        }
        $output = '<div class="tt-post-carousel responsive for-' . $post_type . '-carousel">';
        $output .= '<ul class="slides">';
        $wp_query = new WP_Query();
        $wp_query->query($query);
        while ($wp_query->have_posts()) {
            $wp_query->the_post();
            global $post;
            $thumb = "";
            if (has_post_thumbnail($post->ID)) {
                $lrg_img = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');
                $image_width = empty($atts['width']) ? 200 : $atts['width'];
                $url = aq_resize($lrg_img[0], $image_width, $image_height, true);
                $thumb =
                        '<div class="clearfix hover-content">
                                    <img src="' . $url . '" alt="">
                                    <div class="image-overlay">
                                            <div class="hover-links clearfix">
                                                    <a class="hover-permalink" href="' . get_permalink($post->ID) . '"></a>
                                                    <a class="hover-zoom" rel="prettyPhoto" href="' . $url . '" title="' . $post->post_title . '"></a>
                                            </div>
                                    </div>
                            </div>';
            }
            if ($post_type == "post") {
                $output .= '<li>
                                    ' . $thumb . '	
                                    <h2 class="title">
                                        <a href="' . get_permalink($post->ID) . '">' . $post->post_title . '</a>
                                    </h2>
                                    <ul class="meta clearfix">
                                            <li><a href="#">' . date('j F, Y', strtotime($post->post_date)) . '</a></li>
                                            <li><a href="#">' . comment_count() . '</a></li>
                                    </ul>
                                    <p>' . showBrief($post->post_content, $post_content) . '</p>
                                </li>';
            } else {
                $output .= '<li>
                                    ' . $thumb . '	
                                    <h2 class="title">
                                        <a href="' . get_permalink($post->ID) . '">' . $post->post_title . '</a>
                                    </h2>
                                    <ul class="meta clearfix">'
                        . get_the_term_list($post->ID, 'portfolios', '<li>', '</li><li>', '</li>') .
                        '</ul>
                                </li>';
            }
        }
        wp_reset_query();
        $output .= '</ul>';
        $output .= '<div class="clearfix"></div>';
        $output .= '<div class="carousel-arrow">';
        $output .= '<a class="carousel-prev" href="#"><i class="icon-angle-left"></i></a>';
        $output .= '<a class="carousel-next" href="#"><i class="icon-angle-right"></i></a>';
        $output .='</div>';
        $output .='</div>';
        return get_shortcode_container($output);
    }
}


// Team Shortcode
if (!function_exists('shortcode_team')) {

    function shortcode_team($atts, $content) {
        $width = 270;
        $output = '<div class="tt-team">';
        $cats = empty($atts['category']) ? false : explode(",", $atts['category']);
        $args = array(
            'post_type' => 'team',
            'posts_per_page' => $atts['count'],
            'orderby' => 'date',
            'order' => 'ASC',
        );
        if ($cats) {
            $args['tax_query'] = Array(Array(
                'taxonomy' => 'position',
                'terms' => $cats,
                'field' => 'slug'
            ));
        }
        $columnWidth = 'tt-price-';
        switch ($atts['column']) {
            case'2': {
                    $columnWidth.='two';
                    break;
                }
            case'3': {
                    $columnWidth.='three';
                    break;
                }
            case'4': {
                    $columnWidth.='four';
                    break;
                }
            case'5': {
                    $columnWidth.='five';
                    break;
                }
        }
        $height = empty($atts['height']) ? 100 : str_replace('px', '', $atts['height']);
        query_posts($args);
        while (have_posts()) {
            the_post();
            $output .= '<article class="team-member ' . $columnWidth . ' tt-price-col">';
            $output .= post_image_show($width, $height);
            $output .= '<div class="team-content">';
            $output .= '<h2 class="member-name">' . get_the_title() . '</h2>';
            if (get_field('position') != '') {
                $output .= '<p  class="member-position">' . get_field('position') . '</p>';
            }
            $output .= '<ul class="member-social clearfix">';
            if (get_field('facebook') != '') {
                $output .= '<li><a href="' . get_field('facebook') . '" class="facebook">Facebook</a></li>';
            }
            if (get_field('twitter') != '') {
                $output .= '<li><a href="' . get_field('twitter') . '" class="twitter" >Twitter</a></li>';
            }
            if (get_field('google') != '') {
                $output .= '<li><a href="' . get_field('google') . '" class="google"  >Google</a></li>';
            }
            if (get_field('linkedin') != '') {
                $output .= '<li><a href="' . get_field('linkedin') . '" class="linkedin">Linkedin</a></li>';
            }
            $output .= '</ul>';
            $output .= '</div>';
            $output .= '</article>';
        }
        wp_reset_query();
        $output .= '</div>';
        return get_shortcode_container($output);
    }

}


// Add Shortcode
add_shortcode('accordion', 'shortcode_accordion');
add_shortcode('accordion_item', 'shortcode_accordion_item');
add_shortcode('blog', 'shortcode_blog');
add_shortcode('buttons', 'shortcode_buttons');
add_shortcode('label', 'shortcode_label');
add_shortcode('carousel', 'shortcode_carousel');
add_shortcode('divider', 'shortcode_divider');
add_shortcode('dropcap', 'shortcode_dropcap');
//add_shortcode('image_slider',  'shortcode_image_slider');
add_shortcode('list', 'shortcode_list');
add_shortcode('list_item', 'shortcode_list_item');
add_shortcode('message_box', 'shortcode_message_box');
add_shortcode('portfolio', 'shortcode_portfolio');
add_shortcode('pricing_table', 'shortcode_pricing_table');
add_shortcode('progress_bar', 'shortcode_progress_bar');
add_shortcode('social_button', 'shortcode_social_button');
//add_shortcode('slider',        'shortcode_slider');
add_shortcode('tab', 'shortcode_tab');
add_shortcode('tab_item', 'shortcode_tab_item');
add_shortcode('team', 'shortcode_team');
add_shortcode('testimonials', 'shortcode_testimonials');
add_shortcode('toggle', 'shortcode_toggle');
add_shortcode('toggle_item', 'shortcode_toggle_item');
add_shortcode('twitter', 'shortcode_twitter');
add_shortcode('video', 'shortcode_video');
// Column Shortcodes
add_shortcode('one_half', 'shortcode_one_half');
add_shortcode('one_third', 'shortcode_one_third');
add_shortcode('one_fourth', 'shortcode_one_fourth');
add_shortcode('one_fifth', 'shortcode_one_fifth');
add_shortcode('one_sixth', 'shortcode_one_sixth');
add_shortcode('two_third', 'shortcode_two_third');
add_shortcode('two_fifth', 'shortcode_two_fifth');
add_shortcode('three_fourth', 'shortcode_three_fourth');
add_shortcode('three_fifth', 'shortcode_three_fifth');
add_shortcode('four_fifth', 'shortcode_four_fifth');
add_shortcode('five_sixth', 'shortcode_five_sixth');