<?php
global $staticWidths;
$defaultWidth=!empty($staticWidths['carousel'])?$staticWidths['carousel']:'size_col_full';

$post_cats = $portfolio_cats = '<option value="0">All</option>';

$post_terms = get_categories("hide_empty=0");
foreach ($post_terms as $term) {
    $post_cats .= '<option value="' . $term->slug . '">' . $term->name . '</option>';
}

$post_terms = get_terms('portfolios', 'hide_empty=0');
if(is_array($post_terms)) {
    foreach ($post_terms as $term) {
        $portfolio_cats .= '<option value="' . $term->slug . '">' . $term->name . '</option>';
    }
}
$cb_toolbar_title[] = "Carousel";
$cb_toolbar_video[] = "http://docs.themeton.com/emerald/2013/02/carousel-element/";
$cb_toolbar_width[] = $defaultWidth;
$cb_toolbar_html[] = '<div class="cb_hidden_form">
                        <div class="cb_form_wrapper">
                            <div class="tt-title-container">
                                <div class="tt-head-element add_item_medium">
                                    <input type="text" class="cbf_title" placeholder="Title of Item" />
                                </div>
                                <div class="tt-head-element add_item">
                                    <select name="cbf_title_style" class="cbf_title_style default_value">
                                        <option value="1">H1</option>
                                        <option value="2">H2</option>
                                        <option value="3">H3</option>
                                        <option value="4">H4</option>
                                        <option value="5">H5</option>
                                    </select>
                                </div> 
                                <div class="tt-head-element add_item">
                                    <div class="color_selector">
                                        <div class="color_picker" id="skin_background_color"><div style="background-color: #701010;" class="color_picker_inner"></div></div>
                                        <input type="text" class="color_picker_value" name="skin_background_color"  value="#701010">
                                    </div>
                                </div>
                                <div class="tt-head-element add_item_medium">
                                    <input type="text" class="cbf_custom_class" placeholder="Custom class" />
                                </div>
                            </div>
                            <div class="clear"></div>


                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Post type</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select class="cbf_post_type">
                                        <option value="post">Post</option>
                                        <option value="portfolio">Portfolio</option>
                                        <option value="client">Partner</option>
                                    </select>
                                </div>
                            </div>
                            <div class="clear"></div>
                            <div class="tt-elements-container cb_post">
                                <div class="tt-title-element title-element">
                                    <label>Category</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select class="default_carousel cbf_post_category">' . $post_cats . '</select>
                                </div>
                                <div class="tt-description">
                                    Choose the post category you want to include the blog post. You can select one or multiple category here.
                                </div>
                                <div class="category_list"></div>
                            </div>
                            <div class="clear"></div>
                            <div class="tt-elements-container cb_portfolio">
                                <div class="tt-title-element title-element">
                                    <label>Category</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select class="default_carousel cbf_portolio_category">' . $portfolio_cats . '</select>
                                </div>
                                <div class="tt-description">
                                    Choose the post category you want to include the blog post. You can select one or multiple category here.
                                </div>
                                <div class="category_list"></div>
                            </div>
                            <div class="clear"></div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Posts count</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <input type="text" class="cbf_postcount" placeholder="10" />
                                </div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Image Height</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <input type="text" class="cbf_imageheight" placeholder="150"/>
                                </div>
                                <div class="tt-description">
                                    By pixels
                                </div>
                            </div>
                            
                            <div class="tt-elements-container cb_post">
                                <div class="tt-title-element title-element">
                                    <label>Excerpt</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <input type="text" class="cbf_postcontent" placeholder="5" />
                                </div>
                                <div class="tt-description">
                                    Empty, 0 or number value allowed. If you leave it empty, element prints posts\' excerpt.
                                </div>
                            </div>
                            
                            <div class="tt-elements-container cb_portpost">
                                <div class="tt-title-element title-element">
                                    <label>Feature Text</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <textarea name="cbf_feature_text" class="cbf_feature_text" rows="5" cols="27"></textarea>
                                </div>
                                <div class="tt-description">
                                    Ene optionuud full eswel 3/4 ued l ajillah bolno.
                                </div>
                            </div>
                            <div class="tt-elements-container cb_portpost">
                                <div class="tt-title-element title-element">
                                    <label>Feature text position</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select name="cbf_text_position" class="cbf_text_position">
                                        <option value="left">'.__('Left','themeton').'</option>
                                        <option value="right">'.__('Right','themeton').'</option>
                                    </select>
                                </div>
                            </div>                        
                            
                            <div class="tt-elements-container cb_portpost">
                                <div class="tt-title-element title-element">
                                    <label>Button Text</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <input type="text" class="cbf_buttontext"/>
                                </div>                                
                            </div>
                            <div class="tt-elements-container cb_portpost">
                                <div class="tt-title-element title-element">
                                    <label>Button Link</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <input type="text" class="cbf_buttonlink"/>
                                </div>                                
                            </div>
                        </div>
                    </div>
                    <div class="cb_hidden_data">
                        <title></title>
                        <type>carousel</type>
                        <size>'.$defaultWidth.'</size>
                        <title_style>3</title_style>
                        <start_row></start_row>
                        <custom_class></custom_class>
                        <color_picker_value></color_picker_value>
                        <post_type>post</post_type>                        
                        <postcount>'.get_option('posts_per_page').'</postcount>
                        <postcontent>10</postcontent>
                        <imageheight>150</imageheight>
                        <post_category></post_category>
                        <port_category></port_category>
                        <text_position>left</text_position>
                        <feature_text></feature_text>
                        <buttontext></buttontext>
                        <buttonlink></buttonlink>
                    </div>';

function cb_item_carousel($item) {
    $custom_class = find_xml_value($item, 'custom_class');
    global $container;
    $size = find_xml_value($item, 'size');
    $post_count = find_xml_value($item, 'postcount')!= "" ? find_xml_value($item, 'postcount') : get_option('posts_per_page');
    $post_content = find_xml_value($item, 'postcontent')!= "" ? find_xml_value($item, 'postcontent') : 20;
    $image_height = find_xml_value($item, 'imageheight')!= "" ? find_xml_value($item, 'imageheight') : "";
    $post_type = find_xml_value($item, 'post_type')!="" ? find_xml_value($item, 'post_type') : "post";
    $feature_text = find_xml_value($item, 'feature_text');
    $text_position = find_xml_value($item, 'text_position')!="" ? find_xml_value($item, 'text_position') : "left";
    $buttontext = find_xml_value($item, 'buttontext');
    $buttonlink = find_xml_value($item, 'buttonlink');
    
    $tab_xml = find_xml_node($item, 'post_category');
    foreach ($tab_xml->childNodes as $node) {
        if (find_xml_value($node, 'name') != "") {
            $cat_post[] = find_xml_value($node, 'name');
        }
    }
    $tab_xml = find_xml_node($item, 'port_category');
    foreach ($tab_xml->childNodes as $node) {
        if (find_xml_value($node, 'name') != "") {
            $cat_port[] = find_xml_value($node, 'name');
        }
    }
    
    $query = Array(
        'post_type' => $post_type,
        'posts_per_page' => $post_count,
    );
    if ($post_type == "post") {
        if (isset($cat_post)) {
            $query['tax_query'] = Array(Array(
                    'taxonomy' => 'category',
                    'terms' => $cat_post,
                    'field' => 'slug'
                )
            );
        }
    } elseif ($post_type == "portfolio") {
        if (isset($cat_port)) {
            $query['tax_query'] = Array(Array(
                    'taxonomy' => 'portfolios',
                    'terms' => $cat_port,
                    'field' => 'slug'
                )
            );
        }
    }
    $class = "";
    
    $html = '<div class="carousel-container">';

    if(!empty($feature_text)){
        if($size == "size_col_full"){
            $newsize = "size_col_4_3";
        } elseif($size == "size_col_4_3") {
            $newsize = "size_col_half";
        } else {
            $newsize = $size;
        }
        if($text_position == "left"){
            if($size == "size_col_full" || $size == "size_col_4_3") {
                $html .= '<div class="' .$custom_class.' '. size_back_to_front('size_col_4_1'). ((find_xml_value($item, 'start_row')==='true')?' start-row':'') .' carousel-teaser-text">';                
                $html .= '<div class="tt-element">';
                if (find_xml_value($item, 'title') != "") {
                    $html .= get_element_title(find_xml_value($item, 'title'),find_xml_value($item, 'title_style'),find_xml_value($item, 'color_picker_value'));
                }
                $html .= '<div class="tt-carousel-teaser">';
                $html .= '<p>'.$feature_text.'</p>';
                if(!empty($buttontext)){
                    $html .= '<a href="'.to_url($buttonlink).'">'.$buttontext.'</a>';
                }
                $html .= '<div class="carousel-arrow">';
                $html .= '<a class="carousel-prev" href="#"><i class="icon-angle-left"></i></a>';
                $html .= '<a class="carousel-next" href="#"><i class="icon-angle-right"></i></a>';	
                $html .='</div>';
                $html .= '</div>';
                $html .= '</div>';
                $html .= '</div>';
                $html .= '<div class="' .$custom_class.' '. size_back_to_front($newsize) . '">';
            } else {
                $html .= '<div class="' .$custom_class.' '. size_back_to_front($newsize) . ((find_xml_value($item, 'start_row')==='true')?' start-row':'') .'">';
            }
        } else {
            $html .= '<div class="' .$custom_class.' '. size_back_to_front($newsize) . ((find_xml_value($item, 'start_row')==='true')?' start-row':'') .'">';
        }
    } else {
        $html .= '<div class="' .$custom_class.' '. size_back_to_front($size) . ((find_xml_value($item, 'start_row')==='true')?' start-row':'') .'">';
    }
    
    
        $html .= '<div class="tt-element">';
            if(find_xml_value($item, 'title') != "" && empty($feature_text)){$class=" with-title"; $html .= get_element_title(find_xml_value($item, 'title'),find_xml_value($item, 'title_style'),find_xml_value($item, 'color_picker_value'));}
            $html .='<div class="tt-post-carousel responsive for-'.$post_type.'-carousel'.$class.'">';
                $html .= '<ul class="slides">';
                    $wp_query = new WP_Query();
                    $wp_query->query($query);
                    while ($wp_query->have_posts()){ $wp_query->the_post();
                        global $post;
                        
                        if(!get_field("custom_link_url")) {
                            $link = get_permalink();
                            $target = '_self';
                        } else {
                            $link = to_url(get_field("custom_link_url"));
                            $target = get_field("custom_link_target");
                        }
                        
                        if($post_type == "client") {
                            if (has_post_thumbnail($post->ID)) {
                                $options = get_post_meta(get_the_ID(), 'themeton_'.THEMENAME.'_options', true);
                                $image_width = carousel_size($size, $container);                                
                                $html .= '<li><div class="our-clients clearfix">';
                                $html .= !empty($options['link']) ? ('<a href="'.to_url($options['link']).'" target="_blank">') : "";
                                $html .= post_image_show(225, $image_height);
                                $html .= !empty($options['link']) ? ('</a>') : "";
								$html .= '</div></li>';                                
                            }
                        } else {
                            if (has_post_thumbnail($post->ID)) { 
                                $lrg_img = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');
                                $image_width = carousel_size($size, $container);                           

                                $thumb =         
                                    '<div class="clearfix hover-content">
                                            '.post_image_show($image_width, $image_height).'
                                            <div class="image-overlay">
                                                    <div class="hover-links clearfix">
                                                            <a class="hover-permalink" href="'.$link.'" target="'.$target.'"></a>
                                                            <a class="hover-zoom" rel="prettyPhoto" href="'.$lrg_img[0].'" title="'.$post->post_title.'"></a>
                                                    </div>
                                            </div>
                                    </div>';
                            } else {
                                $image_width = carousel_size($size, $container);
                                $image_height = !empty($image_height) ? $image_height : 200;
                                $thumb = "<div class='no-image clearfix'><div style='width:".$image_width."px;height:".$image_height."px'>".__("No image", "themeton")."</div></div>";
                            }
                        
                        
                            if($post_type == "post") {

                                $html .= '<li>
                                            ' . $thumb . '	
                                            <h2 class="title">
                                                <a href="' . $link . '" target="' . $target . '">' . $post->post_title . '</a>
                                            </h2>
                                            <ul class="meta clearfix">
                                                    <li class="date-meta">' . date('j F, Y', strtotime($post->post_date)) . '</li>
                                                    <li class="comment-meta">' . comment_count() . '</li>
                                            </ul>
                                            <p>' . showBrief($post->post_content,$post_content) . '</p>
                                        </li>';
                            } else {

                                $html .= '<li>
                                            ' . $thumb . '	
                                            <h2 class="title">
                                                <a href="' . $link . '" target="' . $target . '">' . $post->post_title . '</a>
                                                    <span class="tt-element-title-border"></span>
                                            </h2>
                                        </li>';
                            }
                        }
                    }
                    wp_reset_query();
                $html .= '</ul>';
                if(empty($feature_text)){
                    $html .= '<div class="carousel-arrow">';
                    $html .= '<a class="carousel-prev" href="#"><i class="icon-angle-left"></i></a>';
                    $html .= '<a class="carousel-next" href="#"><i class="icon-angle-right"></i></a>';	
                    $html .='</div>';
                }
            $html .='</div>';
        $html .='</div>';
    $html .='</div>';
        
        
    if(!empty($feature_text)){
        if($text_position == "right"){
            if($size == "size_col_full" || $size == "size_col_4_3") {
                $html .= '<div class="' .$custom_class.' '. size_back_to_front('size_col_4_1') .' carousel-teaser-text">';                
                $html .= '<div class="tt-element">';
                if (find_xml_value($item, 'title') != "") {
                    $html .= get_element_title(find_xml_value($item, 'title'),find_xml_value($item, 'title_style'),find_xml_value($item, 'color_picker_value'));
                }
                $html .= '<div class="tt-carousel-teaser">';
                $html .= '<p>'.$feature_text.'</p>';
                if(!empty($buttontext)){
                    $html .= '<a href="'.to_url($buttonlink).'">'.$buttontext.'</a>';
                }
                $html .= '<div class="carousel-arrow">';
                $html .= '<a class="carousel-prev" href="#"><i class="icon-angle-left"></i></a>';
                $html .= '<a class="carousel-next" href="#"><i class="icon-angle-right"></i></a>';	
                $html .='</div>';
                $html .= '</div>';
                $html .= '</div>';
                $html .= '</div>';
            }
        }
    }     
        
    $html .= '</div>';
    
    echo $html;
}