<?php
global $staticWidths;
$defaultWidth=!empty($staticWidths['pricing_table'])?$staticWidths['pricing_table']:'size_col_full';
$terms = get_terms( 'prices', 'hide_empty=0' );
$select = "";
foreach($terms as $term){$select .= "<option value='".$term->slug."'>".$term->name."</option>";}

$cb_toolbar_title[] = "Pricing table";
$cb_toolbar_video[] = "http://docs.themeton.com/emerald/2013/02/pricing-table-element/";
$cb_toolbar_width[] = $defaultWidth;
$cb_toolbar_html[] = '<div class="cb_hidden_form">
                        <div class="cb_form_wrapper">
                            <div class="tt-title-container">
                                <div class="tt-head-element add_item_medium">
                                    <input type="text" class="cbf_title" placeholder="Title of Item" />
                                </div>
                                <div class="tt-head-element add_item">
                                    <select name="cbf_title_style" class="cbf_title_style default_value">
                                        <option value="1">H1</option>
                                        <option value="2">H2</option>
                                        <option value="3">H3</option>
                                        <option value="4">H4</option>
                                        <option value="5">H5</option>
                                    </select>
                                </div> 
                                <div class="tt-head-element add_item">
                                    <div class="color_selector">
                                        <div class="color_picker" id="skin_background_color"><div style="background-color: #701010;" class="color_picker_inner"></div></div>
                                        <input type="text" class="color_picker_value" name="skin_background_color"  value="#701010">
                                    </div>
                                </div>
                                <div class="tt-head-element add_item_medium">
                                    <input type="text" class="cbf_custom_class" placeholder="Custom class" />
                                </div>
                            </div>
                            
                            <div class="clear"></div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Column</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select name="cbf_column_count" class="cbf_column_count">
                                        <option value="2">2 columns</option>
                                        <option value="3">3 columns</option>
                                        <option value="4">4 columns</option>
                                        <option value="5">5 columns</option>
                                    </select>
                                 </div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Category</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select name="cbf_price_table" class="cbf_price_table default_value">
                                        <option value="0">Select Price Table</option>'
                                        . $select .
                                    '</select>
                                </div>
                                <div class="tt-description">
                                    Choose the post category you want to include the blog post.
                                </div>
                                <div class="category_list"></div>
                            </div>
                        </div>
                    </div>
                    <div class="cb_hidden_data">
                        <title></title>
                        <type>pricing_table</type>
                        <size>'.$defaultWidth.'</size>
                        <title_style>3</title_style>
                        <start_row></start_row>
                        <custom_class></custom_class>
                        <color_picker_value></color_picker_value>
                        <column_count>4</column_count>
                        <price_table></price_table>
                    </div>';

function cb_item_pricing_table($item) {
    $custom_class = find_xml_value($item, 'custom_class');
    $html = '<div class="' .$custom_class.' '. size_back_to_front(find_xml_value($item, 'size')) . ((find_xml_value($item, 'start_row')==='true')?' start-row':'').'">';
        $html .= '<div class="tt-element">';
            if(find_xml_value($item, 'title') != ""){$html .= get_element_title(find_xml_value($item, 'title'),find_xml_value($item, 'title_style'),find_xml_value($item, 'color_picker_value'));}
            $html.= '<div class="tt-price-block clearfix">';
                $tab_xml = find_xml_node($item, 'price_table');
                foreach ($tab_xml->childNodes as $node) {
                    if (find_xml_value($node, 'name') != "") {
                        $cat[] = find_xml_value($node, 'name');
                    }
                }
                $args = array(
                    'post_type'      => 'price',                            
                    'posts_per_page' => find_xml_value($item, 'column_count'),
                    'orderby'        => 'date',
                    'order'          => 'ASC',
                );
                if(isset($cat)){
                    $args['tax_query'] = Array(Array(
                        'taxonomy' => 'prices',
                        'terms' => $cat,
                        'field' => 'slug'
                    ));
                }
                $columnWidth='tt-price-';
                switch(find_xml_value($item, 'column_count')){
                    case'2':{$columnWidth.='two';  break;}
                    case'3':{$columnWidth.='three';break;}
                    case'4':{$columnWidth.='four'; break;}
                    case'5':{$columnWidth.='five'; break;}
                }
                query_posts($args);
                while (have_posts()){ the_post();
                    $table_options = get_post_meta(get_the_ID(), 'themeton_'.THEMENAME.'_options', true);
                    $btncolor = !empty($table_options['buttoncolor']) ? $table_options['buttoncolor'] : "";
                    $isDesc=isset($table_options['type'])&&$table_options['type']=='description'?true:false;
                    $isFeat=isset($table_options['type'])&&$table_options['type']=='featured'   ?true:false;
                    $isGen =$isDesc||$isFeat?false:true;
                    $html .= '<div class="'.$columnWidth.' tt-price-col '.($isDesc?'visible-desktop':'').'">';
                        $html .= '<div class="tt-price-box '.($isDesc?'tt-price-desc':($isFeat?'tt-price-feature':'')).'">';
                            $html .= '<div class="tt-price-header">';
                                $html .= '<h1>'.get_the_title().'</h1>';
                                $html .= '<p>' .(isset($table_options['plan'])?$table_options['plan']:'').'</p>';
                            $html .= '</div>';
                            $html .= '<div class="tt-price-top">';
                                $html .= '<p>'.(isset($table_options['price'])?$table_options['price']:'').'<span class="per">'.(isset($table_options['time'])?$table_options['time']:'').'</span></p>';
                            $html .= '</div>';
                            $html .= '<div class="tt-price-bottom">';
                                $html .= do_shortcode(get_the_content());
                            $html .= '</div>';
                            if(!empty($table_options['buttontext'])) {
                                $html .= '<div class="tt-price-footer">';  
                                $html .= '<a href="'. (!empty($table_options['buttonlink']) ? to_url($table_options['buttonlink']) : "#") .'" class="tt-button '.$btncolor.'">'.$table_options['buttontext'].'</a>';
                                $html .= '</div>';
                            }
                        $html .= '</div>';
                    $html .= '</div>';
                }
                wp_reset_query();
            $html .= '</div>';
        $html .= '</div>';
    $html .= '</div>';
    echo $html;
}