<?php
global $fields;

$fields['skin_options'] = Array(
    'general_color' => Array(
        'type' => 'colorpicker',
        'default' => '#00ddff',
        'title' => __('General Color', 'themeton'),
        'description' => __('This is all of your elements color.', 'themeton')),
    'hover_color' => Array(
        'type' => 'colorpicker',
        'default' => '#00bdd6',
        'title' => __('Hover Color of links', 'themeton'),
        'description' => __('You should select related color with General.', 'themeton')),
    'header_color' => Array(
        'type' => 'colorpicker',
        'default' => '#1b1b1b',
        'title' => __('Header background color', 'themeton'),
        'description' => __('Choose header background color.', 'themeton')),
    'menuborder_color' => Array(
        'type' => 'colorpicker',
        'default' => '#121212',
        'title' => __('Navigation border color', 'themeton'),
        'description' => __('Menu border-top color on header section.', 'themeton')),
    'menubordershadow_color' => Array(
        'type' => 'colorpicker',
        'default' => '#232323',
        'title' => __('Navigation border shadow color', 'themeton'),
        'description' => __('Menu border-top shadow color on header section.', 'themeton')),
    'menusep_color' => Array(
        'type' => 'colorpicker',
        'default' => '#2d2d2d',
        'title' => __('Menu right seperator color', 'themeton'),
        'description' => __('Menu dotted right border color.', 'themeton')),
    'menusearch_color' => Array(
        'type' => 'colorpicker',
        'default' => '#636363',
        'title' => __('Search text color', 'themeton'),
        'description' => __('Search widget text color on menu section.', 'themeton')),
    'is_boxed' => Array(
        'type' => 'checkbox',
        'title' => __('Boxed Layout?', 'themeton'),
        'default' => 0,
        'show' => 'background',
        'description' => __('If turn it On, Your theme Layout will be boxed.', 'themeton')),
    'background' => Array(
        'type' => 'background',
        'title' => __('Background', 'themeton'),
        'default' => array("color" => "#FFF", "image" => "", "repeat" => "", "position" => "", "attachment" => ""),
        'description' => __('Choose background color.', 'themeton')),
    'custom_css' => Array(
        'type' => 'textarea',
        'title' => __('Custom CSS', 'themeton'),
        'description' => __('If you have advanced style changes, you can include here your custom CSS. Your included style will always priviliged than standard style.', 'themeton')),
);
foreach($fields['skin_options'] as $type=>$field) {
    $field["name"] = $type;
    if(function_exists('form_field_'.$field["type"]))
        call_user_func('form_field_'.$field["type"], $field);
}
	
?>