<?php
$page_settings = Array(
    'page_layout' => Array('type' => 'layoutpage', 'description' => __('Select layout.', 'themeton'), 'default' => 'without'),
    'slider' => Array('type' => 'checkbox', 'show' => '#slider_id', 'description' => __('If turn this option ON, it will be show with slideshow.', 'themeton'), 'title' => __('Slider ?', 'themeton')),
    'slider_id' => Array('type' => 'slideshow', 'description' => __('Select slideshow.', 'themeton'), 'title' => __('Select slider', 'themeton')),
    'teaser_text' => Array('type' => 'textarea', 'description' => "".__('Teaser text', 'themeton'), 'title' => __('Teaser text', 'themeton')),
    'meta_author' => Array('type' => 'selectbox', 'description' => __('If turn it ON, post will show with author link on blog/category pages. Middle meas options controls from admin panel.', 'themeton'), 'title' => __('Show post author ?', 'themeton'), 'default' => 'default'),
    'breadcrumb_show' => Array('type' => 'selectbox', 'description' => __('If turn it ON, your page will show with Bradcrumb. This option only refers to this page. Middle meas options controls from admin panel.', 'themeton'), 'title' => __('Breadcrumb', 'themeton'), 'default' => 'default'),
);
add_action('admin_init', 'page_settings_custom_box', 1);

function page_settings_custom_box() {
    global $page_settings;
    add_meta_box(
        'page_meta_settings',
        __( 'Page settings', 'themeton' ), 
        'page_settings_section',
        'page',
        'normal',
        'core',
        $page_settings
    );
}
function page_settings_section($post, $metabox) {
    global $post; 
    $options = get_post_meta($post->ID, 'themeton_'.THEMENAME.'_options', true);?>
        <div class="additional_panel_container">
            <div class="additional_panel"><br />
                <table>
                    <?php	                              
                    foreach ($metabox['args'] as $type=>$settings) {
                        $settings['name'] = $type;
                        $settings['value'] = isset($options[$settings['name']]) ? $options[$settings['name']] : (isset($settings['default']) ? $settings['default'] : '');
                        call_user_func('settings_'.$settings['type'], $settings);	
                    }
                    ?>   
                </table>
            </div>
        </div>
<?php 
}
?>