<?php

function form_field_browse($settings) {
    $settings["default"] = isset($settings["default"]) ? $settings["default"] : "";
    $value = option_value($settings["name"]) !== false ? get_settings_value($settings["name"]) : $settings['default'];
    ?>
    <div class="form_field" id="field_<?php echo $settings["name"]; ?>">
        <label for="<?php echo $settings["name"]; ?>">
            <?php echo $settings["title"]; ?>
        </label>
        <div class="browse_input">

            <div class="preview" style="<?php echo $value != "" ? "" : "display: none"; ?>">
                <img src="<?php echo $value; ?>" id="img_header_logo" />
            </div>

            <input type="text" class="browse_inputfield" id="<?php echo $settings["name"]; ?>" name="<?php echo $settings["name"]; ?>" value="<?php echo $value; ?>" />
            <a href="javascript:;" class="theme_button green form_field_browse_button" id="browse_header_logo"><?php _e('Browse', 'themeton'); ?></a>
        </div>
        <small>
            <?php echo $settings["description"]; ?>
        </small>
        <div class="clear"></div>
    </div>
<?php } ?>
<?php

function form_field_checkbox($settings) {

    $default = get_settings_value($settings["name"]) != "" ? get_settings_value($settings["name"]) : $settings['default'];
    $datashow = $datahide = $klass = "";
    if (!empty($settings['hide'])) {
        $klass = " check-show-hide";
        $hide = split(',', $settings['hide']);
        foreach ($hide as $h) {
            $datahide .= '#field_' . $h . ',';
        }
        $datahide = substr($datahide, 0, -1);
    }
    if (!empty($settings['show'])) {
        $klass = " check-show-hide";
        $show = split(',', $settings['show']);
        foreach ($show as $sh) {
            $datashow .= '#field_' . $sh . ',';
        }
        $datashow = substr($datashow, 0, -1);
    }
    ?>
    <div class="form_field" id="field_<?php echo $settings["name"]; ?>">
        <label for="<?php echo $settings["name"]; ?>">
            <?php echo $settings["title"]; ?>
        </label>
        <div class="browse_input">
            <input type="hidden" name="<?php echo $settings["name"]; ?>" value="0"/>
            <input type="checkbox" class="yesno <?php echo $klass; ?>" data-show="<?php echo $datashow; ?>" data-hide="<?php echo $datahide; ?>" name="<?php echo $settings["name"]; ?>" value="1" <?php echo checked($default, 1, false); ?> />
        </div>
        <small>
            <?php echo $settings['description']; ?>
        </small>
        <div class="clear"></div>
    </div>
<?php } ?>
<?php

function form_field_multicheck($settings) {
    ?>
    <div class="form_field" id="field_<?php echo $settings["name"]; ?>">
        <label for="<?php echo $settings["name"]; ?>">
            <?php echo $settings["title"]; ?>
        </label>
        <div class="multicheck">
            <?php
            foreach ($settings['options'] as $key => $option) {
                $value = get_settings_value($settings["name"] . '_' . $key) != "" ? get_settings_value($settings["name"] . '_' . $key) : $settings['default'][$key];
                $of_key_string = $settings["name"] . '_' . $key;
                echo '<input type="hidden" name="' . $of_key_string . '" value="0" />';
                echo '<input type="checkbox" class="checkbox of-input" name="' . $of_key_string . '" value="1" ' . checked($value, 1, false) . ' /><label for="' . $of_key_string . '">' . $option . '</label>';
            }
            ?>
        </div>
        <small>
            <?php echo $settings["description"]; ?>
        </small>
        <div class="clear"></div>
    </div>
<?php } ?>
<?php

function form_field_textarea($settings) {
    $settings["default"] = isset($settings["default"]) ? $settings["default"] : "";
    $value = option_value($settings["name"]) !== false ? get_settings_value($settings["name"]) : $settings['default'];
    ?>
    <div class="form_field" id="field_<?php echo $settings["name"]; ?>">
        <label for="<?php echo $settings["name"]; ?>">
            <?php echo $settings["title"]; ?>
        </label>
        <textarea name="<?php echo $settings["name"]; ?>"><?php echo stripslashes($value); ?></textarea>
        <small>
            <?php echo $settings["description"]; ?>
        </small>
        <div class="clear"></div>
    </div>
<?php } ?>
<?php

function form_field_textinput($settings) {
    $settings["default"] = isset($settings["default"]) ? $settings["default"] : "";
    $value = option_value($settings["name"]) !== false ? get_settings_value($settings["name"]) : $settings['default'];
    ?>
    <div class="form_field" id="field_<?php echo $settings["name"]; ?>">
        <label for="<?php echo $settings["name"]; ?>">
            <?php echo $settings["title"]; ?>
        </label>
        <input type="text" name="<?php echo $settings["name"]; ?>" value="<?php echo $value; ?>" />
        <small>
            <?php echo $settings['description']; ?>
        </small>
        <div class="clear"></div>
    </div>
<?php } ?>
<?php

function form_field_images($settings) {
    $settings["default"] = isset($settings["default"]) ? $settings["default"] : "";
    $value = option_value($settings["name"]) !== false ? get_settings_value($settings["name"]) : $settings["default"];
    ?>
    <div class="form_field" id="field_<?php echo $settings["name"]; ?>">
        <label for="<?php echo $settings["name"]; ?>">
            <?php echo $settings["title"]; ?>
        </label>
        <div class="predefined_schema">
            <ul class="schema_items">
                <?php
                foreach ($settings['options'] as $key => $layout) {
                    echo "<li>";
                    $active = $value == $key ? "class='active'" : "";
                    echo "<img src='" . $layout . "' data-value='" . $key . "' " . $active . " alt=''/>";
                    echo "</li>";
                }
                ?>
            </ul>
            <input type="hidden" name="<?php echo $settings["name"]; ?>" value="<?php echo $value; ?>" />
        </div>
        <small>
            <?php echo $settings['description']; ?>
        </small>
        <div class="clear"></div>
    </div>
<?php } ?>
<?php

function form_field_colorpicker($settings) {
    $settings["default"] = isset($settings["default"]) ? $settings["default"] : "";
    $value = option_value($settings["name"]) !== false ? get_settings_value($settings["name"]) : $settings["default"];
    ?>
    <div class="form_field" id="field_<?php echo $settings["name"]; ?>">
        <label for="<?php echo $settings["name"]; ?>">
            <?php echo $settings["title"]; ?>
        </label>
        <div class="color_selector">
            <div class="color_picker"><div style="background-color: <?php echo $value; ?>;" class="color_picker_inner"></div></div>
            <input type="text" class="color_picker_value" id="<?php echo $settings["name"]; ?>" name="<?php echo $settings["name"]; ?>" value="<?php echo $value; ?>" />
            <div class="clear"></div>
        </div>
        <small>
            <?php echo $settings["description"]; ?>
        </small>
        <div class="clear"></div>
    </div>
<?php } ?>
<?php

function form_field_background($settings) {
    $color = option_value($settings["name"]."_color") !== false ? (get_settings_value($settings["name"]."_color")) : $settings["default"]["color"];
    $image = option_value($settings["name"]."_image") !== false ? (get_settings_value($settings["name"]."_image")) : $settings["default"]["image"];
    $repeat = option_value($settings["name"]."_repeat") !== false ? (get_settings_value($settings["name"]."_repeat")) : $settings["default"]["repeat"];
    $position = option_value($settings["name"]."_position") !== false ? (get_settings_value($settings["name"]."_position")) : $settings["default"]["position"];
    $attachment = option_value($settings["name"]."_attachment") !== false ? (get_settings_value($settings["name"]."_attachment")) : $settings["default"]["attachment"];
    ?>
    <div class="form_field" id="field_<?php echo $settings["name"]; ?>">
        <label for="<?php echo $settings["name"]; ?>">
            <?php echo $settings["title"]; ?>
        </label>
        <div class="browse_input" style="margin-bottom:20px;">
            <div class="preview" style="<?php echo $image != "" ? "" : "display: none"; ?>">
                <img src="<?php echo $image; ?>" id="background_img" />
            </div>
            <input type="text" class="browse_inputfield" id="<?php echo $settings["name"]."_image"; ?>" name="<?php echo $settings["name"]."_image"; ?>" value="<?php echo $image; ?>" />
            <a href="javascript:;" class="theme_button green form_field_browse_button" id="browse_header_logo"><?php _e('Browse', 'themeton'); ?></a>
        </div>
        <small>
            <?php _e('background image', 'themeton');?>
        </small>
        <div class="clear"></div>
        <div class="color_selector">
            <div class="color_picker"><div style="background-color: <?php echo $color; ?>;" class="color_picker_inner"></div></div>
            <input type="text" class="color_picker_value" id="<?php echo $settings["name"]."_color"; ?>" name="<?php echo $settings["name"]."_color"; ?>" value="<?php echo $color; ?>" />            
            <div class="clear"></div>
        </div>
        <small>
            <?php _e('background color', 'themeton');?>
        </small>
        <div class="clear"></div>
        <div class="select_repeat add_item_medium">
            <select name="<?php echo $settings["name"]."_repeat"; ?>" data-value="<?php echo $repeat; ?>">
                <?php 
                $repeats = array("no-repeat"=>"No repeat","repeat"=>"Repeat","repeat-x"=>"Repeat X","repeat-y"=>"Repeat Y");
                foreach ($repeats as $key => $value) {
                    echo '<option value="' . $key . '">' . $value . '</option>';
                }
                ?>
            </select>
        </div>
        <small>
            <?php _e('background repeat', 'themeton');?>
        </small>
        <div class="clear"></div>
        <div class="select_position add_item_medium">
            <select name="<?php echo $settings["name"]."_position"; ?>" data-value="<?php echo $position; ?>">
                <?php 
                $repeats = array("left top"=>"Left Top","left center"=>"Left Center","left bottom"=>"Left Bottom","right top"=>"Right Top","right center"=>"Right Center",
                    "right bottom"=>"Right Bottom","center top"=>"Center Top","center center"=>"Center Center","center bottom"=>"Center Bottom");
                foreach ($repeats as $key => $value) {
                    echo '<option value="' . $key . '">' . $value . '</option>';
                }
                ?>
            </select>
        </div>
        <small>
            <?php _e('background position', 'themeton');?>
        </small>
        <div class="clear"></div>
        <div class="select_attachment add_item_medium">
            <select name="<?php echo $settings["name"]."_attachment"; ?>" data-value="<?php echo $attachment; ?>">
                <?php 
                $repeats = array("scroll"=>"Scroll","fixed"=>"Fixed");
                foreach ($repeats as $key => $value) {
                    echo '<option value="' . $key . '">' . $value . '</option>';
                }
                ?>
            </select>
        </div>
        <small>
            <?php _e('background attachment', 'themeton');?>
        </small>
        <div class="clear"></div>
    </div>
<?php } ?>
<?php

function form_field_slider($settings) {
    ?>
    <div class="form_field" id="field_<?php echo $settings["name"]; ?>">
        <label>
            <?php echo $settings["title"]; ?>
        </label>
        <div class="range_slider">
            <span id="<?php echo $settings["name"]; ?>" class="rslider"></span>
            <input type="text" name="<?php echo $settings["name"] ?>" class="range_slider_value" value="<?php echo get_settings_value($settings["name"]) != "" ? get_settings_value($settings["name"]) : $settings['options'][3]; ?>" />
            <input type="hidden" class="range_slider_hidden_value" />
            <div class="clear"></div>
        </div>
        <small>
            <?php echo $settings['description']; ?>
        </small>
        <div class="clear"></div>
        <script>
            jQuery("#<?php echo $settings["name"] ?>").slider({
                min: <?php echo $settings['options'][0]; ?>, 
                max: <?php echo $settings['options'][1]; ?>, 
                value: <?php echo get_settings_value($settings["name"]) != "" ? get_settings_value($settings["name"]) : $settings['options'][3]; ?>, 
                step: <?php echo $settings['options'][2]; ?>
            });
        </script>
    </div>
<?php } ?>
<?php

function form_field_select($settings) {
    $settings["default"] = isset($settings["default"]) ? $settings["default"] : "";
    $value = option_value($settings["name"]) !== false ? get_settings_value($settings["name"]) : $settings["default"];
    ?>
    <div class="form_field" id="field_<?php echo $settings["name"]; ?>">
        <label for="<?php echo $settings["name"]; ?>">
            <?php echo $settings["title"]; ?>
        </label>  
        <div class="add_item">
            <select name="<?php echo $settings["name"]; ?>" data-value="<?php echo $value; ?>">
                <?php
                foreach ($settings["options"] as $key => $value) {
                    echo '<option value="' . $key . '">' . $value . '</option>';
                }
                ?>
            </select> 
        </div>
        <small>
            <?php echo $settings["description"]; ?>
        </small>

        <div class="clear"></div>
    </div>
<?php } ?>
<?php

function form_field_googlefonts($settings) {    
    $settings["default"] = isset($settings["default"]) ? $settings["default"] : "";
    $value = option_value($settings["name"]) !== false ? get_settings_value($settings["name"]) : $settings["default"];
    ?>
    <div class="form_field" id="field_<?php echo $settings["name"]; ?>">
        <label for="<?php echo $settings["name"]; ?>">
            <?php echo $settings["title"]; ?>
        </label>  
        <div class="add_item_medium">
            <select name="<?php echo $settings["name"]; ?>" data-value="<?php echo $value; ?>">
                <?php
                foreach ($settings["options"] as $key => $value) {
                    echo '<option value="' . $key . '">' . $value . '</option>';
                }
                ?>
            </select> 
        </div>
        <div class="google-font-live" id="google-font-live" style="font-family: '<?php echo $value; ?>'">Quick brown fox jumps over the lazy dog</div>

        <div class="clear"></div>
    </div>
<?php } ?>