jQuery(function(){
    "use strict";
    jQuery(window).scroll(function(){
        if (jQuery(this).scrollTop() > 50) {
            jQuery('.gotop').fadeIn();
        } else {
            jQuery('.gotop').fadeOut();
        }
    });
    jQuery('.gotop').click(function(){
        jQuery("html, body").animate({ scrollTop: 0 }, 500);
        return false;
    });
    
    //	Mobile Menu
    var $boxed=jQuery('#header').closest('.wrapper').hasClass('wrapper')?true:false;
    var $mobileMenu    =jQuery('#menu').clone().attr('id','tt-mobile-menu').addClass('hidden-desktop').removeClass('visible-desktop').hide();
    var $mobileDetector=$boxed?jQuery('#header').closest('.wrapper'):jQuery('#header');
    $mobileMenu = $boxed?jQuery('<div class="wrapper" />').html($mobileMenu):$mobileMenu;
    $mobileMenu.insertAfter($mobileDetector);
    jQuery('#menu').parent().append('<a href="#" class="show-mobile-menu hidden-desktop"></a>');
    jQuery('#tt-mobile-menu').children('ul').addClass('sub-menu');
    jQuery('#tt-mobile-menu ul.children').addClass('sub-menu');
    jQuery('#tt-mobile-menu ul.sub-menu').each(function(){jQuery(this).parent('li').addClass('has-children');});
    jQuery('.has-children>a').click(function(e){
        e.preventDefault();
        var $this = jQuery(this).closest('.has-children');
        $this.siblings('li.tt-open').removeClass('tt-open').children('.sub-menu').slideUp('fast');
        $this.toggleClass('tt-open');
        if($this.hasClass('tt-open')){
            $this.children('.sub-menu').slideDown('fast');
        }else{
            $this.children('.sub-menu').slideUp('fast');
        }
        return false;
    });
    jQuery('a.show-mobile-menu').click(function(e){e.preventDefault();jQuery('#tt-mobile-menu>ul').slideToggle('fast');});
    
    //	Menu 
    jQuery('#menu ul').supersubs({
        minWidth: 12,
        maxWidth: 27,
        extraWidth: 0 // set to 1 if lines turn over
    }).superfish({
        delay: 200,
        animation: {
            opacity:'show', 
            height:'show'
        },
        speed: 'fast',
        autoArrows: false,
        dropShadows: false
    });
    
    
    
    // Show Portfolio Filter
    jQuery('ul.filters').each(function(){
            var $filter = jQuery(this);
            $filter.closest('.tt-element').find("article.portfolio-item").each(function(){
                var $currentArticle = jQuery(this);
                if($filter.html()){
                    $filter.find('> li.hide').each(function(){
                        var $currentFilterClass=jQuery(this).children('a').attr('data-option-value').replace('.','');
                        if($currentArticle.hasClass($currentFilterClass)){jQuery(this).removeClass('hide');}
                    });
                }
            });
    });

   
    //accordion
    jQuery(".tt-accordion").each(function(){
        jQuery(this).find(".accordion-title").not(".current").next(".accordion-content").hide();
        var $self = jQuery(this);
        jQuery(this).find('.accordion-title').click(function(e){
            e.preventDefault();
            $self.find('.accordion-title').not(this).removeClass('current');
            jQuery(this).toggleClass('current');
            $self.find('.accordion-title').each(function(){
                if(jQuery(this).hasClass('current')){
                    jQuery(this).find('.ui-icon').addClass('ui-icon-triangle-1-s').removeClass('ui-icon-triangle-1-e');
                    jQuery(this).next('.accordion-content').slideDown('fast');
                }else{
                    jQuery(this).find('.ui-icon').removeClass('ui-icon-triangle-1-s').addClass('ui-icon-triangle-1-e');
                    jQuery(this).next('.accordion-content').slideUp('fast');
                }
            });
        });
    });


    //tab
    jQuery(".tt-shortcode>.tt-tabs>li")               .each(function(){jQuery(this).appendTo(jQuery(this).closest('.tt-tabs').find('ul.tab-header')  );});
    jQuery(".tt-shortcode>.tt-tabs>.tab-content-item").each(function(){jQuery(this).appendTo(jQuery(this).closest('.tt-tabs').find('div.tab-content'));});
    jQuery(".tt-tabs").each(function(){
        var $this = jQuery(this);
        $this.find(".tab-header li a").each(function(index){
            if( index===0 ){
                jQuery(this).addClass("active").closest('li').addClass("active");
            }
        });
        $this.find(".tab-content-item").each(function(index){
            if( index === 0 ){
                jQuery(this).fadeIn('fast');
            }
            else{
                jQuery(this).fadeOut('fast');
            }
        });
        $this.find(".tab-header li a").click(function(){
            $this.find(".tab-header li a").removeClass("active").closest('li').removeClass("active");
            jQuery(this).addClass("active").closest('li').addClass("active");
            var indexEl = $this.find(".tab-header li a").index(this);
            $this.find('.tab-content-item').stop().hide();
            $this.find('.tab-content-item').each(function(index){
                if(indexEl===index){
                    jQuery(this).show();
                }
            });
        });
    });
    
    
    // Toggle
    jQuery(".tt-toggle").not(".tt-toggle-opened").find(".tt-toggle-inner").hide();
    jQuery(".tt-toggle").each( function () {
        var $this=jQuery(this);
        $this.find('.tt-toggle-title').click(function(e){
            e.preventDefault();
            $this.toggleClass('tt-toggle-opened');
            if($this.hasClass('tt-toggle-opened')){
                $this.find('.ui-icon').addClass('ui-icon-triangle-1-s').removeClass('ui-icon-triangle-1-e');
                $this.find('.tt-toggle-inner').stop().slideDown('fast');
            }else{
                $this.find('.ui-icon').addClass('ui-icon-triangle-1-e').removeClass('ui-icon-triangle-1-s');
                $this.find('.tt-toggle-inner').stop().slideUp('fast');
            }
        });
    });
    
    // JPlayer    
    jQuery('.jp-jplayer-audio').each(function(){
        jQuery(this).jPlayer({
            ready: function () {
                jQuery(this).jPlayer("setMedia", {
                    mp3: jQuery(this).attr('src')
                });
            },
            play: function() { // To avoid both jPlayers playing together.
                jQuery(this).jPlayer("pauseOthers");
            },
            wmode:"window",
            swfPath: "",
            cssSelectorAncestor: "#jp_interface_"+jQuery(this).attr('pid'),
            supplied: "mp3"
        });
    });
    
    // Hover
    if(!(jQuery.browser.msie && parseInt(jQuery.browser.version, 10) < 6)){
        // IE sucks at fading PNG's with gradients so just use show hide
        // make sure it's not visible to start
        jQuery('.hover-content').each(function(){
            var overImg = jQuery(this).find('.image-overlay');
            jQuery(this).hover(function(){
                overImg.stop().fadeIn('fast');
            },function(){
                overImg.stop().fadeOut('fast');
            }); 
        });
    }
    
    // PrettyPhoto
    jQuery("a[rel^='prettyPhoto']").prettyPhoto({
        deeplinking:false,
		social_tools:""
    });
    
    // YouTube vMode Fix
    jQuery("iframe").each(function(){
        var ifr_source = jQuery(this).attr('src');
        var pos = ifr_source.indexOf("youtube.com");
        if(pos > -1) {
            var wmode = "?autohide=1&wmode=opaque";
            jQuery(this).attr('src',ifr_source+wmode);
        }
    });
    
    //Remove null <p>
    jQuery("p").each(function(){var $html=jQuery(this).html().replace(/\n/g,"").replace(/ /g,"");if($html===''&&$html===''){jQuery(this).remove();}});
});

jQuery(window).load(function(){
    "use strict";
    var tweet = jQuery('.twitter-tweet-rendered');
    tweet.animate({"opacity": 1});
    
    
    // Isotop
    var $isotopeBlog =jQuery('.tt-blog > .row');
    $isotopeBlog.isotope({
        itemSelector : 'article.six'
    });
    var $container = jQuery('.isotope-container');
    $container.isotope({
        itemSelector : 'article.portfolio',
        transformsEnabled: true
    });
    
    
    
    // Filter
    jQuery('ul.filters').each(function(){
            var $optionSets = jQuery(this),
            $optionLinks = $optionSets.find('a');
            $optionLinks.click(function(){
                var $container2 = jQuery(this).closest('.tt-element').find('.isotope-container');
                var $this = jQuery(this);
                // don't proceed if already selected
                if ( $this.hasClass('selected')) {
                    return false;
                }
                $optionSets.find('.selected').removeClass('selected');
                $this.addClass('selected');
                var options = {},
                key = $optionSets.attr('data-option-key'),
                value = $this.attr('data-option-value');
                value = value === 'false' ? false : value;
                options[ key ] = value;
                $container2.isotope( options );
                return false;
            });    
    });    

    
    jQuery(".tt-post-carousel").each(function(){
        var $prev = jQuery(this).find(".carousel-prev");
        var $next = jQuery(this).find(".carousel-next");
        if(!$next.hasClass("carousel-next")){
            $prev = jQuery(this).closest(".carousel-container").find(".carousel-prev");
            $next = jQuery(this).closest(".carousel-container").find(".carousel-next");
        }
        var $max = 4;
        var $width = 300;
        var $tt_current = jQuery(this);
        if(jQuery(this).hasClass("tt-image-slider")){
            $width = 0;
            $max = 1;
        } else if(jQuery(this).hasClass("entry-gallery")){
            $width = 800;
            $max = 1;
        } else if(jQuery(this).hasClass("for-client-carousel")){
            $width = 220;
            $max = 5;
        }

        jQuery(this).find("ul.slides").carouFredSel({
            auto: false,
            responsive: true,
            scroll: 1,
            width: '100%',
            heigth: 'auto',
            padding: 0,
            prev: $prev,
            next: $next,
            items: {
                width: $width,
                visible: {
                    min: 1,
                    max: $max
                }
            },
            onCreate : function () {
                setTimeout(function(){
                    var height=0;
                    jQuery('ul.slides>li',$tt_current).each(function(){if(jQuery(this).height()>height){height=jQuery(this).height();}});
                    jQuery("ul.slides",$tt_current).closest('.caroufredsel_wrapper').css('height', height+4+'px');
                },1000);
            }
        });
    });
    
    
    jQuery(".tt-testimonials").each(function(){
        var $prev = jQuery(this).find(".carousel-prev");
        var $next = jQuery(this).find(".carousel-next");
        jQuery(this).find("ul.slides").carouFredSel({
            auto: 5000,
            responsive: true,
            scroll: { fx: 'fade' },
            width: '100%',
            heigth: 'auto',
            prev: $prev,
            next: $next
        });
    });

    jQuery(window).resize(function(){        
        if($container){$container.isotope('reLayout');}
        if($isotopeBlog){$isotopeBlog.isotope('reLayout');}
        jQuery('.jp-audio-container').each(function(){
            jQuery(this).find('.jp-progress-container').width( (jQuery(this).width()-149<0)?0:(jQuery(this).width()-149) );
            jQuery(this).find('.jp-progress').width( (jQuery(this).width()-152<0)?0:(jQuery(this).width()-152) );
        });
    });
    jQuery(window).resize();
});