<?php

global $staticWidths;
$defaultWidth = !empty($staticWidths['column_service']) ? $staticWidths['column_service'] : 'size_col_full';
$cb_toolbar_title[] = "Callout";
$cb_toolbar_video[] = "http://docs.themeton.com/emerald/2013/02/callout-element/";
$cb_toolbar_width[] = $defaultWidth;
$cb_toolbar_html[] = '<div class="cb_hidden_form">
                        <div class="cb_form_wrapper">
                                <div class="tt-title-container">
                                <div class="tt-head-element add_item_medium">
                                    <input type="text" class="cbf_title" placeholder="Title of Item" />
                                </div>
                                <div class="tt-head-element add_item">
                                    <select name="cbf_title_style" class="cbf_title_style default_value">
                                        <option value="1">H1</option>
                                        <option value="2">H2</option>
                                        <option value="3">H3</option>
                                        <option value="4">H4</option>
                                        <option value="5">H5</option>
                                    </select>
                                </div> 
                                <div class="tt-head-element add_item">
                                    <div class="color_selector">
                                        <div class="color_picker" id="skin_background_color"><div style="background-color: #701010;" class="color_picker_inner"></div></div>
                                        <input type="text" class="color_picker_value" name="skin_background_color" value="#701010">
                                    </div>
                                </div>
                                <div class="tt-head-element add_item_medium">
                                    <input type="text" class="cbf_custom_class" placeholder="Custom class" />
                                </div>
                            </div>
                            
                            <div class="clear"></div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Button Text</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <input type="text" name="cbf_button_text" class="cbf_button_text"/>
                                </div>
                                <div class="tt-description">
                                    Leave empty if you wanna disable button!
                                </div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Button Link</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <input type="text" name="cbf_button_link" class="cbf_button_link"/>
                                </div>                                
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Link target</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select name="cbf_button_target" class="cbf_button_target default_value">
                                        <option value="blank">Blank</option>
                                        <option value="self">Self</option>
                                    </select>
                                </div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Button Color</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select name="cbf_button_color" class="cbf_button_color default_value">
                                        <option value="default">Default</option>
                                        <option value="red">Red</option>
                                        <option value="orange">Orange</option>
                                        <option value="blue">Blue</option>
                                        <option value="green">Green</option>
                                        <option value="pink">Pink</option>
                                        <option value="magenta">Magenta</option>
                                        <option value="yellow">Yellow</option>
                                    </select>    
                                </div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Button Size</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select name="cbf_button_size" class="cbf_button_size default_value">
                                        <option value="small">Small</option>
                                        <option value="medium">Medium</option>
                                        <option value="large">Large</option>
                                    </select>
                                </div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Button Style</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select name="cbf_button_style" class="cbf_button_style default_value">
                                        <option value="gradient">Gradient</option>
                                        <option value="flat">Flat</option>
                                    </select>
                                </div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Is button Rounded?</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select name="cbf_button_round" class="cbf_button_round default_value">
                                        <option value="yes">Yes</option>
                                        <option value="no">No</option>
                                    </select>
                                </div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Button position</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select name="cbf_button_position" class="cbf_button_position default_value">
                                        <option value="right">Right</option>
                                        <option value="left">Left</option>
                                    </select>
                                </div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Callout Text</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <textarea name="cbf_callout_text" placeholder="Please insert text of your callout." class="cbf_callout_text" rows="5" cols="27"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="cb_hidden_data">
                        <title></title>
                        <type>callout</type>
                        <size>' . $defaultWidth . '</size>
                        <title_style>3</title_style>
                        <start_row></start_row>
                        <custom_class></custom_class>
                        <color_picker_value></color_picker_value>
                        <button_text>button text</button_text>
                        <button_link>#</button_link>
                        <button_color>default</button_color>
                        <button_size>medium</button_size>
                        <button_style>flat</button_style>
                        <button_round>no</button_round>
                        <button_target>blank</button_target>
                        <button_position>right</button_position>
                        <callout_text>Please insert text of your callout.</callout_text>
                    </div>';

function cb_item_callout($item) {
    $custom_class = find_xml_value($item, 'custom_class');
    $button_text = find_xml_value($item, 'button_text');
    $atts['link'] = find_xml_value($item, 'button_link');
    $atts['type'] = find_xml_value($item, 'button_color');
    $atts['size'] = find_xml_value($item, 'button_size');
    $atts['style'] = find_xml_value($item, 'button_style');
    $atts['rounded'] = find_xml_value($item, 'button_round');
    $atts['target'] = find_xml_value($item, 'button_target');
    $position = find_xml_value($item, 'button_position') ? find_xml_value($item, 'button_position') : "right";
    $html = '<div class="' .$custom_class.' '. size_back_to_front(find_xml_value($item, 'size')) .((find_xml_value($item, 'start_row')==='true')?' start-row':''). '">';
    $html .= '<div class="tt-element">';
    if (find_xml_value($item, 'title') != "") {
        $html .= get_element_title(find_xml_value($item, 'title'), find_xml_value($item, 'title_style'), find_xml_value($item, 'color_picker_value'));
    }
    $html .= '<div class="tt-callout '.$position.'-button clearfix">';      
    $html .= '<h2 class="tt-callout-element">'.get_element_content(rawUrlDecode(find_xml_value($item, 'callout_text'))).'</h2>';
    if(!empty($button_text)) {
        $html .= shortcode_buttons($atts,$button_text);
    }
    $html .= '</div>';
    $html .= '</div>';
    $html .= '</div>';
    echo $html;
}