<?php
global $staticWidths;
$defaultWidth=!empty($staticWidths['portfolio'])?$staticWidths['portfolio']:'size_col_full';

$categories = get_terms("portfolios", 'hide_empty=0');
$select='<option value="0">'.__('All categories','themeton').'</option>';
foreach($categories as $category){$select .= '<option value="'.$category->slug.'">'.$category->name.'</option>';}

$cb_toolbar_title[] = "Portfolio";
$cb_toolbar_video[] = "http://docs.themeton.com/emerald/2013/02/portfolio-element/";
$cb_toolbar_width[] = $defaultWidth;
$cb_toolbar_html[] = '<div class="cb_hidden_form">
                        <div class="cb_form_wrapper">

                            <div class="tt-title-container">
                                <div class="tt-head-element add_item_medium">
                                    <input type="text" class="cbf_title" placeholder="Title of Item"/>
                                </div>
                                <div class="tt-head-element add_item">
                                    <select name="cbf_title_style" class="cbf_title_style default_value">
                                        <option value="1">H1</option>
                                        <option value="2">H2</option>
                                        <option value="3">H3</option>
                                        <option value="4">H4</option>
                                        <option value="5">H5</option>
                                    </select>
                                </div> 
                                <div class="tt-head-element add_item">
                                    <div class="color_selector">
                                        <div class="color_picker" id="skin_background_color"><div style="background-color: #701010;" class="color_picker_inner"></div></div>
                                        <input type="text" class="color_picker_value" name="skin_background_color"  value="#701010">
                                    </div>
                                </div>
                                <div class="tt-head-element add_item_medium">
                                    <input type="text" class="cbf_custom_class" placeholder="Custom class" />
                                </div>
                            </div>
                            
                            <div class="clear"></div>

                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Category</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select class="default_portfolio">'. $select .'</select>
                                </div>
                                <div class="tt-description">
                                    Choose Portfolio Categories.
                                </div>
                                <div class="category_list"></div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Column</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select name="cbf_block" class="cbf_block">
                                        <option value="2">2 Columns</option>
                                        <option value="3">3 Columns</option>
                                        <option value="4">4 Columns</option>
                                    </select>
                                </div>
                                <div class="tt-description">
                                    How many columns display your portfolio?
                                </div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Count</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <input type="text" class="cbf_post_count" placeholder="'.get_option('posts_per_page').'"/>
                                </div>
                                <div class="tt-description">
                                    How many portfolio will display?
                                </div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Height</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <input type="text" class="cbf_height" placeholder="Image height"/>
                                </div>
                                <div class="tt-description">
                                    If you leave this option empty this is configured by Theme option!
                                </div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Filter</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select name="cbf_filter" class="cbf_filter">
                                        <option value="1">'.__('Yes','themeton').'</option>
                                        <option value="0">'.__('No','themeton').'</option>
                                    </select>
                                </div>
                                <div class="tt-description">
                                    Filters by category
                                </div>
                            </div>
                            <div class="tt-elements-container">
                                <div class="tt-title-element title-element">
                                    <label>Pagination</label>
                                </div>
                                <div class="tt-title-element add_item_medium">
                                    <select name="cbf_pagination" class="cbf_pagination">
                                        <option value="1">'.__('Yes','themeton').'</option>
                                        <option value="0">'.__('No','themeton').'</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="cb_hidden_data">
                        <title></title>
                        <type>portfolio</type>
                        <size>'.$defaultWidth.'</size>
                        <title_style>3</title_style>
                        <start_row></start_row>
                        <custom_class></custom_class>
                        <color_picker_value></color_picker_value>
                        <category_list></category_list>
                        <height></height>
                        <pagination>1</pagination>
                        <filter>1</filter>
                        <block>4</block>
                        <post_count>'.get_option('posts_per_page').'</post_count>
                    </div>';

function cb_item_portfolio($item) {
    $custom_class = find_xml_value($item, 'custom_class');
    global $pb_options,$paged,$container;
    $filter = "";
    $tab_xml = find_xml_node($item, 'category_list');
    foreach ($tab_xml->childNodes as $node) {
        if (find_xml_value($node, 'name') != "") {
            $cats[] = find_xml_value($node, 'name');
        }
    }
    if(find_xml_value($item, 'filter')) {
        $filter.='<div class="tt-pagination align-left">';                        
        $filter.='<ul class="filters option-set clearfix post-category" data-option-key="filter">';
        $filter.='<li><a href="#filter" data-option-value="*" class="selected">'.__('All','themeton').'</a></li>';
        if(!isset($cats)) {
            $filters = get_terms( 'portfolios' ); 
        } else {
            $filters = $cats;
        }
        
        foreach ($filters as $category){
            if (isset($cats)) {
                $category = get_term_by('slug', $category, 'portfolios');
            }
            $filter.='<li class="hide"><a href="#filter" data-option-value=".category-' . $category->slug . '" title="' . $category->name . '" ' . ' class="post-category-item">' . $category->name . '</a></li>';
        }
        $filter.='</ul>';
        $filter.='</div><div class="clear"></div>';
    }
    $html_start = '<div class="' .$custom_class.' '. size_back_to_front(find_xml_value($item, 'size')) .((find_xml_value($item, 'start_row')==='true')?' start-row':''). '">';
        $html_start .= '<div class="tt-element">';
            if(find_xml_value($item, 'title') != ""){$html_start .= get_element_title(find_xml_value($item, 'title'),find_xml_value($item, 'title_style'),find_xml_value($item, 'color_picker_value'));}
            $html_start .= $filter;
            $html_start .= '<div class="tt-portfolio portfolio">';
                /* LOOP HERE */
            $html_end = '</div>';
        $html_end .= '</div>';
    $html_end .= '</div>';
    
    $pb_options['show_pagination']=(find_xml_value($item, 'pagination')!= "" && find_xml_value($item, 'pagination'));
    $pb_options['post_count']=find_xml_value($item, 'post_count')!= "" ? find_xml_value($item, 'post_count') : get_option('posts_per_page');
    $pb_options['block']=(find_xml_value($item, 'block')         != "")?find_xml_value($item, 'block')    : '2';
    $pb_options['height']=(find_xml_value($item, 'height')         != "")?find_xml_value($item, 'height')    : get_settings_value("portfolio_height");
    $pb_options['container']=!empty($container)?$container:"fullwidth";
    $pb_options['size']=find_xml_value($item, 'size')!="" ? find_xml_value($item, 'size') : "size_col_full";
    
    $query = Array(
                'post_type' => 'portfolio',
                'posts_per_page' => $pb_options['post_count'],
            );
            if($pb_options['show_pagination']){
                $query['paged'] = $paged;
            }
            if (isset($cats)) {
                $query['tax_query'] = Array(Array(
                        'taxonomy' => 'portfolios',
                        'terms' => $cats,
                        'field' => 'slug'
                    )
                );
            }
    echo $html_start;    
        query_posts($query);
        get_template_part("loop","portfolio");
        wp_reset_query();
    echo $html_end;
}