 <?php
/*
 * 	aside -  A short piece of content, typically styled without a title.
  gallery - A gallery of images.
  link - A single link to another site.
  image - A single image.
  quote - A single quotation.
  status - A short status update, similar to a Twitter status update.
  video - A single video.
  audio - A single audio file.
  chat - A chat transcript.
 */
add_theme_support('post-formats', array('video', 'audio', 'quote', 'link', 'gallery', 'status'));

add_action('admin_print_scripts', 'postformat_admin_scripts');
add_action('admin_print_styles', 'postformat_admin_styles');

function postformat_admin_scripts() {
    global $pagenow, $typenow;
    if (empty($typenow) && !empty($_GET['post'])) {
        $post = get_post($_GET['post']);
        $typenow = $post->post_type;
    }

    if (current_user_can('edit_posts') && ($pagenow == 'post-new.php' || $pagenow == 'post.php')) {
        
        if ($typenow == 'post') {
                wp_register_script('jquery-ui', get_template_directory_uri() . '/framework/resources/jquery-ui/jquery-ui.js');
                wp_register_script('jquery-drag', get_template_directory_uri() . '/framework/resources/jquery.dragsort/jquery.dragsort-0.5.1.min.js');
                wp_register_script('format-script', get_template_directory_uri() . '/framework/post-format/script.js');
                wp_enqueue_script('jquery-ui');
                wp_enqueue_script('jquery-drag');
                wp_enqueue_script('format-script');
        }
    }
}

function postformat_admin_styles() {
    global $pagenow, $typenow;
    if (empty($typenow) && !empty($_GET['post'])) {
        $post = get_post($_GET['post']);
        $typenow = $post->post_type;
    }

    if (current_user_can('edit_posts') && ($pagenow == 'post-new.php' OR $pagenow == 'post.php')) {
        
        if ($typenow == "post") {
            wp_register_style('format-style', get_template_directory_uri() . '/framework/post-format/style.css', false, '1.00', 'screen');
            wp_enqueue_style('format-style');
        }
    }
}

add_action('admin_init', 'postformat_section_add_box', 1);

function postformat_section_add_box() {
    add_meta_box(
            'cmeta_postformat', __('Post Format', 'themeton'), 'postformat_section_inner_colorbox', 'post', 'normal', 'high'
    );
}

function postformat_section_inner_colorbox() {
    global $post;
    $post_id = $post->ID;
    $settings = get_post_meta($post_id, 'themeton_post_format', true);
    if (empty($settings)) {
        $settings['audio_is_embed'] = '';
        $settings['audio_embed'] = '';
        $settings['audio_url'] = '';
        $settings['video_url'] = '';
        $settings['status_url'] = '';
        $settings['quote_author'] = '';
        $settings['quote_link'] = '';
        $settings['quote_target'] = '';
        $settings['quote_text'] = '';
        $settings['link_title'] = '';
        $settings['link_url'] = '';
        $settings['link_target'] = '';
        $settings['gallery_images'] = '';
        $settings['gallery_height'] = '';
    }


    $target = array('blank', 'self', 'parent', 'top');
    ?>
    <div id="themeton_custom_post_format">  

        <!-- Post format tab -->
        
        <div id="cf-post-format-tabs" class="cf-nav" style="display: none;">
            <ul class="clearfix">
                <?php
                $post_formats = get_theme_support('post-formats');
                $current_format = get_post_format($post->ID);
                array_unshift($post_formats[0], 'standard');
                foreach ($post_formats[0] as $format) {
                    $class = ($format == $current_format || (empty($current_format) && $format == 'standard') ? 'current' : '');
                    if ($format == 'standard') {
                        $format_title = __('Standard', 'themeton');
                        $format_id = 'post-format-0';
                    } else {
                        $format_title = get_post_format_string($format);
                        $format_id = 'post-format-' . $format;
                    }
                    echo '<li><a ' . (!empty($class) ? 'class="' . esc_attr($class) . '"' : '') . ' href="#' . esc_attr($format_id) . '"><span class="' . esc_html($format_title) . '">' . esc_html($format_title) . '</span></a></li>';
                }
                ?>
            </ul>
        </div>

        <!-- --------------------- -->




        <!-- Post format gallery -->

        <div class="themeton_format_gallery themeton_post_format">
            <div class="themeton_format_inside">
                <table class="form-table">
                    <tr>
                        <td>
                            <div class="gallery-option">
                                <a href="#" class="button insert-images theme_button format" onclick="browseMediaGallery(<?php echo $post_id; ?>)"><?php _e('Insert images', "themeton"); ?></a>
                                <img src="<?php echo get_template_directory_uri()?>/framework/resources/images/loading2.gif" style="display: none" />
                                <br/><span><?php _e("Image height", "themeton")?></span><br/>
                                <input name="gallery_images" id="gallery_images" value='<?php echo $settings['gallery_images'] ?>' type="hidden" size="30">
                                <input name="gallery_height" id="gallery_height" value='<?php echo !empty($settings['gallery_height']) ? $settings['gallery_height'] : 200;?>' type="text" size="10">
                            </div>                            
                            <div class="gallery-images">
                                <?php                                
                                if (!empty($settings['gallery_images'])) {
                                    $images = explode('""', $settings['gallery_images']);
                                    foreach ($images as $image) {
                                        if ($image != '')
                                            echo '<div class="gallery-block"><img src=\'' . $image . '\' height="100"/><div class="gallery-delete"></div></div>';
                                    }
                                }
                                ?>
                            </div>
                        </td>
                    </tr>                        
                </table>
            </div>
        </div>

        <!-- --------------------- -->




        <!-- Post format video -->

        <div class="themeton_format_video themeton_post_format">
            <div class="themeton_format_inside">
                <table class="form-table">
                    <tr id="video-format-url">
                        <th><label><?php _e('Youtube or Vimeo URL', 'themeton'); ?></label></th>
                        <td><input type="text" name="video_url" value='<?php print $settings['video_url']; ?>'/></td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- --------------------- -->




        <!-- Post format audio -->        

        <div class="themeton_format_audio themeton_post_format">
            <div class="themeton_format_inside">
                <table class="form-table">
                    <tr>
                        <th>
                            <label><?php _e('Is Audio Embedded?', 'themeton'); ?></label>
                        </th>
                        <td>
                            <input type="hidden" name="audio_is_embed" value="0"/>
                            <input name="audio_is_embed" class="yesno check-show-hide" data-show="#audio-format-embed" data-hide="#audio-format-url" type="checkbox" <?php checked($settings['audio_is_embed'], 1, true); ?> value="1">
                        </td>
                    </tr>
                    <div style="clear:both;"></div>


                    <tr id="audio-format-url">
                        <th><label><?php _e('Post format audio url here', 'themeton'); ?></label></th>
                        <td class="tt-elements">
                            <input name="audio_url" id="audio_url" value="<?php print $settings['audio_url']; ?>" type="text" size="25">

                            <input type="button" class="button theme_button format" value="upload" onclick="browseAudio('audio_url');">
                        </td>
                        <td class="tt-description">
                            <?php _e('Please upload only MP3 file, copy and paste audio url on the field. Insert into button doen\'t work, because uploader can work with only images.', 'themeton'); ?>
                        </td>
                    </tr>
                    <tr id="audio-format-embed">
                        <th><label><?php _e('Add audio embed', 'themeton'); ?></label></th>
                        <td>
                            <textarea name="audio_embed" cols="29" rows="5"><?php print $settings['audio_embed']; ?></textarea>
                        </td>
                        <td class="tt-description">
                            <?php _e('Please insert here Audio Iframe Embed code. Example: <pre>&lt;iframe width=&quot;100%&quot; height=&quot;166&quot; scrolling=&quot;no&quot; frameborder=&quot;no&quot; src=&quot;https://w.soundcloud.com/player/?url=http://api.soundcloud.com/tracks/21792829?"&gt;&lt;/iframe&gt;</pre>', 'themeton'); ?>
                        </td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- --------------------- -->




        <!-- Post format status -->

        <div class="themeton_format_status themeton_post_format">
            <div class="themeton_format_inside">
                <table class="form-table">
                    <tr id="status-format-embed">
                        <th><label><?php _e('Status URL', 'themeton'); ?></label></th>
                        <td>
                            <input type="text" name="status_url" value="<?php print $settings['status_url']; ?>" size="25">
                        </td>
                        <td class="tt-description">
                            <?php _e('Please provide here Twitter or Instagram url. Also you can put here some oEmbed links those provided for <a href="http://codex.wordpress.org/Embeds#Okay.2C_So_What_Sites_Can_I_Embed_From.3F" target="_blank">WordPress embed</a>', 'themeton'); ?>
                        </td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- --------------------- -->




        <!-- Post format quote -->

        <div class="themeton_format_quote themeton_post_format">
            <div class="themeton_format_inside">
                <table class="form-table">
                    <tr>
                        <th><label><?php _e('Quote author', 'themeton'); ?></label></th>
                        <td>
                            <input name="quote_author" value="<?php print $settings['quote_author']; ?>" type="text" size="25">
                        </td>
                    </tr>
                    <tr>
                        <th><label><?php _e('Link', 'themeton'); ?></label></th>
                        <td>
                            <input name="quote_link" value="<?php print $settings['quote_link']; ?>" type="text" size="25">
                        </td>
                    </tr>
                    <tr>
                        <th><label><?php _e('Link target', 'themeton'); ?></label></th>
                        <td class="add_item">
                            <select name="quote_target">
                                <?php foreach ($target as $tar) {
                                    ?>
                                    <option value="<?php echo $tar; ?>" <?php
                            if ($settings['quote_target'] == $tar)
                                echo "selected=selected";
                                    ?>><?php echo $tar; ?></option>
                                        <?php } ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th><label><?php _e('Quote text', 'themeton'); ?></label></th>
                        <td>
                            <textarea name="quote_text" rows="4" cols="29" ><?php print $settings['quote_text']; ?></textarea>
                        </td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- --------------------- -->




        <!-- Post format link -->

        <div class="themeton_format_link themeton_post_format">
            <div class="themeton_format_inside">
                <table class="form-table">
                    <tr>
                        <th><label><?php _e('Link name', 'themeton'); ?></label></th>
                        <td>
                            <input name="link_title" value="<?php print $settings['link_title']; ?>" type="text" size="25">
                        </td>
                    </tr>
                    <tr>
                        <th><label><?php _e('Link URL', 'themeton'); ?></label></th>
                        <td>
                            <input name="link_url" value="<?php print $settings['link_url']; ?>" type="text" size="25">
                        </td>
                    </tr>
                    <tr>
                        <th><label><?php _e('Link target', 'themeton'); ?></label></th>
                        <td class="add_item">
                            <select name="link_target">
                                <?php foreach ($target as $tar) {
                                    ?>
                                    <option value="<?php echo $tar; ?>" <?php
                            if ($settings['link_target'] == $tar)
                                echo "selected=selected";
                                    ?>><?php echo $tar; ?></option>
                                        <?php } ?>
                            </select>
                        </td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- --------------------- -->
    </div>
    <?php
}

add_action('save_post', 'postformat_section_save_postdata');

function postformat_section_save_postdata($post_id) {
    global $pagenow;

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return $post_id;

    if (!current_user_can('edit_post', $post_id))
        return $post_id;

    if (isset($_POST['post_type']) && 'post' == $_POST['post_type'] && ($pagenow == 'post-new.php' OR $pagenow == 'post.php')) {


        $field_name = array();

        $field_name['audio_is_embed'] = $_POST['audio_is_embed'];
        $field_name['audio_embed'] = $_POST['audio_embed'];
        $field_name['audio_url'] = $_POST['audio_url'];

        $field_name['video_url'] = $_POST['video_url'];

        $field_name['gallery_images'] = $_POST['gallery_images'];
        $field_name['gallery_height'] = $_POST['gallery_height'];

        $field_name['status_url'] = $_POST['status_url'];

        $field_name['quote_author'] = $_POST['quote_author'];
        $field_name['quote_link'] = $_POST['quote_link'];
        $field_name['quote_target'] = $_POST['quote_target'];
        $field_name['quote_text'] = $_POST['quote_text'];

        $field_name['link_title'] = $_POST['link_title'];
        $field_name['link_url'] = $_POST['link_url'];
        $field_name['link_target'] = $_POST['link_target'];

        if (get_post_meta($post_id, 'themeton_post_format') == '') {
            add_post_meta($post_id, 'themeton_post_format', $field_name, true);
        } else {
            update_post_meta($post_id, 'themeton_post_format', $field_name);
        }
    }
}

function getEmbedVideoType($embed, $type = '') {
    preg_match('/src=\"(.*?)\"/si', $embed, $filteredContent);
    $url = $filteredContent[1];
    $youtube = strpos($url, 'youtube.com');
    $youtu = strpos($url, 'youtu.be');
    $vimeo = strpos($url, 'vimeo.com');


    $video_id = '';
    $spliturl = split("/", $url);
    $video_id = $spliturl[count($spliturl) - 1];
    if ($video_id == "") {
        $video_id = $spliturl[count($spliturl) - 2];
    }

    if ($type == 'id') {
        return $video_id;
    } else {
        if ($youtube || $youtu) {
            return 'youtube';
        } else if ($vimeo) {
            return 'vimeo';
        }
    }

    return 'video';
}

function getEmbedVideoImg($embed) {

    preg_match('/src=\"(.*?)\"/si', $embed, $filteredContent);
    
    if(!empty($filteredContent[1])) {
        $url = $filteredContent[1];
        $youtube = strpos($url, 'youtube.com');
        $youtu = strpos($url, 'youtu.be');
        $vimeo = strpos($url, 'vimeo.com');

        $video_id = '';
        $spliturl = split("/", $url);
        $video_id = $spliturl[count($spliturl) - 1];
        if ($video_id == "") {
            $video_id = $spliturl[count($spliturl) - 2];
        }
    } else {
        $url = $embed;
        $youtube = strpos($url, 'youtube.com');
        $youtu = strpos($url, 'youtu.be');
        $vimeo = strpos($url, 'vimeo.com');

        $video_id = '';
        $spliturl = split("/", $url);
        $video_id = $spliturl[count($spliturl) - 1];
        if ($video_id == "") {
            $video_id = $spliturl[count($spliturl) - 2];            
        } else {
            $spliturl = split("=", $url);
            $video_id = $spliturl[count($spliturl) - 1];
        }
    }

    $video_img = '';

    if ($youtube || $youtu) {
        $video_img = '<img src="http://img.youtube.com/vi/' . $video_id . '/0.jpg" class="post_format_youtube" />';
    } else if ($vimeo) {
        $json = @file_get_contents("http://vimeo.com/api/oembed.json?url=http%3A//vimeo.com/" . $video_id, true);
        if (strpos($http_response_header[0], "200")) {
            $decode = json_decode($json, true);
            $video_thumb = $decode['thumbnail_url'];
            $video_thumb = str_replace("_1280", "_640", $video_thumb);
            $video_img = '<img src="' . $video_thumb . '" class="post_format_vimeo" />';
        }
        if (strlen($video_img) < 1) {
            $video_img = "";
        }
    }

    return $video_img;
}
?>