<?php
    add_action('admin_print_scripts', 'postsettings_admin_scripts');
    add_action('admin_print_styles', 'postsettings_admin_styles');
    function postsettings_admin_scripts(){
        global $pagenow;

        if (current_user_can('edit_posts') && ($pagenow == 'post-new.php' || $pagenow == 'post.php')) {
            wp_register_script('colorpicker1', get_template_directory_uri().'/framework/resources/colorpicker/colorpicker.js');
            wp_register_script('iphone-checkbox', get_template_directory_uri().'/framework/resources/iphone-check/iphone-style-checkboxes.js');
            wp_register_script('iphone-tri-checkbox', get_template_directory_uri().'/framework/resources/iphone-check/iphone-style-tri-toggle.js');
            wp_register_script('post-script', get_template_directory_uri().'/framework/post-type/script.js');        

            wp_enqueue_script('colorpicker1');        
            wp_enqueue_script('iphone-checkbox');
            wp_enqueue_script('iphone-tri-checkbox');
            wp_enqueue_script('post-script');
        }
    }
    function postsettings_admin_styles(){
        global $pagenow;

        if (current_user_can('edit_posts') && ($pagenow == 'post-new.php' || $pagenow == 'post.php')) {
            wp_register_style('colorpicker1', get_template_directory_uri().'/framework/resources/colorpicker/css/colorpicker.css', false, '1.00', 'screen');
            wp_register_style('iphone-checkbox', get_template_directory_uri().'/framework/resources/iphone-check/style.css', false, '1.00', 'screen');            
            wp_register_style('jquery-ui', get_template_directory_uri().'/framework/resources/jquery-ui/jquery-ui.css', false, '1.00', 'screen');
            wp_register_style('post-style', get_template_directory_uri().'/framework/post-type/style.css', false, '1.00', 'screen');
            wp_register_style('pagebuilder', get_template_directory_uri().'/framework/pagebuilder/style.css', false, '1.00', 'screen');
            
            wp_enqueue_style('jquery-ui');
            wp_enqueue_style('colorpicker1');
            wp_enqueue_style('iphone-checkbox');
            wp_enqueue_style('post-style');
            wp_enqueue_style('pagebuilder');
        }
    }

    include(get_template_directory().'/framework/post-type/fields.php');
    include(get_template_directory().'/framework/post-type/post.php');
    include(get_template_directory().'/framework/post-type/page.php');
    include(get_template_directory().'/framework/post-type/portfolio.php');
    include(get_template_directory().'/framework/post-type/pricetable.php');
    include(get_template_directory().'/framework/post-type/team.php');
    include(get_template_directory().'/framework/post-type/testimonial.php');
    include(get_template_directory().'/framework/post-type/client.php');
    


add_action('save_post', 'savePostMeta');

function savePostMeta($post_id) {
    global $pagenow, $post_settings, $page_settings, $portfolio_settings, $price_settings, $testimonial_settings, $team_settings, $client_settings;

    $meta = 'themeton_'.THEMENAME.'_options';
    
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return $post_id;
    if (!current_user_can('edit_post', $post_id))
        return $post_id;
    
    if (isset($_POST['post_type']) && ($pagenow == 'post-new.php' OR $pagenow == 'post.php')) {                
        
        if($_POST['post_type']=='post')
            $metaboxes = $post_settings;
        elseif($_POST['post_type']=='page')
            $metaboxes = $page_settings;
        elseif($_POST['post_type']=='portfolio')
            $metaboxes = $portfolio_settings;
        elseif($_POST['post_type']=='team')
            $metaboxes = $team_settings;
        elseif($_POST['post_type']=='testimonial')
            $metaboxes = $testimonial_settings; 
        elseif($_POST['post_type']=='price')
            $metaboxes = $price_settings; 
        elseif($_POST['post_type']=='client')
            $metaboxes = $client_settings; 
                
        if(!empty($metaboxes)) {
            $myMeta = array();
            
            foreach ($metaboxes as $key => $settings) {
                $myMeta[$key] = isset($_POST[$key]) ? $_POST[$key] : "";
            }
        
            if (get_post_meta($post_id, $meta) == '') {
                add_post_meta($post_id, $meta, $myMeta, true);
            } else {
                update_post_meta($post_id, $meta, $myMeta);
            }         
            
        }
    }
}
?>