<?php
$testimonial_settings = Array(
    'name' => Array('type' => 'text', 'description' => __('', 'themeton'), 'title' => __('Name', 'themeton')),
    'position' => Array('type' => 'text', 'description' => __('', 'themeton'), 'title' => __('Position', 'themeton')),
    'company' => Array('type' => 'text', 'description' => __('', 'themeton'), 'title' => __('Company', 'themeton')),
    'link' => Array('type' => 'text', 'description' => __('', 'themeton'), 'title' => __('Company Link', 'themeton')),
);

add_action('init', 'testimonial_register');

function testimonial_register() {
    
    $labels = array(
        'name' => __('Testimonial', 'themeton'),
        'singular_name' => __('Testimonial', 'themeton'),
        'add_new' => __('Add New', 'themeton'),
        'add_new_item' => __('Add New Testimonial', 'themeton'),
        'edit_item' => __('Edit Testimonial', 'themeton'),
        'new_item' => __('New Testimonial', 'themeton'),
        'all_items' => __('All Testimonials', 'themeton'),
        'view_item' => __('View Testimonial', 'themeton'),
        'search_items' => __('Search Testimonials', 'themeton'),
        'not_found' =>  __('No testimonial found', 'themeton'),
        'not_found_in_trash' => __('No testimonial found in Trash', 'themeton'),
        'menu_name' => __('Testimonials', 'themeton')
    );
    
    $args = array(
        'labels' => $labels,
        'public' => true,
        '_builtin' => false,
        'capability_type' => 'post',
        'menu_icon' => get_template_directory_uri() . '/framework/resources/images/testimonial.png',
        'hierarchical' => false,
        'rewrite' => array( 'slug' => 'testimonial'),
        'supports' => array('title', 'editor', 'thumbnail')
    );

    register_post_type('testimonial', $args);
    flush_rewrite_rules();
}

register_taxonomy("testimonials", array("testimonial"), array("hierarchical" => true, "label" => __("Categories", "themeton"), "singular_label" => __("Testimonial Category", "themeton"), "rewrite" => true));


add_action('admin_init', 'testimonial_settings_custom_box');

function testimonial_settings_custom_box() {
    global $testimonial_settings;
    add_meta_box(
        'testimonial_meta_settings',
        __( 'Testimonial settings', 'themeton' ), 
        'testimonial_settings',
        'testimonial',
        'normal',
        'high',
        $testimonial_settings
    );
}

function testimonial_edit_columns($columns){	
        $columns = array(
            "cb" => "<input type=\"checkbox\" />",
            "thumbnail" => __("Image", "themeton"),
            "title" => __("Name", "themeton"),
            "testimonial" => __("Categories", "themeton"),
            "date" => __("Date", "themeton"),
        );
        return $columns;
}
add_filter('manage_edit-testimonial_columns', 'testimonial_edit_columns');


function testimonial_settings($post, $metabox) {
    global $post; 
    $options = get_post_meta($post->ID, 'themeton_'.THEMENAME.'_options', true);?>
        <div class="additional_panel_container">      
            <div class="additional_panel">
                <table>
                    <?php
                    foreach ($metabox['args'] as $type=>$settings) {
                        $settings['name'] = $type;
                        $settings['value'] = isset($options[$settings['name']]) ? $options[$settings['name']] : (isset($settings['default']) ? $settings['default'] : '');
                        call_user_func('settings_'.$settings['type'], $settings);
                    }
                    ?>            
                </table>
            </div>
        </div>
<?php 
}
?>