<?php

include(file_require(get_template_directory() . '/framework/settings/templates/general/google-font.php'));
global $fields;
$google_fonts = get_google_webfonts();

$google_webfonts_array["'Helvetica Neue', Helvetica, Arial, sans-serif"] = "Default";
foreach ($google_fonts as $font) {
    $google_webfonts_array[$font['family']] = $font['family'];
}

$fields['font_options'] = Array(
    'head_felement' => Array(
        'type' => 'googlefonts',
        'title' => __('Heading Elements font', 'themeton'),
        'description' => '',
        'default' => 'Open Sans',
        'options' => $google_webfonts_array),
    'body_felement' => Array(
        'type' => 'googlefonts',
        'title' => __('Body Elements font', 'themeton'),
        'description' => '',
        'default' => 'Open Sans',
        'options' => $google_webfonts_array),
    'h1_fsize' => Array(
        'type' => 'slider',
        'title' => __('H1 Size', 'themeton'),
        'options' => array(1, 50, 1, 24),
        'description' => __('Choose the H1 font size.', 'themeton')),
    'h2_fsize' => Array(
        'type' => 'slider',
        'title' => __('H2 Size', 'themeton'),
        'options' => array(1, 50, 1, 20),
        'description' => __('Choose the H2 font size.', 'themeton')),
    'h3_fsize' => Array(
        'type' => 'slider',
        'title' => __('H3 Size', 'themeton'),
        'options' => array(1, 50, 1, 16),
        'description' => __('Choose the H3 font size.', 'themeton')),
    'h4_fsize' => Array(
        'type' => 'slider',
        'title' => __('H4 Size', 'themeton'),
        'options' => array(1, 50, 1, 14),
        'description' => __('Choose the H4 font size.', 'themeton')),
    'h5_fsize' => Array(
        'type' => 'slider',
        'title' => __('H5 Size', 'themeton'),
        'options' => array(1, 50, 1, 12),
        'description' => __('Choose the H5 font size.', 'themeton')),
    'h6_fsize' => Array(
        'type' => 'slider',
        'title' => __('H6 Size', 'themeton'),
        'options' => array(1, 50, 1, 10),
        'description' => __('Choose the H6 font size.', 'themeton')),
);
foreach ($fields['font_options'] as $type => $field) {
    $field["name"] = $type;
    if(function_exists('form_field_'.$field["type"]))
        call_user_func('form_field_' . $field["type"], $field);
}
?>