<?php
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class sociallinkswidget extends WP_Widget {

    function sociallinkswidget() {
        $widget_ops = array('classname' => 'sociallinkswidget', 'description' => 'Displays your social profile.');

        parent::WP_Widget(false, 'Themeton Social', $widget_ops);
    }

    function widget($args, $instance) {
        extract($args);
        $title = apply_filters('widget_title', $instance['title']);
        echo $before_widget;
        if ($title)
            echo $before_title . $title . $after_title;
        echo "<ul class='sociallinkswidget clearfix'>";
        foreach (getArraySocial() as $social) {
            if (get_settings_value('social_' . $social['name']) != "") {
                $placeholder = ucwords($social['name']) . ' Username';
                $url = ($social['link']);
                $urler = get_settings_value('social_' . $social['name']);
                $url = str_replace('*', $urler, $url);
                if ($social['name'] == "googleplus") {
                    $placeholder = "Google+ Account ID";
                }
                if ($social['name'] == "linkedin") {
                    $placeholder = "LinkedIn Public Profile URL";
                }
                if ($social['name'] == "facebook") {
                    $placeholder = "Facebook Profile ID";
                }
                echo '<li class="'.$social['name'].'"><a href="' . $url . '" target="_blank" title="'.$social['name'].'"></a></li>';
            }
        }
        echo "</ul>";
        echo $after_widget;
    }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;

        /* Strip tags (if needed) and update the widget settings. */
        $instance['title'] = strip_tags($new_instance['title']);

        return $instance;
    }

    function form($instance) {
        ?>
		<p>
			<label>You should add your social elements on Social Options of <a href="admin.php?page=theme_settings">Theme Settings</a> panel</label>
		</p>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">Title:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo isset($instance['title']) ? $instance['title'] : ''; ?>"  />
        </p>
        <?php
    }

}

add_action('widgets_init', create_function('', 'return register_widget("sociallinkswidget");'));
?>
