<!DOCTYPE html>
<!--[if IE 7 ]>    <html class="ie7"> <![endif]-->
<!--[if IE 8 ]>    <html class="ie8"> <![endif]-->
<html <?php language_attributes(); ?>>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <!-- Mobile Specific Metas
        ================================================== -->
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <?php current_title(); ?>
        <?php favicon(); ?>
        <!--[if lt IE 9]><script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script><![endif]-->
        <?php
        print_styles(array(
            'resources/css/prettyPhoto.css',
            'resources/css/font-awesome/font-awesome.min.css',
            'style.css',
            'resources/css/responsive.css',
                'resources/css/options.css',
        ));
        echo '<!--[if IE 7]><link rel="stylesheet" href="' . get_template_directory_uri() . '/resources/css/font-awesome/font-awesome-ie7.min.css"><![endif]-->';
        print_scripts(array(
            'resources/js/superfish.js',
            'resources/js/supersubs.js',
            'resources/js/jquery.jplayer.min.js',
            'resources/js/jquery.prettyPhoto.js',
            'resources/js/jquery.carouFredSel.js',
            'resources/js/jquery.isotope.min.js',
            'resources/js/jquery.linkify.js',
            'resources/js/script.js'
        ));
        ?>
        <?php
        wp_head();
        global $wrapper_start, $wrapper_end;
        $wrapper_start = $wrapper_end = '';
        if (get_settings_value('is_boxed')) {
            $wrapper_start = '<div class="wrapper">';
            $wrapper_end = '</div>';
        }
        ?>

    </head>
    <body <?php body_class() ?>>
        <?php
        echo $wrapper_start;
        /*
          if (get_settings_value('top_widget')) {
          ?>
          <div id="top">
          <!-- Start Container -->
          <div class="container">
          <div class="row">
          <div class="col eight">
          <ul class="top-list clearfix">
          <?php
          if (get_settings_value('contact_phone') != "")
          echo '<li><span class="phone"></span>' . get_settings_value('contact_phone') . '</li>';
          if (get_settings_value('contact_email') != "")
          echo '<li><span class="mail"></span>' . get_settings_value('contact_email') . '</li>';
          if (get_settings_value('contact_address') != "")
          echo '<li><span class="address"></span>' . get_settings_value('contact_address') . '</li>';
          ?>
          </ul>
          </div>
          <div class="col four">
          <?php
          dynamic_sidebar('top-sidebar');
          ?>
          </div>
          </div>
          </div>
          <!-- End Container -->
          </div>
          <?php } */
        ?>
        <!-- Start Header -->
        <header id="header">
            <!-- Start Container -->
            <div class="container">
                <div class="row">
                    <div class="col six">
<?php print_logo(); ?>
                    </div>
                    <div class="col six header-widget">					
<?php dynamic_sidebar('top-sidebar'); ?>
                    </div>
                </div>
                <?php 
                    $class = "twelve";
                    if (get_settings_value('search_menu'))
                        $class = "ten";
                ?>
                <div class="row">
                    <div class="col <?php echo $class;?>">
                        <?php print_menu(); ?>
                    </div>
                    <?php if (get_settings_value('search_menu')) { ?>
                        <div class="col two" style="margin:0;">
                            <div class="widget search_header">
                                <?php echo my_search_form(); ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <!-- End Container -->
        </header>
        <!-- End Header -->
        <?php echo $wrapper_end; ?>
        <?php
        get_template_part('slider');
        ?>
        <!-- Start Main -->
<?php echo $wrapper_start; ?>
        <div id="main">
            <!-- Start Container -->
            <div class="container">
                <div class="row">